/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.gateway;

import ddtrot.dd.appsec.api.blocking.BlockingContentType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Map;

public interface Flow<T> {
    public Action getAction();

    public T getResult();

    @SuppressFBWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"}, justification="Not a singleton")
    public static class ResultFlow<R>
    implements Flow<R> {
        private static final ResultFlow EMPTY = new ResultFlow<Object>(null);
        private final R result;

        public static <R> ResultFlow<R> empty() {
            return EMPTY;
        }

        public ResultFlow(R result) {
            this.result = result;
        }

        @Override
        public Action getAction() {
            return Action.Noop.INSTANCE;
        }

        @Override
        public R getResult() {
            return this.result;
        }
    }

    public static interface Action {
        public boolean isBlocking();

        public static class RequestBlockingAction
        implements Action {
            private final int statusCode;
            private final BlockingContentType blockingContentType;
            private final Map<String, String> extraHeaders;
            private final String securityResponseId;

            public RequestBlockingAction(int statusCode, BlockingContentType blockingContentType, Map<String, String> extraHeaders) {
                this(statusCode, blockingContentType, extraHeaders, null);
            }

            public RequestBlockingAction(int statusCode, BlockingContentType blockingContentType, Map<String, String> extraHeaders, String securityResponseId) {
                this.statusCode = statusCode;
                this.blockingContentType = blockingContentType;
                this.extraHeaders = extraHeaders;
                this.securityResponseId = securityResponseId;
            }

            public RequestBlockingAction(int statusCode, BlockingContentType blockingContentType) {
                this(statusCode, blockingContentType, Collections.emptyMap(), null);
            }

            public static RequestBlockingAction forRedirect(int statusCode, String location) {
                return RequestBlockingAction.forRedirect(statusCode, location, null);
            }

            public static RequestBlockingAction forRedirect(int statusCode, String location, String securityResponseId) {
                return new RequestBlockingAction(statusCode, BlockingContentType.NONE, Collections.singletonMap("Location", location), securityResponseId);
            }

            @Override
            public boolean isBlocking() {
                return true;
            }

            public int getStatusCode() {
                return this.statusCode;
            }

            public BlockingContentType getBlockingContentType() {
                return this.blockingContentType;
            }

            public Map<String, String> getExtraHeaders() {
                return this.extraHeaders;
            }

            public String getSecurityResponseId() {
                return this.securityResponseId;
            }
        }

        public static class Noop
        implements Action {
            public static Action INSTANCE = new Noop();

            private Noop() {
            }

            @Override
            public boolean isBlocking() {
                return false;
            }
        }
    }
}

