/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.datastreams;

import datadog.trace.api.BaseHash;
import ddtrot.dd.trace.util.FNV64Hash;
import java.util.Objects;

public class DataStreamsTags {
    public static DataStreamsTags EMPTY = DataStreamsTags.create(null, null);
    private long hash;
    private long aggregationHash;
    private long completeHash;
    private int nonNullSize;
    protected final String bus;
    protected final String direction;
    protected final Direction directionValue;
    protected final String exchange;
    protected final String topic;
    protected final String type;
    protected final String subscription;
    protected final String datasetName;
    protected final String datasetNamespace;
    protected final String isManual;
    protected final String group;
    protected final String consumerGroup;
    protected final String hasRoutingKey;
    protected final String kafkaClusterId;
    protected final String partition;
    public static final String MANUAL_TAG = "manual_checkpoint";
    public static final String TYPE_TAG = "type";
    public static final String DIRECTION_TAG = "direction";
    public static final String TOPIC_TAG = "topic";
    public static final String BUS_TAG = "bus";
    public static final String PARTITION_TAG = "partition";
    public static final String GROUP_TAG = "group";
    public static final String CONSUMER_GROUP_TAG = "consumer_group";
    public static final String SUBSCRIPTION_TAG = "subscription";
    public static final String EXCHANGE_TAG = "exchange";
    public static final String DATASET_NAME_TAG = "ds.name";
    public static final String DATASET_NAMESPACE_TAG = "ds.namespace";
    public static final String HAS_ROUTING_KEY_TAG = "has_routing_key";
    public static final String KAFKA_CLUSTER_ID_TAG = "kafka_cluster_id";
    private static volatile ThreadLocal<String> serviceNameOverride;

    public static byte[] longToBytes(long val) {
        return new byte[]{(byte)(val >> 56), (byte)(val >> 48), (byte)(val >> 40), (byte)(val >> 32), (byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
    }

    public static DataStreamsTags create(String type, Direction direction) {
        return DataStreamsTags.create(type, direction, null);
    }

    public static DataStreamsTags create(String type, Direction direction, String topic) {
        return DataStreamsTags.createWithGroup(type, direction, topic, null);
    }

    public static DataStreamsTags createWithSubscription(String type, Direction direction, String subscription) {
        return new DataStreamsTags(null, direction, null, null, type, subscription, null, null, null, null, null, null, null, null);
    }

    public static DataStreamsTags create(String type, Direction direction, String topic, String group, String kafkaClusterId) {
        return new DataStreamsTags(null, direction, null, topic, type, null, null, null, null, group, null, null, kafkaClusterId, null);
    }

    public static DataStreamsTags createManual(String type, Direction direction, String topic) {
        return new DataStreamsTags(null, direction, null, topic, type, null, null, null, true, null, null, null, null, null);
    }

    public static DataStreamsTags createWithBus(Direction direction, String bus) {
        return new DataStreamsTags(bus, direction, null, null, BUS_TAG, null, null, null, null, null, null, null, null, null);
    }

    public static DataStreamsTags createWithPartition(String type, String topic, String partition, String kafkaClusterId, String consumerGroup) {
        return new DataStreamsTags(null, null, null, topic, type, null, null, null, null, null, consumerGroup, null, kafkaClusterId, partition);
    }

    public Boolean hasAllTags(String[] tags) {
        block32: for (String tag : tags) {
            if (tag.indexOf(58) == -1) {
                return false;
            }
            String key = tag.substring(0, tag.indexOf(58));
            String value = tag.substring(tag.indexOf(58) + 1);
            switch (key) {
                case "bus": {
                    if (Objects.equals(this.bus, tag)) continue block32;
                    return false;
                }
                case "direction": {
                    if (Objects.equals((Object)this.directionValue, (Object)(Objects.equals(value, "out") ? Direction.OUTBOUND : Direction.INBOUND))) continue block32;
                    return false;
                }
                case "exchange": {
                    if (Objects.equals(this.exchange, tag)) continue block32;
                    return false;
                }
                case "topic": {
                    if (Objects.equals(this.topic, tag)) continue block32;
                    return false;
                }
                case "type": {
                    if (Objects.equals(this.type, tag)) continue block32;
                    return false;
                }
                case "subscription": {
                    if (Objects.equals(this.subscription, tag)) continue block32;
                    return false;
                }
                case "ds.name": {
                    if (Objects.equals(this.datasetName, tag)) continue block32;
                    return false;
                }
                case "ds.namespace": {
                    if (Objects.equals(this.datasetNamespace, tag)) continue block32;
                    return false;
                }
                case "manual_checkpoint": {
                    if (Objects.equals(this.isManual, tag)) continue block32;
                    return false;
                }
                case "group": {
                    if (Objects.equals(this.group, tag)) continue block32;
                    return false;
                }
                case "consumer_group": {
                    if (Objects.equals(this.consumerGroup, tag)) continue block32;
                    return false;
                }
                case "has_routing_key": {
                    if (Objects.equals(this.hasRoutingKey, tag)) continue block32;
                    return false;
                }
                case "kafka_cluster_id": {
                    if (Objects.equals(this.kafkaClusterId, tag)) continue block32;
                    return false;
                }
                case "partition": {
                    if (Objects.equals(this.partition, tag)) continue block32;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static DataStreamsTags createWithGroup(String type, Direction direction, String topic, String group) {
        return new DataStreamsTags(null, direction, null, topic, type, null, null, null, null, group, null, null, null, null);
    }

    public static DataStreamsTags createWithDataset(String type, Direction direction, String topic, String datasetName, String datasetNamespace) {
        return new DataStreamsTags(null, direction, null, topic, type, null, datasetName, datasetNamespace, null, null, null, null, null, null);
    }

    public static void setServiceNameOverride(ThreadLocal<String> serviceNameOverride) {
        DataStreamsTags.serviceNameOverride = serviceNameOverride;
    }

    public static DataStreamsTags createWithClusterId(String type, Direction direction, String topic, String clusterId) {
        return new DataStreamsTags(null, direction, null, topic, type, null, null, null, null, null, null, null, clusterId, null);
    }

    public static DataStreamsTags createWithExchange(String type, Direction direction, String exchange, Boolean hasRoutingKey) {
        return new DataStreamsTags(null, direction, exchange, null, type, null, null, null, false, null, null, hasRoutingKey, null, null);
    }

    public DataStreamsTags(String bus, Direction direction, String exchange, String topic, String type, String subscription, String datasetName, String datasetNamespace, Boolean isManual, String group, String consumerGroup, Boolean hasRoutingKey, String kafkaClusterId, String partition) {
        String tag;
        int i;
        String val;
        this.bus = bus != null ? "bus:" + bus : null;
        this.directionValue = direction;
        this.direction = direction == Direction.INBOUND ? "direction:in" : (direction == Direction.OUTBOUND ? "direction:out" : null);
        this.exchange = exchange != null ? "exchange:" + exchange : null;
        this.topic = topic != null ? "topic:" + topic : null;
        this.type = type != null ? "type:" + type : null;
        this.subscription = subscription != null ? "subscription:" + subscription : null;
        this.datasetName = datasetName != null ? "ds.name:" + datasetName : null;
        this.datasetNamespace = datasetNamespace != null ? "ds.namespace:" + datasetNamespace : null;
        this.isManual = isManual != null ? "manual_checkpoint:" + isManual : null;
        this.group = group != null ? "group:" + group : null;
        this.consumerGroup = consumerGroup != null ? "consumer_group:" + consumerGroup : null;
        this.hasRoutingKey = hasRoutingKey != null ? "has_routing_key:" + hasRoutingKey : null;
        this.kafkaClusterId = kafkaClusterId != null ? "kafka_cluster_id:" + kafkaClusterId : null;
        this.partition = partition != null ? "partition:" + partition : null;
        this.hash = BaseHash.getBaseHash();
        if (serviceNameOverride != null && (val = serviceNameOverride.get()) != null) {
            this.hash = FNV64Hash.continueHash(this.hash, val, FNV64Hash.Version.v1);
        }
        for (i = 0; i < 7; ++i) {
            tag = this.tagByIndex(i);
            if (tag == null) continue;
            ++this.nonNullSize;
            this.hash = FNV64Hash.continueHash(this.hash, tag, FNV64Hash.Version.v1);
        }
        this.aggregationHash = this.hash;
        for (i = 7; i < 12; ++i) {
            tag = this.tagByIndex(i);
            if (tag == null) continue;
            ++this.nonNullSize;
            this.aggregationHash = FNV64Hash.continueHash(this.aggregationHash, tag, FNV64Hash.Version.v1);
        }
        this.completeHash = this.aggregationHash;
        for (i = 12; i < this.size(); ++i) {
            tag = this.tagByIndex(i);
            if (tag == null) continue;
            ++this.nonNullSize;
            this.completeHash = FNV64Hash.continueHash(this.completeHash, tag, FNV64Hash.Version.v1);
        }
    }

    public int size() {
        return 14;
    }

    public String tagByIndex(int index) {
        switch (index) {
            case 0: {
                return this.bus;
            }
            case 1: {
                return this.direction;
            }
            case 2: {
                return this.exchange;
            }
            case 3: {
                return this.topic;
            }
            case 4: {
                return this.type;
            }
            case 5: {
                return this.subscription;
            }
            case 6: {
                return this.kafkaClusterId;
            }
            case 7: {
                return this.datasetName;
            }
            case 8: {
                return this.datasetNamespace;
            }
            case 9: {
                return this.isManual;
            }
            case 10: {
                return this.group;
            }
            case 11: {
                return this.consumerGroup;
            }
            case 12: {
                return this.partition;
            }
            case 13: {
                return this.hasRoutingKey;
            }
        }
        return null;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getType() {
        return this.type;
    }

    public String getIsManual() {
        return this.isManual;
    }

    public String getBus() {
        return this.bus;
    }

    public String getExchange() {
        return this.exchange;
    }

    public Direction getDirectionValue() {
        return this.directionValue;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getDatasetNamespace() {
        return this.datasetNamespace;
    }

    public String getGroup() {
        return this.group;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getKafkaClusterId() {
        return this.kafkaClusterId;
    }

    public String getHasRoutingKey() {
        return this.hasRoutingKey;
    }

    public int nonNullSize() {
        return this.nonNullSize;
    }

    public long getHash() {
        return this.hash;
    }

    public long getAggregationHash() {
        return this.aggregationHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamsTags that = (DataStreamsTags)o;
        return this.completeHash == that.completeHash;
    }

    public int hashCode() {
        return Long.hashCode(this.completeHash);
    }

    public String toString() {
        return "DataStreamsTags{bus='" + this.bus + "', direction='" + this.direction + "', exchange='" + this.exchange + "', topic='" + this.topic + "', type='" + this.type + "', subscription='" + this.subscription + "', datasetName='" + this.datasetName + "', datasetNamespace='" + this.datasetNamespace + "', isManual=" + this.isManual + "', group='" + this.group + "', consumerGroup='" + this.consumerGroup + "', hasRoutingKey='" + this.hasRoutingKey + "', kafkaClusterId='" + this.kafkaClusterId + "', partition='" + this.partition + "', hash='" + this.hash + "', aggregationHash='" + this.aggregationHash + "', size='" + this.size();
    }

    public static enum Direction {
        UNKNOWN,
        INBOUND,
        OUTBOUND;

    }
}

