/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.instrument.utils;

import ddtrot.dd.instrument.utils.ClassLoaderKey;

public final class ClassLoaderIndex {
    private static final ClassLoaderKey[] KEYS = new ClassLoaderKey[1024];
    private static final int SLOT_MASK = KEYS.length - 1;
    private static final int MAX_HASH_ATTEMPTS = 10;

    private ClassLoaderIndex() {
    }

    public static int getClassLoaderKeyId(ClassLoader cl) {
        if (cl == ClassLoaderKey.BOOT_CLASS_LOADER) {
            return 0;
        }
        if (cl == ClassLoaderKey.SYSTEM_CLASS_LOADER) {
            return 1;
        }
        return ClassLoaderIndex.getClassLoaderKey((ClassLoader)cl).keyId;
    }

    /*
     * Enabled aggressive block sorting
     */
    static ClassLoaderKey getClassLoaderKey(ClassLoader cl) {
        int slot;
        ClassLoaderKey existing;
        int hash = System.identityHashCode(cl);
        ClassLoaderKey[] keys = KEYS;
        int slotMask = SLOT_MASK;
        int evictedSlot = -1;
        int i = 1;
        int h = hash;
        while ((existing = keys[slot = slotMask & h]) != null) {
            Object existingCL = existing.get();
            if (existingCL == cl) {
                return existing;
            }
            if (i < 10) {
                if (existingCL == null && evictedSlot < 0) {
                    evictedSlot = slot;
                }
            } else {
                if (evictedSlot >= 0) {
                    slot = evictedSlot;
                    break;
                }
                if (existingCL == null) break;
                slot = slotMask & hash;
                break;
            }
            ++i;
            h = ClassLoaderIndex.rehash(h);
        }
        keys[slot] = new ClassLoaderKey(cl, hash);
        return keys[slot];
    }

    private static int rehash(int oldHash) {
        return Integer.reverseBytes(oldHash * -1640532531) * -1640532531;
    }
}

