/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.instrument.utils;

import ddtrot.dd.instrument.utils.ClassLoaderIndex;
import ddtrot.dd.instrument.utils.ClassLoaderKeyMatcher;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public final class ClassInfoCache<T> {
    private static final int MAX_CAPACITY = 0x100000;
    private static final int MIN_CAPACITY = 16;
    private static final int MAX_HASH_ATTEMPTS = 10;
    private static final int ALL_CLASS_LOADERS = -1;
    static final AtomicLong TICKS = new AtomicLong();
    private final SharedInfo[] shared;
    private final int slotMask;

    public ClassInfoCache(int capacity) {
        if (capacity < 16) {
            capacity = 16;
        } else if (capacity > 0x100000) {
            capacity = 0x100000;
        }
        this.slotMask = -1 >>> Integer.numberOfLeadingZeros(capacity - 1);
        this.shared = new SharedInfo[this.slotMask + 1];
    }

    public T find(CharSequence className) {
        return this.find(className, -1);
    }

    public void share(String className, T info) {
        this.share(className, info, -1);
    }

    public T find(CharSequence className, ClassLoader cl) {
        return this.find(className, ClassLoaderIndex.getClassLoaderKeyId(cl));
    }

    public void share(String className, T info, ClassLoader cl) {
        this.share(className, info, ClassLoaderIndex.getClassLoaderKeyId(cl));
    }

    public T find(CharSequence className, int classLoaderKeyId) {
        int hash = className.hashCode();
        SharedInfo[] shared = this.shared;
        int slotMask = this.slotMask;
        int i = 1;
        int h = hash;
        while (true) {
            block8: {
                block6: {
                    block7: {
                        int slot;
                        SharedInfo existing;
                        if ((existing = shared[slot = slotMask & h]) == null) break block6;
                        if (!existing.className.contentEquals(className)) break block7;
                        if ((classLoaderKeyId ^ existing.classLoaderKeyId) <= 0) {
                            existing.accessed = TICKS.get();
                            return (T)existing.classInfo;
                        }
                        break block6;
                    }
                    if (i < 10) break block8;
                }
                return null;
            }
            ++i;
            h = ClassInfoCache.rehash(h);
        }
    }

    public T find(CharSequence className, ClassLoaderKeyMatcher classLoaderKeyMatcher) {
        int hash = className.hashCode();
        SharedInfo[] shared = this.shared;
        int slotMask = this.slotMask;
        int i = 1;
        int h = hash;
        while (true) {
            block8: {
                block6: {
                    block7: {
                        int slot;
                        SharedInfo existing;
                        if ((existing = shared[slot = slotMask & h]) == null) break block6;
                        if (!existing.className.contentEquals(className)) break block7;
                        if (existing.classLoaderKeyId < 0 || classLoaderKeyMatcher.test(existing.classLoaderKeyId)) {
                            existing.accessed = TICKS.get();
                            return (T)existing.classInfo;
                        }
                        break block6;
                    }
                    if (i < 10) break block8;
                }
                return null;
            }
            ++i;
            h = ClassInfoCache.rehash(h);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void share(String className, T info, int classLoaderKeyId) {
        int slot;
        SharedInfo existing;
        int hash = className.hashCode();
        SharedInfo[] shared = this.shared;
        int slotMask = this.slotMask;
        SharedInfo update = new SharedInfo(className, info, classLoaderKeyId);
        long oldestTick = Long.MAX_VALUE;
        int oldestSlot = -1;
        int i = 1;
        int h = hash;
        while ((existing = shared[slot = slotMask & h]) != null && !existing.equals(update)) {
            long tick = existing.accessed;
            if (i < 10) {
                if (tick < oldestTick) {
                    oldestTick = tick;
                    oldestSlot = slot;
                }
            } else {
                if (oldestSlot < 0 || oldestTick > tick) break;
                slot = oldestSlot;
                break;
            }
            ++i;
            h = ClassInfoCache.rehash(h);
        }
        shared[slot] = update;
        update.accessed = TICKS.getAndIncrement();
    }

    public void clear() {
        Arrays.fill(this.shared, null);
    }

    private static int rehash(int oldHash) {
        return Integer.reverseBytes(oldHash * -1640532531) * -1640532531;
    }

    static final class SharedInfo {
        final String className;
        final Object classInfo;
        final int classLoaderKeyId;
        long accessed;

        SharedInfo(String className, Object classInfo, int classLoaderKeyId) {
            this.className = className;
            this.classInfo = classInfo;
            this.classLoaderKeyId = classLoaderKeyId;
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SharedInfo) {
                return this.className.equals(((SharedInfo)o).className);
            }
            return false;
        }
    }
}

