/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.instrument.classmatch;

import ddtrot.dd.instrument.classmatch.ClassFile;
import ddtrot.dd.instrument.classmatch.ClassMatcher;
import ddtrot.dd.instrument.classmatch.ClassOutline;
import ddtrot.dd.instrument.classmatch.InternalNames;
import ddtrot.dd.instrument.classmatch.MethodMatcher;
import ddtrot.dd.instrument.classmatch.MethodOutline;
import ddtrot.dd.instrument.classmatch.TypeMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

final class InternalMatchers {
    private static final Map<Class<?>, String> PRIMITIVE_DESCRIPTORS = new HashMap();
    static final MethodMatcher ALL_METHODS;

    private InternalMatchers() {
    }

    static Predicate<String[]> declaresAnnotation(String type) {
        String internalName = InternalMatchers.internalName(type);
        ClassFile.annotationOfInterest(internalName);
        Predicate<String> annotationNamed = internalName::equals;
        return annotations -> InternalMatchers.anyMatch(annotations, annotationNamed);
    }

    static Predicate<String[]> declaresAnnotationOneOf(Collection<String> types) {
        InternalNames internalNames = new InternalNames(types);
        ClassFile.annotationsOfInterest(internalNames);
        Predicate<String> annotationNamedOneOf = internalNames::containsType;
        return annotations -> InternalMatchers.anyMatch(annotations, annotationNamedOneOf);
    }

    static boolean hasParamDescriptor(MethodOutline method, int paramIndex, String paramDescriptor) {
        int[] boundaries = method.descriptorBoundaries();
        return paramIndex < boundaries.length && method.descriptor.startsWith(paramDescriptor, boundaries[paramIndex - 1]);
    }

    static String descriptor(String type) {
        if (type.endsWith("[]")) {
            return '[' + InternalMatchers.descriptor(type.substring(0, type.length() - 2));
        }
        switch (type) {
            case "boolean": {
                return "Z";
            }
            case "byte": {
                return "B";
            }
            case "char": {
                return "C";
            }
            case "double": {
                return "D";
            }
            case "float": {
                return "F";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "short": {
                return "S";
            }
            case "void": {
                return "V";
            }
        }
        return 'L' + InternalMatchers.internalName(type) + ';';
    }

    static String descriptor(Class<?> type) {
        if (type.isPrimitive()) {
            return PRIMITIVE_DESCRIPTORS.get(type);
        }
        if (type.isArray()) {
            return InternalMatchers.internalName(type.getName());
        }
        return 'L' + InternalMatchers.internalName(type.getName()) + ';';
    }

    static String internalName(String type) {
        return type.replace('.', '/');
    }

    static <T> boolean anyMatch(T[] candidates, Predicate<T> matcher) {
        for (T c : candidates) {
            if (!matcher.test(c)) continue;
            return true;
        }
        return false;
    }

    static {
        PRIMITIVE_DESCRIPTORS.put(Boolean.TYPE, "Z");
        PRIMITIVE_DESCRIPTORS.put(Byte.TYPE, "B");
        PRIMITIVE_DESCRIPTORS.put(Character.TYPE, "C");
        PRIMITIVE_DESCRIPTORS.put(Double.TYPE, "D");
        PRIMITIVE_DESCRIPTORS.put(Float.TYPE, "F");
        PRIMITIVE_DESCRIPTORS.put(Integer.TYPE, "I");
        PRIMITIVE_DESCRIPTORS.put(Long.TYPE, "J");
        PRIMITIVE_DESCRIPTORS.put(Short.TYPE, "S");
        PRIMITIVE_DESCRIPTORS.put(Void.TYPE, "V");
        ALL_METHODS = new MethodMatcher(){

            @Override
            public boolean test(MethodOutline outline) {
                return true;
            }

            @Override
            public MethodMatcher and(MethodMatcher other) {
                return other;
            }

            @Override
            public MethodMatcher or(MethodMatcher other) {
                return this;
            }
        };
    }

    static abstract class MatcherUnion<M> {
        protected final M[] matchers;

        MatcherUnion(M[] matchers) {
            int n;
            int lhsLength;
            int n2;
            M lhs = matchers[0];
            M rhs = matchers[1];
            Class<?> unionType = this.getClass();
            M[] lhsArray = null;
            M[] rhsArray = null;
            if (unionType.isInstance(lhs)) {
                lhsArray = ((MatcherUnion)lhs).matchers;
                n2 = ((MatcherUnion)lhs).matchers.length;
            } else {
                n2 = lhsLength = 1;
            }
            if (unionType.isInstance(rhs)) {
                rhsArray = ((MatcherUnion)rhs).matchers;
                n = ((MatcherUnion)rhs).matchers.length;
            } else {
                n = 1;
            }
            int rhsLength = n;
            int expandedLength = lhsLength + rhsLength;
            if (expandedLength > 2) {
                int extra = matchers.length - 2;
                matchers = Arrays.copyOf(matchers, expandedLength + extra);
                if (extra > 0) {
                    System.arraycopy(matchers, 2, matchers, expandedLength, extra);
                }
                if (lhsLength > 1) {
                    System.arraycopy(lhsArray, 0, matchers, 0, lhsLength);
                }
                if (rhsLength > 1) {
                    System.arraycopy(rhsArray, 0, matchers, lhsLength, rhsLength);
                } else {
                    matchers[lhsLength] = rhs;
                }
            }
            this.matchers = matchers;
        }
    }

    static final class TypeDisjunction
    extends MatcherUnion<TypeMatcher>
    implements TypeMatcher {
        TypeDisjunction(TypeMatcher lhs, TypeMatcher rhs) {
            super(new TypeMatcher[]{lhs, rhs});
        }

        @Override
        public boolean test(CharSequence typeString) {
            for (TypeMatcher matcher : (TypeMatcher[])this.matchers) {
                if (!matcher.test(typeString)) continue;
                return true;
            }
            return false;
        }
    }

    static final class TypeConjunction
    extends MatcherUnion<TypeMatcher>
    implements TypeMatcher {
        TypeConjunction(TypeMatcher lhs, TypeMatcher rhs) {
            super(new TypeMatcher[]{lhs, rhs});
        }

        @Override
        public boolean test(CharSequence typeString) {
            for (TypeMatcher matcher : (TypeMatcher[])this.matchers) {
                if (matcher.test(typeString)) continue;
                return false;
            }
            return true;
        }
    }

    static final class MethodDisjunction
    extends MatcherUnion<MethodMatcher>
    implements MethodMatcher {
        MethodDisjunction(MethodMatcher lhs, MethodMatcher rhs) {
            super(new MethodMatcher[]{lhs, rhs});
        }

        @Override
        public boolean test(MethodOutline outline) {
            for (MethodMatcher matcher : (MethodMatcher[])this.matchers) {
                if (!matcher.test(outline)) continue;
                return true;
            }
            return false;
        }
    }

    static final class MethodConjunction
    extends MatcherUnion<MethodMatcher>
    implements MethodMatcher {
        MethodConjunction(MethodMatcher lhs, MethodMatcher rhs) {
            super(new MethodMatcher[]{lhs, rhs});
        }

        @Override
        public boolean test(MethodOutline outline) {
            for (MethodMatcher matcher : (MethodMatcher[])this.matchers) {
                if (matcher.test(outline)) continue;
                return false;
            }
            return true;
        }
    }

    static final class ClassDisjunction
    extends MatcherUnion<ClassMatcher>
    implements ClassMatcher {
        ClassDisjunction(ClassMatcher lhs, ClassMatcher rhs) {
            super(new ClassMatcher[]{lhs, rhs});
        }

        @Override
        public boolean test(ClassOutline outline) {
            for (ClassMatcher matcher : (ClassMatcher[])this.matchers) {
                if (!matcher.test(outline)) continue;
                return true;
            }
            return false;
        }
    }

    static final class ClassConjunction
    extends MatcherUnion<ClassMatcher>
    implements ClassMatcher {
        ClassConjunction(ClassMatcher lhs, ClassMatcher rhs) {
            super(new ClassMatcher[]{lhs, rhs});
        }

        @Override
        public boolean test(ClassOutline outline) {
            for (ClassMatcher matcher : (ClassMatcher[])this.matchers) {
                if (matcher.test(outline)) continue;
                return false;
            }
            return true;
        }
    }
}

