/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.instrument.classmatch;

import java.lang.reflect.Modifier;
import java.util.function.IntPredicate;

@FunctionalInterface
public interface AccessMatcher
extends IntPredicate {
    public static final AccessMatcher PUBLIC = Modifier::isPublic;
    public static final AccessMatcher PRIVATE = Modifier::isPrivate;
    public static final AccessMatcher PROTECTED = Modifier::isProtected;
    public static final AccessMatcher PACKAGE_PRIVATE = acc -> (acc & 7) == 0;
    public static final AccessMatcher STATIC = Modifier::isStatic;
    public static final AccessMatcher INSTANCE = acc -> (acc & 8) == 0;
    public static final AccessMatcher FINAL = Modifier::isFinal;
    public static final AccessMatcher NON_FINAL = acc -> (acc & 0x10) == 0;
    public static final AccessMatcher SYNCHRONIZED = Modifier::isSynchronized;
    public static final AccessMatcher VARARGS = acc -> (acc & 0x80) != 0;
    public static final AccessMatcher VOLATILE = Modifier::isVolatile;
    public static final AccessMatcher TRANSIENT = Modifier::isTransient;
    public static final AccessMatcher INTERFACE = Modifier::isInterface;
    public static final AccessMatcher CLASS = acc -> (acc & 0x200) == 0;
    public static final AccessMatcher ABSTRACT = Modifier::isAbstract;
    public static final AccessMatcher CONCRETE = acc -> (acc & 0x400) == 0;

    default public AccessMatcher and(AccessMatcher other) {
        return acc -> this.test(acc) && other.test(acc);
    }

    default public AccessMatcher or(AccessMatcher other) {
        return acc -> this.test(acc) || other.test(acc);
    }
}

