/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.monitor;

import datadog.trace.api.Config;
import datadog.trace.api.ProcessTags;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.StatsDClientManager;
import ddtrot.dd.communication.monitor.DDAgentStatsDClient;
import ddtrot.dd.communication.monitor.DDAgentStatsDConnection;
import ddtrot.dd.communication.monitor.LoggingStatsDClient;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public final class DDAgentStatsDClientManager
implements StatsDClientManager {
    private static final DDAgentStatsDClientManager INSTANCE = new DDAgentStatsDClientManager();
    private static final boolean USE_LOGGING_CLIENT = "LoggingWriter".equals(Config.get().getWriterType());
    private static final AtomicInteger defaultStatsDPort = new AtomicInteger(Config.get().getDogsStatsDPort());
    private final ConcurrentHashMap<String, DDAgentStatsDConnection> connectionPool = new ConcurrentHashMap(4);

    private DDAgentStatsDClientManager() {
    }

    public static StatsDClientManager statsDClientManager() {
        return INSTANCE;
    }

    public static void setDefaultStatsDPort(int newPort) {
        if (newPort > 0 && defaultStatsDPort.getAndSet(newPort) != newPort) {
            INSTANCE.handleDefaultPortChange(newPort);
        }
    }

    public static int getDefaultStatsDPort() {
        return defaultStatsDPort.get();
    }

    @Override
    public StatsDClient statsDClient(String host, Integer port, String namedPipe, String namespace, String[] constantTags, boolean useAggregation) {
        List<String> processTags;
        NameResolver nameMapping = Function.identity();
        TagCombiner tagMapping = Function.identity();
        if (null != namespace) {
            nameMapping = new NameResolver(namespace);
        }
        int processTagSize = (processTags = ProcessTags.getTagsAsStringList()) != null ? processTags.size() : 0;
        String[] finalConstantTags = constantTags;
        if (processTagSize > 0) {
            int constantTagSize;
            int n = constantTagSize = constantTags != null ? constantTags.length : 0;
            if (constantTagSize == 0) {
                finalConstantTags = processTags.toArray(new String[0]);
            } else {
                int tagSizeSum = processTagSize + constantTagSize;
                finalConstantTags = new String[tagSizeSum];
                for (int pos = 0; pos < constantTagSize; ++pos) {
                    finalConstantTags[pos] = constantTags[pos];
                }
                for (int i = 0; i < processTagSize; ++i) {
                    finalConstantTags[pos + i] = processTags.get(i);
                }
            }
        }
        if (null != finalConstantTags && finalConstantTags.length > 0) {
            tagMapping = new TagCombiner(finalConstantTags);
        }
        if (USE_LOGGING_CLIENT) {
            return new LoggingStatsDClient(nameMapping, tagMapping);
        }
        return new DDAgentStatsDClient(this.getConnection(host, port, namedPipe, useAggregation), nameMapping, tagMapping);
    }

    private DDAgentStatsDConnection getConnection(String host, Integer port, String namedPipe, boolean useAggregation) {
        DDAgentStatsDConnection newConnection;
        String connectionKey = DDAgentStatsDClientManager.getConnectionKey(host, port, namedPipe, useAggregation);
        DDAgentStatsDConnection connection = this.connectionPool.get(connectionKey);
        if (null == connection && null == (connection = this.connectionPool.putIfAbsent(connectionKey, newConnection = new DDAgentStatsDConnection(host, port, namedPipe, useAggregation)))) {
            connection = newConnection;
        }
        return connection;
    }

    private static String getConnectionKey(String host, Integer port, String namedPipe, boolean useAggregation) {
        if (namedPipe != null) {
            return namedPipe + (useAggregation ? "" : ":no_aggregation");
        }
        return (null != host ? host : "?") + ":" + (null != port ? port : "?") + (useAggregation ? "" : ":no_aggregation");
    }

    private void handleDefaultPortChange(int newPort) {
        for (DDAgentStatsDConnection connection : this.connectionPool.values()) {
            connection.handleDefaultPortChange(newPort);
        }
    }

    static final class NameResolver
    implements Function<String, String> {
        private final DDCache<String, String> resolvedNames = DDCaches.newFixedSizeCache(32);
        private final Function<String, String> namePrefixer;

        NameResolver(final String namespace) {
            this.namePrefixer = new Function<String, String>(){
                private final String prefix;
                {
                    this.prefix = namespace + '.';
                }

                @Override
                public String apply(String metricName) {
                    return this.prefix + metricName;
                }
            };
        }

        @Override
        public String apply(String metricName) {
            return this.resolvedNames.computeIfAbsent(metricName, this.namePrefixer);
        }
    }

    static final class TagCombiner
    implements Function<String[], String[]> {
        private final DDCache<String[], String[]> combinedTags = DDCaches.newFixedSizeArrayKeyCache(64);
        private final String[] packedTags;
        private final Function<String[], String[]> tagsInserter;

        public TagCombiner(String[] constantTags) {
            this.packedTags = TagCombiner.pack(constantTags);
            this.tagsInserter = tags -> {
                String[] result = new String[((String[])tags).length + 1];
                System.arraycopy(tags, 0, result, 1, ((String[])tags).length);
                result[0] = this.packedTags[0];
                return result;
            };
        }

        @Override
        public String[] apply(String[] tags) {
            if (null == tags || tags.length == 0) {
                return this.packedTags;
            }
            return this.combinedTags.computeIfAbsent(tags, this.tagsInserter);
        }

        private static String[] pack(String[] tags) {
            StringBuilder buf = new StringBuilder(tags[0]);
            for (int i = 1; i < tags.length; ++i) {
                buf.append(',').append(tags[i]);
            }
            return new String[]{buf.toString()};
        }
    }
}

