/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.ddagent;

import datadog.trace.api.BaseHash;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.common.container.ContainerInfo;
import ddtrot.dd.communication.ddagent.AgentVersion;
import ddtrot.dd.communication.ddagent.DroppingPolicy;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.monitor.DDAgentStatsDClientManager;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.trace.api.telemetry.LogCollector;
import ddtrot.dd.trace.util.Strings;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.Response;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentFeaturesDiscovery
implements DroppingPolicy {
    private static final Logger log = LoggerFactory.getLogger(DDAgentFeaturesDiscovery.class);
    private static final JsonAdapter<Map<String, Object>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter(Types.newParameterizedType(Map.class, new Type[]{String.class, Object.class}));
    private static final byte[] PROBE_MESSAGE = new byte[]{-110, -112, -112};
    public static final String V3_ENDPOINT = "v0.3/traces";
    public static final String V4_ENDPOINT = "v0.4/traces";
    public static final String V5_ENDPOINT = "v0.5/traces";
    public static final String V6_METRICS_ENDPOINT = "v0.6/stats";
    public static final String V7_CONFIG_ENDPOINT = "v0.7/config";
    public static final String V01_DATASTREAMS_ENDPOINT = "v0.1/pipeline_stats";
    public static final String V2_EVP_PROXY_ENDPOINT = "evp_proxy/v2/";
    public static final String V4_EVP_PROXY_ENDPOINT = "evp_proxy/v4/";
    public static final String DATADOG_AGENT_STATE = "Datadog-Agent-State";
    public static final String DEBUGGER_ENDPOINT_V1 = "debugger/v1/input";
    public static final String DEBUGGER_ENDPOINT_V2 = "debugger/v2/input";
    public static final String DEBUGGER_DIAGNOSTICS_ENDPOINT = "debugger/v1/diagnostics";
    public static final String TELEMETRY_PROXY_ENDPOINT = "telemetry/proxy/";
    private static final long MIN_FEATURE_DISCOVERY_INTERVAL_MILLIS = 60000L;
    private final OkHttpClient client;
    private final HttpUrl agentBaseUrl;
    private final Recording discoveryTimer;
    private final String[] traceEndpoints;
    private final String[] metricsEndpoints = new String[]{"v0.6/stats"};
    private final String[] configEndpoints = new String[]{"v0.7/config"};
    private final boolean metricsEnabled;
    private final String[] dataStreamsEndpoints = new String[]{"v0.1/pipeline_stats"};
    private final String[] evpProxyEndpoints = new String[]{"evp_proxy/v4/", "evp_proxy/v2/"};
    private final String[] telemetryProxyEndpoints = new String[]{"telemetry/proxy/"};
    private volatile State discoveryState;

    public DDAgentFeaturesDiscovery(OkHttpClient client, Monitoring monitoring, HttpUrl agentUrl, boolean enableV05Traces, boolean metricsEnabled) {
        String[] stringArray;
        this.client = client;
        this.agentBaseUrl = agentUrl;
        this.metricsEnabled = metricsEnabled;
        if (enableV05Traces) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = V5_ENDPOINT;
            stringArray2[1] = V4_ENDPOINT;
            stringArray = stringArray2;
            stringArray2[2] = V3_ENDPOINT;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = V4_ENDPOINT;
            stringArray = stringArray3;
            stringArray3[1] = V3_ENDPOINT;
        }
        this.traceEndpoints = stringArray;
        this.discoveryTimer = monitoring.newTimer("trace.agent.discovery.time");
        this.discoveryState = new State();
    }

    public void discover() {
        this.discoverIfOutdated(0L);
    }

    public void discoverIfOutdated() {
        this.discoverIfOutdated(this.getFeaturesDiscoveryMinDelayMillis());
    }

    protected long getFeaturesDiscoveryMinDelayMillis() {
        return 60000L;
    }

    private synchronized void discoverIfOutdated(long maxElapsedMs) {
        long now = System.currentTimeMillis();
        long elapsed = now - this.discoveryState.lastTimeDiscovered;
        if (elapsed > maxElapsedMs) {
            State newState = new State();
            this.doDiscovery(newState);
            newState.lastTimeDiscovered = now;
            this.discoveryState = newState;
        }
    }

    private void doDiscovery(State newState) {
        try (Recording recording = this.discoveryTimer.start();){
            boolean fallback = true;
            Request.Builder requestBuilder = new Request.Builder().url(this.agentBaseUrl.resolve("info").url());
            String containerId = ContainerInfo.get().getContainerId();
            if (containerId != null) {
                requestBuilder.header("Datadog-Container-ID", containerId);
            }
            try (Response response = this.client.newCall(requestBuilder.build()).execute();){
                if (response.isSuccessful()) {
                    this.processInfoResponseHeaders(response);
                    fallback = !this.processInfoResponse(newState, response.body().string());
                }
            }
            catch (Throwable error) {
                this.errorQueryingEndpoint("info", error);
            }
            if (fallback) {
                newState.supportsClientSideStats = false;
                newState.supportsLongRunning = false;
                log.debug("Falling back to probing, client dropping will be disabled");
                newState.metricsEndpoint = null;
            }
            if (null == newState.traceEndpoint) {
                newState.traceEndpoint = this.probeTracesEndpoint(newState, this.traceEndpoints);
            } else if (newState.state == null || newState.state.isEmpty()) {
                this.probeTracesEndpoint(newState, new String[]{newState.traceEndpoint});
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("discovered traceEndpoint={}, metricsEndpoint={}, supportsDropping={}, supportsLongRunning={}, dataStreamsEndpoint={}, configEndpoint={}, evpProxyEndpoint={}, telemetryProxyEndpoint={}", new Object[]{newState.traceEndpoint, newState.metricsEndpoint, newState.supportsDropping, newState.supportsLongRunning, newState.dataStreamsEndpoint, newState.configEndpoint, newState.evpProxyEndpoint, newState.telemetryProxyEndpoint});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String probeTracesEndpoint(State newState, String[] endpoints) {
        String[] stringArray = endpoints;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            try (Response response = this.client.newCall(new Request.Builder().put(OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(ByteBuffer.wrap(PROBE_MESSAGE)))).url(this.agentBaseUrl.resolve(candidate)).build()).execute();){
                if (response.code() != 404) {
                    newState.state = response.header(DATADOG_AGENT_STATE);
                    String string = candidate;
                    return string;
                }
            }
            catch (Throwable e) {
                this.errorQueryingEndpoint(candidate, e);
            }
            ++n2;
        }
        return V3_ENDPOINT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInfoResponseHeaders(Response response) {
        String newContainerTagsHash = response.header("Datadog-Container-Tags-Hash");
        if (newContainerTagsHash != null) {
            ContainerInfo containerInfo;
            ContainerInfo containerInfo2 = containerInfo = ContainerInfo.get();
            synchronized (containerInfo2) {
                if (!newContainerTagsHash.equals(containerInfo.getContainerTagsHash())) {
                    containerInfo.setContainerTagsHash(newContainerTagsHash);
                    BaseHash.recalcBaseHash(newContainerTagsHash);
                }
            }
        }
    }

    private boolean processInfoResponse(State newState, String response) {
        try {
            Map<String, Object> map = RESPONSE_ADAPTER.fromJson(response);
            DDAgentFeaturesDiscovery.discoverStatsDPort(map);
            newState.version = (String)map.get("version");
            HashSet<String> endpoints = new HashSet<String>((List)map.get("endpoints"));
            String foundMetricsEndpoint = null;
            if (this.metricsEnabled) {
                for (String endpoint : this.metricsEndpoints) {
                    if (!DDAgentFeaturesDiscovery.containsEndpoint(endpoints, endpoint)) continue;
                    foundMetricsEndpoint = endpoint;
                    break;
                }
            }
            newState.metricsEndpoint = foundMetricsEndpoint;
            for (String endpoint : this.traceEndpoints) {
                if (!DDAgentFeaturesDiscovery.containsEndpoint(endpoints, endpoint)) continue;
                newState.traceEndpoint = endpoint;
                break;
            }
            for (String endpoint : this.configEndpoints) {
                if (!DDAgentFeaturesDiscovery.containsEndpoint(endpoints, endpoint)) continue;
                newState.configEndpoint = endpoint;
                break;
            }
            if (DDAgentFeaturesDiscovery.containsEndpoint(endpoints, DEBUGGER_ENDPOINT_V1)) {
                newState.debuggerLogEndpoint = DEBUGGER_ENDPOINT_V1;
            }
            if (DDAgentFeaturesDiscovery.containsEndpoint(endpoints, DEBUGGER_ENDPOINT_V2)) {
                newState.debuggerSnapshotEndpoint = DEBUGGER_ENDPOINT_V2;
            } else if (DDAgentFeaturesDiscovery.containsEndpoint(endpoints, DEBUGGER_DIAGNOSTICS_ENDPOINT)) {
                newState.debuggerSnapshotEndpoint = DEBUGGER_DIAGNOSTICS_ENDPOINT;
            }
            if (DDAgentFeaturesDiscovery.containsEndpoint(endpoints, DEBUGGER_DIAGNOSTICS_ENDPOINT)) {
                newState.debuggerDiagnosticsEndpoint = DEBUGGER_DIAGNOSTICS_ENDPOINT;
            }
            for (String endpoint : this.dataStreamsEndpoints) {
                if (!DDAgentFeaturesDiscovery.containsEndpoint(endpoints, endpoint)) continue;
                newState.dataStreamsEndpoint = endpoint;
                break;
            }
            for (String endpoint : this.evpProxyEndpoints) {
                if (!DDAgentFeaturesDiscovery.containsEndpoint(endpoints, endpoint)) continue;
                newState.evpProxyEndpoint = endpoint;
                break;
            }
            for (String endpoint : this.telemetryProxyEndpoints) {
                if (!DDAgentFeaturesDiscovery.containsEndpoint(endpoints, endpoint)) continue;
                newState.telemetryProxyEndpoint = endpoint;
                break;
            }
            newState.supportsLongRunning = Boolean.TRUE.equals(map.getOrDefault("long_running_spans", false));
            if (this.metricsEnabled) {
                Object canDrop = map.get("client_drop_p0s");
                newState.supportsDropping = null != canDrop && ("true".equalsIgnoreCase(String.valueOf(canDrop)) || Boolean.TRUE.equals(canDrop));
                newState.supportsClientSideStats = newState.supportsDropping && !AgentVersion.isVersionBelow(newState.version, 7, 65, 0);
                Object peer_tags = map.get("peer_tags");
                newState.peerTags = peer_tags instanceof List ? Collections.unmodifiableSet(new HashSet((List)peer_tags)) : Collections.emptySet();
            }
            try {
                newState.state = Strings.sha256(response);
            }
            catch (NoSuchAlgorithmException ex) {
                log.debug("Failed to hash trace agent /info response. Will probe {}", (Object)newState.traceEndpoint, (Object)ex);
            }
            return true;
        }
        catch (Throwable error) {
            log.debug("Error parsing trace agent /info response", error);
            return false;
        }
    }

    private static boolean containsEndpoint(Set<String> endpoints, String endpoint) {
        return endpoints.contains(endpoint) || endpoints.contains("/" + endpoint);
    }

    private static void discoverStatsDPort(Map<String, Object> info) {
        try {
            Map config = (Map)info.get("config");
            if (config == null) {
                log.debug("config missing from trace agent /info response");
                return;
            }
            Object statsdPortObj = config.get("statsd_port");
            if (statsdPortObj == null) {
                log.debug("statsd_port missing from trace agent /info response");
                return;
            }
            int statsdPort = ((Number)statsdPortObj).intValue();
            DDAgentStatsDClientManager.setDefaultStatsDPort(statsdPort);
        }
        catch (Throwable ex) {
            log.debug("statsd_port missing from trace agent /info response", ex);
        }
    }

    public boolean supportsMetrics() {
        return this.metricsEnabled && null != this.discoveryState.metricsEndpoint && this.discoveryState.supportsClientSideStats;
    }

    public boolean supportsDebugger() {
        return this.discoveryState.debuggerLogEndpoint != null;
    }

    public String getDebuggerSnapshotEndpoint() {
        return this.discoveryState.debuggerSnapshotEndpoint;
    }

    public String getDebuggerLogEndpoint() {
        return this.discoveryState.debuggerLogEndpoint;
    }

    public boolean supportsDebuggerDiagnostics() {
        return this.discoveryState.debuggerDiagnosticsEndpoint != null;
    }

    public boolean supportsLongRunning() {
        return this.discoveryState.supportsLongRunning;
    }

    public Set<String> peerTags() {
        return this.discoveryState.peerTags;
    }

    public String getMetricsEndpoint() {
        return this.discoveryState.metricsEndpoint;
    }

    public String getTraceEndpoint() {
        return this.discoveryState.traceEndpoint;
    }

    public String getDataStreamsEndpoint() {
        return this.discoveryState.dataStreamsEndpoint;
    }

    public String getEvpProxyEndpoint() {
        return this.discoveryState.evpProxyEndpoint;
    }

    public HttpUrl buildUrl(String endpoint) {
        return this.agentBaseUrl.resolve(endpoint);
    }

    public boolean supportsDataStreams() {
        return this.discoveryState.dataStreamsEndpoint != null;
    }

    public boolean supportsEvpProxy() {
        return this.discoveryState.evpProxyEndpoint != null;
    }

    public boolean supportsContentEncodingHeadersWithEvpProxy() {
        String evpProxyEndpoint = this.discoveryState.evpProxyEndpoint;
        return evpProxyEndpoint != null && V4_EVP_PROXY_ENDPOINT.compareTo(evpProxyEndpoint) <= 0;
    }

    public String getConfigEndpoint() {
        return this.discoveryState.configEndpoint;
    }

    public String getVersion() {
        return this.discoveryState.version;
    }

    private void errorQueryingEndpoint(String endpoint, Throwable t) {
        log.debug(LogCollector.EXCLUDE_TELEMETRY, "Error querying {} at {}", new Object[]{endpoint, this.agentBaseUrl, t});
    }

    public String state() {
        return this.discoveryState.state;
    }

    @Override
    public boolean active() {
        return this.supportsMetrics();
    }

    public boolean supportsTelemetryProxy() {
        return this.discoveryState.telemetryProxyEndpoint != null;
    }

    private static class State {
        String traceEndpoint;
        String metricsEndpoint;
        String dataStreamsEndpoint;
        boolean supportsLongRunning;
        boolean supportsClientSideStats;
        boolean supportsDropping;
        String state;
        String configEndpoint;
        String debuggerLogEndpoint;
        String debuggerSnapshotEndpoint;
        String debuggerDiagnosticsEndpoint;
        String evpProxyEndpoint;
        String version;
        String telemetryProxyEndpoint;
        Set<String> peerTags = Collections.emptySet();
        long lastTimeDiscovered;

        private State() {
        }
    }
}

