/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.ddagent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentVersion {
    private static final Logger log = LoggerFactory.getLogger(AgentVersion.class);

    public static boolean isVersionBelow(String version, int maxMajor, int maxMinor, int maxPatch) {
        if (version == null || version.isEmpty()) {
            return true;
        }
        try {
            int patchEnd;
            int majorDot = version.indexOf(46);
            if (majorDot == -1) {
                return true;
            }
            int major = Integer.parseInt(version.substring(0, majorDot));
            if (major < maxMajor) {
                return true;
            }
            if (major > maxMajor) {
                return false;
            }
            int minorDot = version.indexOf(46, majorDot + 1);
            if (minorDot == -1) {
                return true;
            }
            int minor = Integer.parseInt(version.substring(majorDot + 1, minorDot));
            if (minor < maxMinor) {
                return true;
            }
            if (minor > maxMinor) {
                return false;
            }
            for (patchEnd = minorDot + 1; patchEnd < version.length() && Character.isDigit(version.charAt(patchEnd)); ++patchEnd) {
            }
            int patch = Integer.parseInt(version.substring(minorDot + 1, patchEnd));
            if (patch != maxPatch) {
                return patch < maxPatch;
            }
            return patchEnd < version.length();
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return true;
        }
    }
}

