/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication;

import datadog.trace.api.Config;
import ddtrot.dd.communication.BackendApi;
import ddtrot.dd.communication.EvpProxyApi;
import ddtrot.dd.communication.IntakeApi;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.communication.http.HttpRetryPolicy;
import ddtrot.dd.trace.api.intake.Intake;
import ddtrot.dd.trace.util.throwable.FatalAgentMisconfigurationError;
import ddtrot.okhttp3.HttpUrl;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendApiFactory {
    private static final Logger log = LoggerFactory.getLogger(BackendApiFactory.class);
    private final Config config;
    private final SharedCommunicationObjects sharedCommunicationObjects;

    public BackendApiFactory(Config config, SharedCommunicationObjects sharedCommunicationObjects) {
        this.config = config;
        this.sharedCommunicationObjects = sharedCommunicationObjects;
    }

    @Nullable
    public BackendApi createBackendApi(Intake intake) {
        HttpRetryPolicy.Factory retryPolicyFactory = new HttpRetryPolicy.Factory(5, 100, 2.0, true);
        if (intake.isAgentlessEnabled(this.config)) {
            HttpUrl agentlessUrl = HttpUrl.get(intake.getAgentlessUrl(this.config));
            String apiKey = this.config.getApiKey();
            if (apiKey == null || apiKey.isEmpty()) {
                throw new FatalAgentMisconfigurationError("Agentless mode is enabled and api key is not set. Please set application key");
            }
            String traceId = this.config.getIdGenerationStrategy().generateTraceId().toString();
            return new IntakeApi(agentlessUrl, apiKey, traceId, retryPolicyFactory, this.sharedCommunicationObjects.getIntakeHttpClient(), true);
        }
        DDAgentFeaturesDiscovery featuresDiscovery = this.sharedCommunicationObjects.featuresDiscovery(this.config);
        featuresDiscovery.discoverIfOutdated();
        if (featuresDiscovery.supportsEvpProxy()) {
            String traceId = this.config.getIdGenerationStrategy().generateTraceId().toString();
            String evpProxyEndpoint = featuresDiscovery.getEvpProxyEndpoint();
            HttpUrl evpProxyUrl = this.sharedCommunicationObjects.agentUrl.resolve(evpProxyEndpoint);
            String subdomain = intake.getUrlPrefix();
            return new EvpProxyApi(traceId, evpProxyUrl, subdomain, retryPolicyFactory, this.sharedCommunicationObjects.agentHttpClient, true);
        }
        log.warn("Cannot create backend API client since agentless mode is disabled, and agent does not support EVP proxy");
        return null;
    }
}

