/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.TypeConverter;
import datadog.trace.api.Config;
import datadog.trace.context.TraceScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OTScopeManager
implements ScopeManager {
    static final Logger log = LoggerFactory.getLogger(OTScopeManager.class);
    private final TypeConverter converter;
    private final AgentTracer.TracerAPI tracer;

    OTScopeManager(AgentTracer.TracerAPI tracer, TypeConverter converter) {
        this.tracer = tracer;
        this.converter = converter;
    }

    public Scope activate(Span span) {
        return this.activate(span, false);
    }

    public Scope activate(Span span, boolean finishSpanOnClose) {
        if (null == span) {
            return null;
        }
        AgentSpan agentSpan = this.converter.toAgentSpan(span);
        AgentScope agentScope = this.tracer.activateManualSpan(agentSpan);
        return this.converter.toScope(agentScope, finishSpanOnClose);
    }

    @Deprecated
    public Scope active() {
        AgentSpan agentSpan = this.tracer.activeSpan();
        if (null == agentSpan) {
            return null;
        }
        return new OTScope(new FakeScope(agentSpan), false, this.converter);
    }

    public Span activeSpan() {
        return this.converter.toSpan(this.tracer.activeSpan());
    }

    static class OTScope
    implements Scope,
    TraceScope {
        private final AgentScope delegate;
        private final boolean finishSpanOnClose;
        private final TypeConverter converter;

        OTScope(AgentScope delegate, boolean finishSpanOnClose, TypeConverter converter) {
            this.delegate = delegate;
            this.finishSpanOnClose = finishSpanOnClose;
            this.converter = converter;
        }

        public void close() {
            this.delegate.close();
            if (this.finishSpanOnClose) {
                this.delegate.span().finish();
            }
        }

        public Span span() {
            return this.converter.toSpan(this.delegate.span());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OTScope)) {
                return false;
            }
            OTScope otScope = (OTScope)o;
            return this.delegate.span().equals(otScope.delegate.span());
        }

        public int hashCode() {
            return this.delegate.span().hashCode();
        }

        boolean isFinishSpanOnClose() {
            return this.finishSpanOnClose;
        }
    }

    private final class FakeScope
    implements AgentScope {
        private final AgentSpan agentSpan;

        FakeScope(AgentSpan agentSpan) {
            this.agentSpan = agentSpan;
        }

        @Override
        public AgentSpan span() {
            return this.agentSpan;
        }

        @Override
        public void close() {
            if (this.agentSpan == OTScopeManager.this.tracer.activeSpan()) {
                OTScopeManager.this.tracer.closeActive();
            } else {
                if (Config.get().isScopeStrictMode()) {
                    throw new RuntimeException("Tried to close " + this.agentSpan + " scope when not on top");
                }
                log.warn("Tried to close {} scope when not on top", (Object)this.agentSpan);
            }
        }
    }
}

