/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import ddtrot.dd.environment.JavaVirtualMachine;
import ddtrot.dd.environment.OperatingSystem;
import ddtrot.dd.environment.SystemProperties;
import ddtrot.dd.trace.config.inversion.ConfigHelper;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressForbidden
public final class PidHelper {
    private static final Logger log = LoggerFactory.getLogger(PidHelper.class);
    private static final String PID = PidHelper.findPid();
    private static final long PID_AS_LONG = PidHelper.parsePid();

    public static String getPid() {
        return PID;
    }

    public static long getPidAsLong() {
        return PID_AS_LONG;
    }

    private static String findPid() {
        String pid = "";
        if (JavaVirtualMachine.isJavaVersionAtLeast(9)) {
            try {
                pid = ((String)((Supplier)Class.forName("ddtrot.dd.trace.util.JDK9PidSupplier").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).get()).trim();
            }
            catch (Throwable e) {
                log.debug("JDK9PidSupplier not available", e);
            }
        }
        if (pid.isEmpty()) {
            try {
                String vmId = ManagementFactory.getRuntimeMXBean().getName();
                int pidEnd = vmId.indexOf(64);
                if (pidEnd > 0) {
                    pid = vmId.substring(0, pidEnd).trim();
                }
            }
            catch (Throwable e) {
                log.debug("Process id not available", e);
            }
        }
        return pid;
    }

    private static String getTempDir() {
        if (!JavaVirtualMachine.isJ9()) {
            if (OperatingSystem.isLinux()) {
                return "/tmp";
            }
            if (OperatingSystem.isWindows()) {
                return Stream.of("TMP", "TEMP", "USERPROFILE").map(ConfigHelper::env).filter(Objects::nonNull).filter(((Predicate<String>)String::isEmpty).negate()).findFirst().orElse("C:\\Windows");
            }
            if (OperatingSystem.isMacOs()) {
                return ConfigHelper.env("TMPDIR");
            }
            return SystemProperties.get("java.io.tmpdir");
        }
        try {
            return (String)Class.forName("openj9.internal.tools.attach.target.IPC").getDeclaredMethod("getTmpDir", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            String tmpDir = SystemProperties.get("java.io.tmpdir");
            if (tmpDir != null && !tmpDir.isEmpty()) {
                return tmpDir;
            }
            if (OperatingSystem.isWindows()) {
                return "C:\\Documents";
            }
            return "/tmp";
        }
    }

    private static Path getJavaProcessesDir() {
        if (JavaVirtualMachine.isJ9()) {
            return Paths.get(PidHelper.getTempDir(), ".com_ibm_tools_attach");
        }
        return Paths.get(PidHelper.getTempDir(), "hsperfdata_" + SystemProperties.get("user.name"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getJavaPids() {
        try (Stream<Path> stream = Files.list(PidHelper.getJavaProcessesDir());){
            Set<String> set = stream.map(Path::getFileName).map(Path::toString).filter(name -> {
                if (name.isEmpty()) {
                    return false;
                }
                char c = name.charAt(0);
                if (c < '0' || c > '9') {
                    return false;
                }
                long pid = -1L;
                try {
                    pid = Long.parseLong(name);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return pid != -1L;
            }).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            log.debug("Unable to obtain Java PIDs", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private static long parsePid() {
        if (!PID.isEmpty()) {
            try {
                return Long.parseLong(PID);
            }
            catch (NumberFormatException e) {
                log.warn("Cannot parse PID {} as number. Default to 0", (Object)PID, (Object)e);
            }
        }
        return 0L;
    }
}

