/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class StackTraces {
    private static final Pattern FRAME = Pattern.compile("^\\s*at ([^(]+)(\\(.*)$");
    private static final int HEAD_LINES = 8;
    private static final int TAIL_LINES = 4;

    private StackTraces() {
    }

    public static String getStackTrace(Throwable t, int maxChars) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String trace = sw.toString();
        try {
            return StackTraces.truncate(trace, maxChars);
        }
        catch (Exception e) {
            return trace;
        }
    }

    static String truncate(String trace, int maxChars) {
        if (trace.length() <= maxChars) {
            return trace;
        }
        if ((trace = StackTraces.abbreviatePackageNames(trace)).length() <= maxChars) {
            return trace;
        }
        if ((trace = StackTraces.removeStackTraceMiddleForEachException(trace)).length() <= maxChars) {
            return trace;
        }
        String cutMessage = "\t... trace centre-cut to " + maxChars + " chars ...";
        int retainedLength = maxChars - cutMessage.length() - 2;
        int half = retainedLength / 2;
        return trace.substring(0, half) + System.lineSeparator() + cutMessage + System.lineSeparator() + trace.substring(trace.length() - (retainedLength - half));
    }

    private static String abbreviatePackageNames(String trace) {
        StringBuilder sb = new StringBuilder(trace.length());
        new BufferedReader(new StringReader(trace)).lines().forEach(line -> {
            Matcher m = FRAME.matcher((CharSequence)line);
            if (m.matches()) {
                sb.append("\tat ").append(StackTraces.abbreviatePackageName(m.group(1))).append(m.group(2));
            } else {
                sb.append((String)line);
            }
            sb.append(System.lineSeparator());
        });
        return sb.toString();
    }

    private static String abbreviatePackageName(String fqcnWithMember) {
        int lastDot = fqcnWithMember.lastIndexOf(46);
        if (lastDot < 0) {
            return fqcnWithMember;
        }
        int preClassDot = fqcnWithMember.lastIndexOf(46, lastDot - 1);
        if (preClassDot < 0) {
            return fqcnWithMember;
        }
        String packagePart = fqcnWithMember.substring(0, preClassDot);
        String classAndAfter = fqcnWithMember.substring(preClassDot + 1);
        StringBuilder sb = new StringBuilder(fqcnWithMember.length());
        int segmentStart = 0;
        for (int i = 0; i <= packagePart.length(); ++i) {
            if (i != packagePart.length() && packagePart.charAt(i) != '.') continue;
            sb.append(packagePart.charAt(segmentStart)).append('.');
            segmentStart = i + 1;
        }
        sb.append(classAndAfter);
        return sb.toString();
    }

    private static String removeStackTraceMiddleForEachException(String trace) {
        List lines = new BufferedReader(new StringReader(trace)).lines().collect(Collectors.toList());
        ArrayList<Object> out = new ArrayList<Object>(lines.size());
        int i = 0;
        while (i < lines.size()) {
            out.add(lines.get(i++));
            int start = i;
            while (i < lines.size() && ((String)lines.get(i)).startsWith("\tat")) {
                ++i;
            }
            int total = i - start;
            int keepHead = Math.min(8, total);
            for (int j = 0; j < keepHead; ++j) {
                out.add(lines.get(start + j));
            }
            int keepTail = Math.min(4, total - keepHead);
            int skipped = total - keepHead - keepTail;
            if (skipped > 0) {
                out.add("\t... " + skipped + " trimmed ...");
            }
            for (int j = total - keepTail; j < total; ++j) {
                out.add(lines.get(start + j));
            }
            if (i >= lines.size() || !((String)lines.get(i)).startsWith("\t...")) continue;
            out.add(lines.get(i++));
        }
        return String.join((CharSequence)System.lineSeparator(), out) + System.lineSeparator();
    }
}

