/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import datadog.trace.api.Config;
import ddtrot.dd.trace.core.tagprocessor.BaseServiceAdder;
import ddtrot.dd.trace.core.tagprocessor.IntegrationAdder;
import ddtrot.dd.trace.core.tagprocessor.PayloadTagsProcessor;
import ddtrot.dd.trace.core.tagprocessor.PeerServiceCalculator;
import ddtrot.dd.trace.core.tagprocessor.PostProcessorChain;
import ddtrot.dd.trace.core.tagprocessor.QueryObfuscator;
import ddtrot.dd.trace.core.tagprocessor.RemoteHostnameAdder;
import ddtrot.dd.trace.core.tagprocessor.SpanPointersProcessor;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import java.util.ArrayList;

public final class TagsPostProcessorFactory {
    private static boolean addBaseService = true;
    private static boolean addRemoteHostname = true;

    public static TagsPostProcessor eagerProcessor() {
        return Lazy.eagerProcessor;
    }

    public static TagsPostProcessor lazyProcessor() {
        return Lazy.lazyProcessor;
    }

    public static void withAddBaseService(boolean enabled) {
        addBaseService = enabled;
        Lazy.eagerProcessor = Lazy.createEagerChain();
    }

    public static void withAddRemoteHostname(boolean enabled) {
        addRemoteHostname = enabled;
        Lazy.lazyProcessor = Lazy.createLazyChain();
    }

    public static void reset() {
        TagsPostProcessorFactory.withAddBaseService(true);
        TagsPostProcessorFactory.withAddRemoteHostname(true);
    }

    private static class Lazy {
        private static TagsPostProcessor eagerProcessor = Lazy.createEagerChain();
        private static TagsPostProcessor lazyProcessor = Lazy.createLazyChain();

        private Lazy() {
        }

        private static TagsPostProcessor createEagerChain() {
            ArrayList<TagsPostProcessor> processors = new ArrayList<TagsPostProcessor>(2);
            processors.add(new PeerServiceCalculator());
            if (addBaseService) {
                processors.add(new BaseServiceAdder(Config.get().getServiceName()));
            }
            return new PostProcessorChain(processors.toArray(new TagsPostProcessor[0]));
        }

        private static TagsPostProcessor createLazyChain() {
            PayloadTagsProcessor ptp;
            ArrayList<TagsPostProcessor> processors = new ArrayList<TagsPostProcessor>(7);
            processors.add(new QueryObfuscator(Config.get().getObfuscationQueryRegexp()));
            if (addRemoteHostname) {
                processors.add(new RemoteHostnameAdder(Config.get().getHostNameSupplier()));
            }
            if (Config.get().isCloudPayloadTaggingEnabled() && (ptp = PayloadTagsProcessor.create(Config.get())) != null) {
                processors.add(ptp);
            }
            if (Config.get().isAddSpanPointers("aws")) {
                processors.add(new SpanPointersProcessor());
            }
            processors.add(new IntegrationAdder());
            return new PostProcessorChain(processors.toArray(processors.toArray(new TagsPostProcessor[0])));
        }
    }
}

