/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.TagMap;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.JsonReader;
import ddtrot.com.squareup.moshi.JsonWriter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.trace.core.DDSpan;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

class DDSpanJsonAdapter
extends JsonAdapter<DDSpan> {
    private final boolean hexIds;

    DDSpanJsonAdapter(boolean hexIds) {
        this.hexIds = hexIds;
    }

    public static JsonAdapter.Factory buildFactory(final boolean hexIds) {
        return new JsonAdapter.Factory(){

            @Override
            public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
                Class<DDSpan> rawType = Types.getRawType(type);
                if (rawType.isAssignableFrom(DDSpan.class)) {
                    return new DDSpanJsonAdapter(hexIds);
                }
                return null;
            }
        };
    }

    @Override
    public DDSpan fromJson(JsonReader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toJson(JsonWriter writer, DDSpan span) throws IOException {
        writer.beginObject();
        writer.name("service");
        writer.value(span.getServiceName());
        writer.name("name");
        writer.value(span.getOperationName().toString());
        writer.name("resource");
        writer.value(span.getResourceName().toString());
        writer.name("trace_id");
        this.writeTraceId(writer, span.getTraceId());
        writer.name("span_id");
        this.writeSpanId(writer, span.getSpanId());
        writer.name("parent_id");
        this.writeSpanId(writer, span.getParentId());
        writer.name("start");
        writer.value(span.getStartTime());
        writer.name("duration");
        writer.value(span.getDurationNano());
        writer.name("type");
        writer.value(span.getSpanType());
        writer.name("error");
        writer.value(span.getError());
        writer.name("metrics");
        writer.beginObject();
        for (Map.Entry<String, Object> entry : span.getTags().entrySet()) {
            if (!(entry.getValue() instanceof Number)) continue;
            writer.name(entry.getKey());
            writer.value((Number)entry.getValue());
        }
        writer.endObject();
        writer.name("meta");
        writer.beginObject();
        TagMap tags = span.getTags();
        for (Map.Entry<String, String> entry : span.context().getBaggageItems().entrySet()) {
            if (tags.containsKey(entry.getKey())) continue;
            writer.name(entry.getKey());
            writer.value(entry.getValue());
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            if (entry.getValue() instanceof Number) continue;
            writer.name(entry.getKey());
            writer.value(String.valueOf(entry.getValue()));
        }
        writer.endObject();
        writer.endObject();
    }

    private void writeTraceId(JsonWriter writer, DDTraceId id) throws IOException {
        if (this.hexIds) {
            writer.value(id.toHexString());
        } else {
            writer.value(id.toLong());
        }
    }

    private void writeSpanId(JsonWriter writer, long id) throws IOException {
        if (this.hexIds) {
            writer.value(DDSpanId.toHexString((long)id));
        } else {
            writer.value(id);
        }
    }
}

