/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.debugger.util;

import ddtrot.dd.environment.JavaVirtualMachine;
import ddtrot.dd.trace.api.telemetry.LogCollector;
import ddtrot.dd.trace.bootstrap.debugger.CapturedContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WellKnownClasses {
    private static final Logger LOGGER = LoggerFactory.getLogger(WellKnownClasses.class);
    private static final Map<String, Function<Object, String>> TO_STRING_FINAL_SAFE_CLASSES = new HashMap<String, Function<Object, String>>();
    private static final Map<String, Function<Object, String>> SAFE_TO_STRING_FUNCTIONS;
    private static final Map<String, ToLongFunction<Object>> LONG_FUNCTIONS;
    private static final Set<String> EQUALS_SAFE_CLASSES;
    private static final Set<String> STRING_PRIMITIVES;
    private static final Set<String> LONG_PRIMITIVES;
    private static final Map<Class<?>, Map<String, Function<Object, CapturedContext.CapturedValue>>> SPECIAL_TYPE_ACCESS;
    private static final Map<String, Function<Object, CapturedContext.CapturedValue>> STACKTRACEELEMENT_SPECIAL_FIELDS;
    private static Method getModuleNameMethod;
    private static final Map<String, Function<Object, CapturedContext.CapturedValue>> OPTIONAL_SPECIAL_FIELDS;
    private static final Map<String, Function<Object, CapturedContext.CapturedValue>> OPTIONALINT_SPECIAL_FIELDS;
    private static final Map<String, Function<Object, CapturedContext.CapturedValue>> OPTIONALDOUBLE_SPECIAL_FIELDS;
    private static final Map<String, Function<Object, CapturedContext.CapturedValue>> OPTIONALLONG_SPECIAL_FIELDS;
    private static final Map<String, Function<Object, CapturedContext.CapturedValue>> COMPLETABLEFUTURE_SPECIAL_FIELDS;
    private static final Map<String, Function<Object, CapturedContext.CapturedValue>> THROWABLE_SPECIAL_FIELDS;
    private static final List<String> SAFE_COLLECTION_PACKAGES;
    private static final List<String> SAFE_MAP_PACKAGES;

    public static boolean isToStringFinalSafe(String type) {
        return TO_STRING_FINAL_SAFE_CLASSES.containsKey(type);
    }

    public static boolean isToStringSafe(String concreteType) {
        return SAFE_TO_STRING_FUNCTIONS.containsKey(concreteType);
    }

    public static boolean isSafe(Collection<?> collection) {
        String className = collection.getClass().getTypeName();
        for (String safePackage : SAFE_COLLECTION_PACKAGES) {
            if (!className.startsWith(safePackage)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSafe(Map<?, ?> map) {
        String className = map.getClass().getTypeName();
        for (String safePackage : SAFE_MAP_PACKAGES) {
            if (!className.startsWith(safePackage)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringPrimitive(String type) {
        return STRING_PRIMITIVES.contains(type);
    }

    public static boolean isLongPrimitive(String type) {
        return LONG_PRIMITIVES.contains(type);
    }

    public static Map<String, Function<Object, CapturedContext.CapturedValue>> getSpecialTypeAccess(Object value) {
        if (value == null) {
            return null;
        }
        Map<String, Function<Object, CapturedContext.CapturedValue>> specialTypeAccess = SPECIAL_TYPE_ACCESS.get(value.getClass());
        if (specialTypeAccess != null) {
            return specialTypeAccess;
        }
        if (value instanceof Throwable) {
            return THROWABLE_SPECIAL_FIELDS;
        }
        return null;
    }

    public static Function<Object, String> getSafeToString(String type) {
        return SAFE_TO_STRING_FUNCTIONS.get(type);
    }

    private static String classToString(Object o) {
        return ((Class)o).getTypeName();
    }

    private static String dateToString(Object o) {
        return Long.toString(((Date)o).getTime());
    }

    private static long dateToLongValue(Object o) {
        return ((Date)o).getTime();
    }

    public static boolean isEqualsSafe(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isEnum() || EQUALS_SAFE_CLASSES.contains(clazz.getTypeName());
    }

    public static ToLongFunction<Object> getLongPrimitiveValueFunction(String typeName) {
        return LONG_FUNCTIONS.get(typeName);
    }

    static {
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Class", WellKnownClasses::classToString);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.String", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Boolean", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Integer", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Long", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Double", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Character", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Byte", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Float", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.lang.Short", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.math.BigDecimal", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.math.BigInteger", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.time.Duration", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.time.Instant", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.time.LocalTime", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.time.LocalDate", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.time.LocalDateTime", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.util.UUID", String::valueOf);
        TO_STRING_FINAL_SAFE_CLASSES.put("java.net.URI", String::valueOf);
        SAFE_TO_STRING_FUNCTIONS = new HashMap<String, Function<Object, String>>();
        SAFE_TO_STRING_FUNCTIONS.putAll(TO_STRING_FINAL_SAFE_CLASSES);
        SAFE_TO_STRING_FUNCTIONS.put("java.util.concurrent.atomic.AtomicBoolean", String::valueOf);
        SAFE_TO_STRING_FUNCTIONS.put("java.util.concurrent.atomic.AtomicInteger", String::valueOf);
        SAFE_TO_STRING_FUNCTIONS.put("java.util.concurrent.atomic.AtomicLong", String::valueOf);
        SAFE_TO_STRING_FUNCTIONS.put("java.io.File", String::valueOf);
        SAFE_TO_STRING_FUNCTIONS.put("sun.nio.fs.UnixPath", String::valueOf);
        SAFE_TO_STRING_FUNCTIONS.put("sun.nio.fs.WindowsPath", String::valueOf);
        SAFE_TO_STRING_FUNCTIONS.put("java.util.Date", WellKnownClasses::dateToString);
        LONG_FUNCTIONS = new HashMap<String, ToLongFunction<Object>>();
        LONG_FUNCTIONS.put("java.util.Date", WellKnownClasses::dateToLongValue);
        EQUALS_SAFE_CLASSES = new HashSet<String>();
        EQUALS_SAFE_CLASSES.add("java.lang.Class");
        EQUALS_SAFE_CLASSES.add("java.lang.String");
        EQUALS_SAFE_CLASSES.add("java.lang.Boolean");
        EQUALS_SAFE_CLASSES.add("java.lang.Integer");
        EQUALS_SAFE_CLASSES.add("java.lang.Long");
        EQUALS_SAFE_CLASSES.add("java.lang.Double");
        EQUALS_SAFE_CLASSES.add("java.lang.Character");
        EQUALS_SAFE_CLASSES.add("java.lang.Byte");
        EQUALS_SAFE_CLASSES.add("java.lang.Float");
        EQUALS_SAFE_CLASSES.add("java.lang.Short");
        EQUALS_SAFE_CLASSES.add("java.math.BigDecimal");
        EQUALS_SAFE_CLASSES.add("java.math.BigInteger");
        EQUALS_SAFE_CLASSES.add("java.time.Duration");
        EQUALS_SAFE_CLASSES.add("java.time.Instant");
        EQUALS_SAFE_CLASSES.add("java.time.LocalTime");
        EQUALS_SAFE_CLASSES.add("java.time.LocalDate");
        EQUALS_SAFE_CLASSES.add("java.time.LocalDateTime");
        EQUALS_SAFE_CLASSES.add("java.util.UUID");
        EQUALS_SAFE_CLASSES.add("java.net.URI");
        EQUALS_SAFE_CLASSES.add("java.io.File");
        EQUALS_SAFE_CLASSES.add("sun.nio.fs.UnixPath");
        EQUALS_SAFE_CLASSES.add("sun.nio.fs.WindowsPath");
        STRING_PRIMITIVES = new HashSet<String>(Arrays.asList("java.lang.Class", "java.lang.String", "java.time.Duration", "java.time.Instant", "java.time.LocalTime", "java.time.LocalDate", "java.time.LocalDateTime", "java.util.UUID", "java.net.URI", "java.io.File", "sun.nio.fs.UnixPath", "sun.nio.fs.WindowsPath"));
        LONG_PRIMITIVES = new HashSet<String>(Arrays.asList("java.util.Date"));
        SPECIAL_TYPE_ACCESS = new HashMap();
        STACKTRACEELEMENT_SPECIAL_FIELDS = new HashMap<String, Function<Object, CapturedContext.CapturedValue>>();
        STACKTRACEELEMENT_SPECIAL_FIELDS.put("declaringClass", StackTraceElementFields::declaringClass);
        STACKTRACEELEMENT_SPECIAL_FIELDS.put("methodName", StackTraceElementFields::methodName);
        STACKTRACEELEMENT_SPECIAL_FIELDS.put("fileName", StackTraceElementFields::fileName);
        STACKTRACEELEMENT_SPECIAL_FIELDS.put("lineNumber", StackTraceElementFields::lineNumber);
        STACKTRACEELEMENT_SPECIAL_FIELDS.put("moduleName", StackTraceElementFields::moduleName);
        try {
            getModuleNameMethod = StackTraceElement.class.getMethod("getModuleName", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getModuleNameMethod = null;
        }
        OPTIONAL_SPECIAL_FIELDS = new HashMap<String, Function<Object, CapturedContext.CapturedValue>>();
        OPTIONALINT_SPECIAL_FIELDS = new HashMap<String, Function<Object, CapturedContext.CapturedValue>>();
        OPTIONALDOUBLE_SPECIAL_FIELDS = new HashMap<String, Function<Object, CapturedContext.CapturedValue>>();
        OPTIONALLONG_SPECIAL_FIELDS = new HashMap<String, Function<Object, CapturedContext.CapturedValue>>();
        COMPLETABLEFUTURE_SPECIAL_FIELDS = new HashMap<String, Function<Object, CapturedContext.CapturedValue>>();
        OPTIONAL_SPECIAL_FIELDS.put("value", OptionalFields::value);
        OPTIONALINT_SPECIAL_FIELDS.put("value", OptionalFields::valueInt);
        OPTIONALDOUBLE_SPECIAL_FIELDS.put("value", OptionalFields::valueDouble);
        OPTIONALLONG_SPECIAL_FIELDS.put("value", OptionalFields::valueLong);
        if (JavaVirtualMachine.isJavaVersionAtLeast(19)) {
            COMPLETABLEFUTURE_SPECIAL_FIELDS.put("result", CompletableFutureFields::result);
        }
        SPECIAL_TYPE_ACCESS.put(StackTraceElement.class, STACKTRACEELEMENT_SPECIAL_FIELDS);
        SPECIAL_TYPE_ACCESS.put(Optional.class, OPTIONAL_SPECIAL_FIELDS);
        SPECIAL_TYPE_ACCESS.put(OptionalInt.class, OPTIONALINT_SPECIAL_FIELDS);
        SPECIAL_TYPE_ACCESS.put(OptionalDouble.class, OPTIONALDOUBLE_SPECIAL_FIELDS);
        SPECIAL_TYPE_ACCESS.put(OptionalLong.class, OPTIONALLONG_SPECIAL_FIELDS);
        if (JavaVirtualMachine.isJavaVersionAtLeast(19)) {
            SPECIAL_TYPE_ACCESS.put(CompletableFuture.class, COMPLETABLEFUTURE_SPECIAL_FIELDS);
        }
        THROWABLE_SPECIAL_FIELDS = new HashMap<String, Function<Object, CapturedContext.CapturedValue>>();
        THROWABLE_SPECIAL_FIELDS.put("detailMessage", ThrowableFields::detailMessage);
        THROWABLE_SPECIAL_FIELDS.put("suppressedExceptions", ThrowableFields::suppressedExceptions);
        THROWABLE_SPECIAL_FIELDS.put("stackTrace", ThrowableFields::stackTrace);
        THROWABLE_SPECIAL_FIELDS.put("cause", ThrowableFields::cause);
        SAFE_COLLECTION_PACKAGES = Arrays.asList("java.", "ddtrot.com.google.protobuf.", "ddtrot.com.google.common.collect.", "it.unimi.dsi.fastutil.");
        SAFE_MAP_PACKAGES = Arrays.asList("java.", "ddtrot.com.google.protobuf.", "ddtrot.com.google.common.collect.", "it.unimi.dsi.fastutil.");
    }

    private static class CompletableFutureFields {
        private static final MethodHandle RESULT_NOW;

        private CompletableFutureFields() {
        }

        public static CapturedContext.CapturedValue result(Object o) {
            if (RESULT_NOW == null) {
                throw new UnsupportedOperationException("CompletableFuture::resultNow not available");
            }
            try {
                CompletableFuture future = (CompletableFuture)o;
                Object result = future.isDone() ? RESULT_NOW.invokeExact(future) : null;
                return CapturedContext.CapturedValue.of("result", Object.class.getTypeName(), result);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        static {
            MethodHandle methodHandle = null;
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                methodHandle = lookup.findVirtual(CompletableFuture.class, "resultNow", MethodType.methodType(Object.class));
            }
            catch (Exception e) {
                LOGGER.debug(LogCollector.EXCLUDE_TELEMETRY, "Looking up CompletableFuture::resultNow failed: ", (Throwable)e);
            }
            RESULT_NOW = methodHandle;
        }
    }

    private static class OptionalFields {
        private OptionalFields() {
        }

        public static CapturedContext.CapturedValue value(Object o) {
            return CapturedContext.CapturedValue.of("value", Object.class.getTypeName(), ((Optional)o).orElse(null));
        }

        public static CapturedContext.CapturedValue valueInt(Object o) {
            return CapturedContext.CapturedValue.of("value", Integer.TYPE.getTypeName(), ((OptionalInt)o).orElse(0));
        }

        public static CapturedContext.CapturedValue valueDouble(Object o) {
            return CapturedContext.CapturedValue.of("value", Double.TYPE.getTypeName(), ((OptionalDouble)o).orElse(0.0));
        }

        public static CapturedContext.CapturedValue valueLong(Object o) {
            return CapturedContext.CapturedValue.of("value", Long.TYPE.getTypeName(), ((OptionalLong)o).orElse(0L));
        }
    }

    private static class StackTraceElementFields {
        private StackTraceElementFields() {
        }

        public static CapturedContext.CapturedValue declaringClass(Object o) {
            return CapturedContext.CapturedValue.of("declaringClass", String.class.getTypeName(), ((StackTraceElement)o).getClassName());
        }

        public static CapturedContext.CapturedValue methodName(Object o) {
            return CapturedContext.CapturedValue.of("methodName", String.class.getTypeName(), ((StackTraceElement)o).getMethodName());
        }

        public static CapturedContext.CapturedValue fileName(Object o) {
            return CapturedContext.CapturedValue.of("fileName", String.class.getTypeName(), ((StackTraceElement)o).getFileName());
        }

        public static CapturedContext.CapturedValue lineNumber(Object o) {
            return CapturedContext.CapturedValue.of("lineNumber", String.class.getTypeName(), ((StackTraceElement)o).getLineNumber());
        }

        public static CapturedContext.CapturedValue moduleName(Object o) {
            StackTraceElement stackTraceElement = (StackTraceElement)o;
            Object value = null;
            if (getModuleNameMethod != null) {
                try {
                    value = getModuleNameMethod.invoke((Object)stackTraceElement, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return CapturedContext.CapturedValue.of("moduleName", String.class.getTypeName(), value);
        }
    }

    private static class ThrowableFields {
        public static final String BECAUSE_OVERRIDDEN = "Special access method not safe to be called because overridden";

        private ThrowableFields() {
        }

        public static CapturedContext.CapturedValue detailMessage(Object o) {
            return ThrowableFields.captureIfNotOverridden((Throwable)o, "detailMessage", "getMessage", String.class, Throwable.class, Throwable::getMessage);
        }

        public static CapturedContext.CapturedValue suppressedExceptions(Object o) {
            return CapturedContext.CapturedValue.of("suppressedExceptions", String.class.getTypeName(), ((Throwable)o).getSuppressed());
        }

        public static CapturedContext.CapturedValue stackTrace(Object o) {
            return ThrowableFields.captureIfNotOverridden((Throwable)o, "stackTrace", "getStackTrace", StackTraceElement[].class, Throwable.class, Throwable::getStackTrace);
        }

        public static CapturedContext.CapturedValue cause(Object o) {
            return ThrowableFields.captureIfNotOverridden((Throwable)o, "cause", "getCause", Throwable.class, Throwable.class, Throwable::getCause);
        }

        private static <T, R> CapturedContext.CapturedValue captureIfNotOverridden(T obj, String fieldName, String methodName, Class<R> fieldType, Class<T> orginalDeclaringClass, Function<T, R> supplier) {
            if (ThrowableFields.isOverridden(obj, methodName, orginalDeclaringClass)) {
                return CapturedContext.CapturedValue.notCapturedReason(fieldName, fieldType.getTypeName(), BECAUSE_OVERRIDDEN);
            }
            return CapturedContext.CapturedValue.of(fieldName, fieldType.getTypeName(), supplier.apply(obj));
        }

        private static boolean isOverridden(Object value, String methodName, Class<?> originalDeclaringClass) {
            Class<?> declaringClass = null;
            try {
                declaringClass = value.getClass().getMethod(methodName, new Class[0]).getDeclaringClass();
            }
            catch (NoSuchMethodException e) {
                LOGGER.debug("Failed to get declaring class for Throwable::getMessage", (Throwable)e);
            }
            return declaringClass != originalDeclaringClass;
        }
    }
}

