/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.gateway;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.ContextKey;
import ddtrot.dd.context.ImplicitContextKeyed;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InferredProxySpan
implements ImplicitContextKeyed {
    private static final ContextKey<InferredProxySpan> CONTEXT_KEY = ContextKey.named("inferred-proxy-key");
    static final String PROXY_SYSTEM = "x-dd-proxy";
    static final String PROXY_START_TIME_MS = "x-dd-proxy-request-time-ms";
    static final String PROXY_PATH = "x-dd-proxy-path";
    static final String PROXY_HTTP_METHOD = "x-dd-proxy-httpmethod";
    static final String PROXY_DOMAIN_NAME = "x-dd-proxy-domain-name";
    static final String STAGE = "x-dd-proxy-stage";
    static final Map<String, String> SUPPORTED_PROXIES = new HashMap<String, String>();
    static final String INSTRUMENTATION_NAME = "inferred_proxy";
    private final Map<String, String> headers;
    private AgentSpan span;

    public static InferredProxySpan fromHeaders(Map<String, String> values) {
        return new InferredProxySpan(values);
    }

    public static InferredProxySpan fromContext(Context context) {
        return context.get(CONTEXT_KEY);
    }

    private InferredProxySpan(Map<String, String> headers) {
        this.headers = headers == null ? Collections.emptyMap() : headers;
    }

    public boolean isValid() {
        String startTimeStr = this.header(PROXY_START_TIME_MS);
        String proxySystem = this.header(PROXY_SYSTEM);
        return startTimeStr != null && proxySystem != null && SUPPORTED_PROXIES.containsKey(proxySystem);
    }

    public AgentSpanContext start(AgentSpanContext extracted) {
        long startTime;
        if (this.span != null || !this.isValid()) {
            return extracted;
        }
        try {
            startTime = Long.parseLong(this.header(PROXY_START_TIME_MS)) * 1000L;
        }
        catch (NumberFormatException e) {
            return extracted;
        }
        String proxySystem = this.header(PROXY_SYSTEM);
        String proxy = SUPPORTED_PROXIES.get(proxySystem);
        AgentSpan span = AgentTracer.get().startSpan(INSTRUMENTATION_NAME, proxy, extracted, startTime);
        span.setServiceName(this.header(PROXY_DOMAIN_NAME));
        span.setTag("component", proxySystem);
        span.setTag("span.type", "web");
        span.setTag("http.method", this.header(PROXY_HTTP_METHOD));
        span.setTag("http.url", this.header(PROXY_DOMAIN_NAME) + this.header(PROXY_PATH));
        span.setTag("stage", this.header(STAGE));
        span.setTag("_dd.inferred_span", 1);
        this.headers.clear();
        this.span = span;
        return this.span.context();
    }

    private String header(String name) {
        return this.headers.get(name);
    }

    public void finish() {
        if (this.span != null) {
            this.span.finish();
            this.span = null;
        }
    }

    @Override
    public Context storeInto(Context context) {
        return context.with(CONTEXT_KEY, this);
    }

    static {
        SUPPORTED_PROXIES.put("aws-apigateway", "aws.apigateway");
    }
}

