/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import java.util.LinkedHashMap;
import java.util.Map;

public final class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int maxEntries;
    private final ExpiryListener<K, V> expiryListener;

    public LRUCache(int maxEntries) {
        this(16, maxEntries);
    }

    public LRUCache(int initialCapacity, int maxEntries) {
        this(initialCapacity, 0.75f, maxEntries);
    }

    public LRUCache(int initialCapacity, float loadFactor, int maxEntries) {
        this(null, initialCapacity, loadFactor, maxEntries);
    }

    public LRUCache(ExpiryListener<K, V> expiryListener, int initialCapacity, float loadFactor, int maxEntries) {
        super(initialCapacity, loadFactor, true);
        this.maxEntries = maxEntries;
        this.expiryListener = expiryListener;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean expire;
        boolean bl = expire = this.size() > this.maxEntries;
        if (null != this.expiryListener && expire) {
            this.expiryListener.accept(eldest);
        }
        return expire;
    }

    public static interface ExpiryListener<T, U> {
        public void accept(Map.Entry<T, U> var1);
    }
}

