/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.debugger;

import java.util.Objects;

public class CapturedStackFrame {
    private final String fileName;
    private final String function;
    private final int lineNumber;

    public CapturedStackFrame(String fileName, String function, int lineNumber) {
        this.fileName = fileName;
        this.function = function;
        this.lineNumber = lineNumber;
    }

    public CapturedStackFrame(String function, int lineNumber) {
        this(null, function, lineNumber);
    }

    public static CapturedStackFrame from(StackTraceElement element) {
        return new CapturedStackFrame(element.getFileName(), CapturedStackFrame.getFunction(element), element.getLineNumber());
    }

    private static String getFunction(StackTraceElement element) {
        return element.getClassName() + "." + element.getMethodName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFunction() {
        return this.function;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapturedStackFrame that = (CapturedStackFrame)o;
        return this.lineNumber == that.lineNumber && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.function, this.lineNumber);
    }

    public String toString() {
        return "CapturedStackFrame{fileName='" + this.fileName + '\'' + ", function='" + this.function + '\'' + ", lineNumber=" + this.lineNumber + '}';
    }
}

