/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.org.jctools.queues.atomic;

import ddtrot.org.jctools.queues.atomic.MpmcAtomicArrayQueue;
import ddtrot.org.jctools.queues.atomic.MpscAtomicArrayQueue;
import ddtrot.org.jctools.queues.atomic.MpscLinkedAtomicQueue;
import ddtrot.org.jctools.queues.atomic.SpmcAtomicArrayQueue;
import ddtrot.org.jctools.queues.atomic.SpscAtomicArrayQueue;
import ddtrot.org.jctools.queues.atomic.SpscLinkedAtomicQueue;
import ddtrot.org.jctools.queues.spec.ConcurrentQueueSpec;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AtomicQueueFactory {
    public static <E> Queue<E> newQueue(ConcurrentQueueSpec qs) {
        if (qs.isBounded()) {
            if (qs.isSpsc()) {
                return new SpscAtomicArrayQueue(qs.capacity);
            }
            if (qs.isMpsc()) {
                return new MpscAtomicArrayQueue(qs.capacity);
            }
            if (qs.isSpmc()) {
                return new SpmcAtomicArrayQueue(qs.capacity);
            }
            return new MpmcAtomicArrayQueue(qs.capacity);
        }
        if (qs.isSpsc()) {
            return new SpscLinkedAtomicQueue();
        }
        if (qs.isMpsc()) {
            return new MpscLinkedAtomicQueue();
        }
        return new ConcurrentLinkedQueue();
    }
}

