/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.core.scopemanager.ContinuableScope;
import ddtrot.dd.trace.core.scopemanager.ContinuableScopeManager;
import java.util.ArrayDeque;

final class ScopeStack {
    private final ProfilingContextIntegration profilingContextIntegration;
    private final ArrayDeque<ContinuableScope> stack = new ArrayDeque();
    ContinuableScope top;
    volatile ContinuableScope overdueRootScope;

    ScopeStack(ProfilingContextIntegration profilingContextIntegration) {
        this.profilingContextIntegration = profilingContextIntegration;
    }

    ScopeStack copy() {
        ScopeStack copy = new ScopeStack(this.profilingContextIntegration);
        copy.stack.addAll(this.stack);
        copy.top = this.top;
        copy.overdueRootScope = this.overdueRootScope;
        return copy;
    }

    ContinuableScope active() {
        return this.top != this.overdueRootScope ? this.top : null;
    }

    void cleanup() {
        ContinuableScope curScope = this.top;
        boolean changedTop = false;
        while (curScope != null && !curScope.alive()) {
            curScope.onProperClose();
            changedTop = true;
            curScope = this.stack.poll();
        }
        if (curScope != null && curScope == this.overdueRootScope) {
            curScope.onProperClose();
            this.overdueRootScope = null;
            this.top = null;
        } else if (changedTop) {
            this.top = curScope;
            if (curScope != null) {
                curScope.beforeActivated();
                curScope.afterActivated();
            }
        }
        if (this.top == null) {
            this.onBecomeEmpty();
        }
    }

    void push(ContinuableScope scope) {
        scope.beforeActivated();
        if (this.top != null) {
            this.stack.push(this.top);
        } else {
            this.onBecomeNonEmpty();
        }
        this.top = scope;
        scope.afterActivated();
    }

    boolean checkTop(ContinuableScope expectedScope) {
        return expectedScope.equals(this.top);
    }

    final boolean checkOverdueScopes(ContinuableScope expectedScope) {
        if (this.top == null || this.top.source() != 2) {
            return false;
        }
        this.top.clearReferences();
        AgentSpan span = this.top.span();
        if (span != null) {
            span.finishWithEndToEnd();
        }
        for (ContinuableScope scope : this.stack) {
            if (scope.source() != 2) {
                return expectedScope.equals(scope);
            }
            scope.clearReferences();
            span = scope.span();
            if (span == null) continue;
            span.finishWithEndToEnd();
        }
        return false;
    }

    int depth() {
        return this.top != null ? 1 + this.stack.size() : 0;
    }

    void clear() {
        this.stack.clear();
        this.top = null;
    }

    private void onBecomeNonEmpty() {
        try {
            this.profilingContextIntegration.onAttach();
        }
        catch (Throwable e) {
            ContinuableScopeManager.ratelimitedLog.warn("Unexpected profiling exception", e);
        }
    }

    private void onBecomeEmpty() {
        try {
            this.profilingContextIntegration.onDetach();
        }
        catch (Throwable e) {
            ContinuableScopeManager.ratelimitedLog.warn("Unexpected profiling exception", e);
        }
    }
}

