/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.trace.api.flare.TracerFlare;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.common.writer.TraceDumpJsonExporter;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.LongRunningTracesTracker;
import ddtrot.dd.trace.core.PendingTrace;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.org.jctools.queues.MessagePassingQueue;
import ddtrot.org.jctools.queues.MpscBlockingConsumerArrayQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PendingTraceBuffer
implements AutoCloseable {
    private static final int BUFFER_SIZE = 4096;

    public boolean longRunningSpansEnabled() {
        return false;
    }

    public static PendingTraceBuffer delaying(TimeSource timeSource, Config config, SharedCommunicationObjects sharedCommunicationObjects, HealthMetrics healthMetrics) {
        return new DelayingPendingTraceBuffer(4096, timeSource, config, sharedCommunicationObjects, healthMetrics);
    }

    public static PendingTraceBuffer discarding() {
        return new DiscardingPendingTraceBuffer();
    }

    public abstract void start();

    @Override
    public abstract void close();

    public abstract void flush();

    public abstract void enqueue(Element var1);

    private static class TracerDump
    implements TracerFlare.Reporter {
        private final DelayingPendingTraceBuffer buffer;

        private TracerDump(DelayingPendingTraceBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void prepareForFlare() {
            if (this.buffer.worker.isAlive()) {
                int count = this.buffer.dumpCounter.get();
                int loop = 1;
                boolean signaled = this.buffer.queue.offer(DelayingPendingTraceBuffer.DUMP_ELEMENT);
                while (!this.buffer.closed && !signaled) {
                    this.buffer.yieldOrSleep(loop++);
                    signaled = this.buffer.queue.offer(DelayingPendingTraceBuffer.DUMP_ELEMENT);
                }
                int newCount = this.buffer.dumpCounter.get();
                while (!this.buffer.closed && count >= newCount) {
                    this.buffer.yieldOrSleep(loop++);
                    newCount = this.buffer.dumpCounter.get();
                }
            }
        }

        @Override
        public void addReportToFlare(ZipOutputStream zip) throws IOException {
            TraceDumpJsonExporter writer = new TraceDumpJsonExporter(zip);
            for (Element e : DelayingPendingTraceBuffer.DumpDrain.DUMP_DRAIN.collectTraces()) {
                if (!(e instanceof PendingTrace)) continue;
                PendingTrace trace = (PendingTrace)e;
                writer.write(trace.getSpans());
            }
            writer.flush();
        }
    }

    static class DiscardingPendingTraceBuffer
    extends PendingTraceBuffer {
        private static final Logger log = LoggerFactory.getLogger(DiscardingPendingTraceBuffer.class);

        DiscardingPendingTraceBuffer() {
        }

        @Override
        public void start() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void enqueue(Element pendingTrace) {
            log.debug("PendingTrace enqueued but won't be reported. Root span: {}", (Object)pendingTrace.getRootSpan());
        }
    }

    private static class DelayingPendingTraceBuffer
    extends PendingTraceBuffer {
        private static final long FORCE_SEND_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
        private static final long SEND_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(500L);
        private static final long SLEEP_TIME_MS = 100L;
        private static final CommandElement FLUSH_ELEMENT = new CommandElement();
        private static final CommandElement DUMP_ELEMENT = new CommandElement();
        private final MpscBlockingConsumerArrayQueue<Element> queue;
        private final Thread worker;
        private final TimeSource timeSource;
        private volatile boolean closed = false;
        private final AtomicInteger flushCounter = new AtomicInteger(0);
        private final AtomicInteger dumpCounter = new AtomicInteger(0);
        private final LongRunningTracesTracker runningTracesTracker;

        @Override
        public boolean longRunningSpansEnabled() {
            return this.runningTracesTracker != null;
        }

        @Override
        public void enqueue(Element pendingTrace) {
            if (pendingTrace.setEnqueued(true) && !this.queue.offer(pendingTrace)) {
                pendingTrace.setEnqueued(false);
                if (!pendingTrace.writeOnBufferFull()) {
                    return;
                }
                pendingTrace.write();
            }
        }

        @Override
        public void start() {
            TracerFlare.addReporter(new TracerDump(this));
            this.worker.start();
        }

        @Override
        public void close() {
            this.flush();
            this.closed = true;
            this.worker.interrupt();
            try {
                this.worker.join(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void yieldOrSleep(int loop) {
            if (loop <= 3) {
                Thread.yield();
            } else {
                try {
                    Thread.sleep(10L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void flush() {
            if (this.worker.isAlive()) {
                int count = this.flushCounter.get();
                int loop = 1;
                boolean signaled = this.queue.offer(FLUSH_ELEMENT);
                while (!this.closed && !signaled) {
                    this.yieldOrSleep(loop++);
                    signaled = this.queue.offer(FLUSH_ELEMENT);
                }
                int newCount = this.flushCounter.get();
                while (!this.closed && count >= newCount) {
                    this.yieldOrSleep(loop++);
                    newCount = this.flushCounter.get();
                }
            }
        }

        public DelayingPendingTraceBuffer(int bufferSize, TimeSource timeSource, Config config, SharedCommunicationObjects sharedCommunicationObjects, HealthMetrics healthMetrics) {
            this.queue = new MpscBlockingConsumerArrayQueue(bufferSize);
            this.worker = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.TRACE_MONITOR, new Worker());
            this.timeSource = timeSource;
            boolean runningSpansEnabled = config.isLongRunningTraceEnabled();
            this.runningTracesTracker = runningSpansEnabled ? new LongRunningTracesTracker(config, bufferSize, sharedCommunicationObjects, healthMetrics) : null;
        }

        private final class Worker
        implements Runnable {
            private Worker() {
            }

            @Override
            public void run() {
                try {
                    while (!DelayingPendingTraceBuffer.this.closed && !Thread.currentThread().isInterrupted()) {
                        Element pendingTrace = null;
                        if (DelayingPendingTraceBuffer.this.longRunningSpansEnabled()) {
                            pendingTrace = (Element)DelayingPendingTraceBuffer.this.queue.poll(1L, TimeUnit.SECONDS);
                            DelayingPendingTraceBuffer.this.runningTracesTracker.flushAndCompact(DelayingPendingTraceBuffer.this.timeSource.getCurrentTimeMillis());
                            if (pendingTrace == null) {
                                continue;
                            }
                        } else {
                            pendingTrace = (Element)DelayingPendingTraceBuffer.this.queue.take();
                        }
                        if (pendingTrace == FLUSH_ELEMENT) {
                            DelayingPendingTraceBuffer.this.queue.drain(WriteDrain.WRITE_DRAIN);
                            DelayingPendingTraceBuffer.this.flushCounter.incrementAndGet();
                            continue;
                        }
                        if (pendingTrace == DUMP_ELEMENT) {
                            DelayingPendingTraceBuffer.this.queue.fill(DumpDrain.DUMP_DRAIN, DelayingPendingTraceBuffer.this.queue.drain(DumpDrain.DUMP_DRAIN, 50));
                            DelayingPendingTraceBuffer.this.dumpCounter.incrementAndGet();
                            continue;
                        }
                        pendingTrace.setEnqueued(false);
                        if (DelayingPendingTraceBuffer.this.longRunningSpansEnabled() && DelayingPendingTraceBuffer.this.runningTracesTracker.add(pendingTrace)) continue;
                        long oldestFinishedTime = pendingTrace.oldestFinishedTime();
                        long finishTimestampMillis = TimeUnit.NANOSECONDS.toMillis(oldestFinishedTime);
                        if (finishTimestampMillis <= DelayingPendingTraceBuffer.this.timeSource.getCurrentTimeMillis() - FORCE_SEND_DELAY_MS) {
                            pendingTrace.write();
                            continue;
                        }
                        if (pendingTrace.lastReferencedNanosAgo(SEND_DELAY_NS)) {
                            pendingTrace.write();
                            continue;
                        }
                        DelayingPendingTraceBuffer.this.enqueue(pendingTrace);
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static final class CommandElement
        implements Element {
            private CommandElement() {
            }

            @Override
            public long oldestFinishedTime() {
                return 0L;
            }

            @Override
            public boolean lastReferencedNanosAgo(long nanos) {
                return false;
            }

            @Override
            public void write() {
            }

            @Override
            public DDSpan getRootSpan() {
                return null;
            }

            @Override
            public boolean setEnqueued(boolean enqueued) {
                return true;
            }

            @Override
            public boolean writeOnBufferFull() {
                return true;
            }
        }

        private static final class DumpDrain
        implements MessagePassingQueue.Consumer<Element>,
        MessagePassingQueue.Supplier<Element> {
            private static final DumpDrain DUMP_DRAIN = new DumpDrain();
            private static final int MAX_DUMPED_TRACES = 50;
            private static final Comparator<Element> TRACE_BY_START_TIME = Comparator.comparingLong(trace -> trace.getRootSpan().getStartTime());
            private static final Predicate<Element> NOT_PENDING_TRACE = element -> !(element instanceof PendingTrace);
            private volatile List<Element> data = new ArrayList<Element>();
            private int index = 0;

            private DumpDrain() {
            }

            @Override
            public void accept(Element pendingTrace) {
                this.data.add(pendingTrace);
            }

            @Override
            public Element get() {
                if (this.index < this.data.size()) {
                    return this.data.get(this.index++);
                }
                return null;
            }

            public List<Element> collectTraces() {
                List<Element> traces = this.data;
                this.data = new ArrayList<Element>();
                traces.removeIf(NOT_PENDING_TRACE);
                traces.sort(TRACE_BY_START_TIME);
                return traces;
            }
        }

        private static final class WriteDrain
        implements MessagePassingQueue.Consumer<Element> {
            private static final WriteDrain WRITE_DRAIN = new WriteDrain();

            private WriteDrain() {
            }

            @Override
            public void accept(Element pendingTrace) {
                pendingTrace.write();
            }
        }
    }

    public static interface Element {
        public long oldestFinishedTime();

        public boolean lastReferencedNanosAgo(long var1);

        public void write();

        public DDSpan getRootSpan();

        public boolean setEnqueued(boolean var1);

        public boolean writeOnBufferFull();
    }
}

