/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.cache;

import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.FixedSizeCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;

final class FixedSizeWeightedCache<K, V>
implements DDCache<K, V> {
    private final int mask;
    private final Weighed<K, V>[] elements;
    private final ToIntFunction<V> weigher;
    private final int totalWeightLimit;
    private final int totalWeightTarget;
    private volatile int totalWeightEstimate;
    private static final AtomicIntegerFieldUpdater<FixedSizeWeightedCache> TOTAL_WEIGHT_ESTIMATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(FixedSizeWeightedCache.class, "totalWeightEstimate");
    private static final Weighed EVICTED = new Weighed<Object, Object>(null, null, 0);

    FixedSizeWeightedCache(int capacity, ToIntFunction<V> weigher, int totalWeightLimit) {
        int size = FixedSizeCache.calculateSize(capacity);
        this.elements = new Weighed[size];
        this.mask = size - 1;
        this.weigher = weigher;
        this.totalWeightLimit = totalWeightLimit;
        this.totalWeightTarget = (int)(0.5 + (double)totalWeightLimit * 0.9);
    }

    @Override
    public V computeIfAbsent(K key, Function<K, ? extends V> producer) {
        V value;
        if (key == null) {
            return null;
        }
        int h = key.hashCode();
        int oldPos = h & this.mask;
        Weighed<K, V> old = this.elements[oldPos];
        int pos = oldPos;
        Weighed<K, V> current = old;
        int i = 1;
        while (true) {
            if (current == null) {
                value = this.produceAndStoreValue(key, producer, pos, 0);
                break;
            }
            if (current == EVICTED) {
                if (old != EVICTED) {
                    oldPos = pos;
                    old = current;
                }
            } else if (key.equals(current.key)) {
                value = current.value;
                break;
            }
            if (i == 3) {
                value = this.produceAndStoreValue(key, producer, oldPos, old.weight);
                break;
            }
            h = FixedSizeCache.rehash(h);
            pos = h & this.mask;
            current = this.elements[pos];
            ++i;
        }
        return value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
        this.totalWeightEstimate = 0;
    }

    @Override
    public void visit(BiConsumer<K, V> consumer) {
        for (Weighed<K, V> e : this.elements) {
            if (null == e) continue;
            consumer.accept(e.key, e.value);
        }
    }

    private V produceAndStoreValue(K key, Function<K, ? extends V> producer, int pos, int oldWeight) {
        int oldEstimate;
        V value = producer.apply(key);
        int weight = this.weigher.applyAsInt(value);
        if (weight > this.totalWeightLimit) {
            return value;
        }
        while ((oldEstimate = this.totalWeightEstimate) <= this.totalWeightLimit) {
            int newEstimate = oldEstimate + (weight - oldWeight);
            if (!TOTAL_WEIGHT_ESTIMATE_UPDATER.compareAndSet(this, oldEstimate, newEstimate)) continue;
            this.elements[pos] = new Weighed<K, V>(key, value, weight);
            if (newEstimate <= this.totalWeightLimit) break;
            this.beginSweep(pos, weight);
            break;
        }
        return value;
    }

    private void beginSweep(int startPos, int startWeight) {
        int totalWeight = startWeight;
        int i = startPos + 1 & this.mask;
        while (i != startPos) {
            Weighed<K, V> element = this.elements[i];
            if (element != null && element != EVICTED && (totalWeight += element.weight) > this.totalWeightTarget) {
                totalWeight -= element.weight;
                this.elements[i] = EVICTED;
            }
            i = i + 1 & this.mask;
        }
        this.totalWeightEstimate = totalWeight;
    }

    static final class Weighed<K, V> {
        final K key;
        final V value;
        final int weight;

        Weighed(K key, V value, int weight) {
            this.key = key;
            this.value = value;
            this.weight = weight;
        }
    }
}

