/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication;

import ddtrot.dd.communication.BackendApi;
import ddtrot.dd.communication.http.HttpRetryPolicy;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.util.IOThrowingFunction;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.RequestBody;
import ddtrot.okhttp3.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpProxyApi
implements BackendApi {
    private static final Logger log = LoggerFactory.getLogger(EvpProxyApi.class);
    private static final String API_VERSION = "v2";
    private static final String X_DATADOG_EVP_SUBDOMAIN_HEADER = "X-Datadog-EVP-Subdomain";
    private static final String X_DATADOG_TRACE_ID_HEADER = "x-datadog-trace-id";
    private static final String X_DATADOG_PARENT_ID_HEADER = "x-datadog-parent-id";
    private static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String API_SUBDOMAIN = "api";
    private static final String GZIP_ENCODING = "gzip";
    private final String traceId;
    private final HttpRetryPolicy.Factory retryPolicyFactory;
    private final HttpUrl evpProxyUrl;
    private final OkHttpClient httpClient;
    private final boolean responseCompression;

    public EvpProxyApi(String traceId, HttpUrl evpProxyUrl, HttpRetryPolicy.Factory retryPolicyFactory, OkHttpClient httpClient, boolean responseCompression) {
        this.traceId = traceId;
        this.evpProxyUrl = evpProxyUrl.resolve(String.format("api/%s/", API_VERSION));
        this.retryPolicyFactory = retryPolicyFactory;
        this.httpClient = httpClient;
        this.responseCompression = responseCompression;
    }

    @Override
    public <T> T post(String uri, RequestBody requestBody, IOThrowingFunction<InputStream, T> responseParser, @Nullable OkHttpUtils.CustomListener requestListener, boolean requestCompression) throws IOException {
        HttpUrl url = this.evpProxyUrl.resolve(uri);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader(X_DATADOG_EVP_SUBDOMAIN_HEADER, API_SUBDOMAIN).addHeader(X_DATADOG_TRACE_ID_HEADER, this.traceId).addHeader(X_DATADOG_PARENT_ID_HEADER, this.traceId);
        if (requestListener != null) {
            requestBuilder.tag(OkHttpUtils.CustomListener.class, requestListener);
        }
        if (requestCompression) {
            requestBuilder.addHeader(CONTENT_ENCODING_HEADER, GZIP_ENCODING);
        }
        if (this.responseCompression) {
            requestBuilder.addHeader(ACCEPT_ENCODING_HEADER, GZIP_ENCODING);
        }
        Request request = requestBuilder.post(requestBody).build();
        Throwable throwable = null;
        try (Response response = OkHttpUtils.sendWithRetries(this.httpClient, this.retryPolicyFactory, request);){
            if (response.isSuccessful()) {
                log.debug("Request to {} returned successful response: {}", (Object)uri, (Object)response.code());
                InputStream responseBodyStream = response.body().byteStream();
                String contentEncoding = response.header(CONTENT_ENCODING_HEADER);
                if (GZIP_ENCODING.equalsIgnoreCase(contentEncoding)) {
                    log.debug("Response content encoding is {}, unzipping response body", (Object)contentEncoding);
                    responseBodyStream = new GZIPInputStream(responseBodyStream);
                }
                T t = responseParser.apply(responseBodyStream);
                return t;
            }
            try {
                throw new IOException("Request to " + uri + " returned error response " + response.code() + ": " + response.message() + "; " + (response.body() != null ? response.body().string() : ""));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

