/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.aiguard;

import datadog.trace.api.aiguard.Evaluator;
import datadog.trace.api.aiguard.noop.NoOpEvaluator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AIGuard {
    protected static Evaluator EVALUATOR = new NoOpEvaluator();

    protected AIGuard() {
    }

    public static Evaluation evaluate(List<Message> messages) {
        return AIGuard.evaluate(messages, Options.DEFAULT);
    }

    public static Evaluation evaluate(List<Message> messages, Options options) {
        return EVALUATOR.evaluate(messages, options);
    }

    public static final class Options {
        public static final Options DEFAULT = new Options().block(false);
        private boolean block;

        public boolean block() {
            return this.block;
        }

        public Options block(boolean block) {
            this.block = block;
            return this;
        }
    }

    public static class Evaluation {
        final Action action;
        final String reason;
        final List<String> tags;

        public Evaluation(Action action, String reason, List<String> tags) {
            this.action = action;
            this.reason = reason;
            this.tags = tags;
        }

        public Action getAction() {
            return this.action;
        }

        public String getReason() {
            return this.reason;
        }

        public List<String> getTags() {
            return this.tags;
        }
    }

    public static class ToolCall {
        private final String id;
        private final Function function;

        public ToolCall(String id, Function function) {
            this.id = id;
            this.function = function;
        }

        public String getId() {
            return this.id;
        }

        public Function getFunction() {
            return this.function;
        }

        public static ToolCall toolCall(String id, String name, String arguments) {
            return new ToolCall(id, new Function(name, arguments));
        }

        public static class Function {
            private final String name;
            private final String arguments;

            public Function(String name, String arguments) {
                this.name = name;
                this.arguments = arguments;
            }

            public String getName() {
                return this.name;
            }

            public String getArguments() {
                return this.arguments;
            }
        }
    }

    public static class Message {
        private final String role;
        @Nullable
        private final String content;
        @Nullable
        private final List<ContentPart> contentParts;
        private final List<ToolCall> toolCalls;
        private final String toolCallId;

        public Message(@Nonnull String role, @Nullable String content, @Nullable List<ToolCall> toolCalls, @Nullable String toolCallId) {
            this.role = role;
            this.content = content;
            this.contentParts = null;
            this.toolCalls = toolCalls;
            this.toolCallId = toolCallId;
        }

        public Message(@Nonnull String role, @Nonnull List<ContentPart> contentParts, @Nullable List<ToolCall> toolCalls, @Nullable String toolCallId) {
            this.role = role;
            this.content = null;
            for (ContentPart part : contentParts) {
                if (part != null) continue;
                throw new IllegalArgumentException("contentParts must not contain null elements");
            }
            this.contentParts = Collections.unmodifiableList(contentParts);
            this.toolCalls = toolCalls;
            this.toolCallId = toolCallId;
        }

        public String getRole() {
            return this.role;
        }

        @Nullable
        public String getContent() {
            return this.content;
        }

        @Nullable
        public List<ContentPart> getContentParts() {
            return this.contentParts;
        }

        public List<ToolCall> getToolCalls() {
            return this.toolCalls;
        }

        public String getToolCallId() {
            return this.toolCallId;
        }

        @Nonnull
        public static Message message(@Nonnull String role, @Nonnull String content) {
            return new Message(role, content, null, null);
        }

        @Nonnull
        public static Message message(@Nonnull String role, @Nonnull List<ContentPart> contentParts) {
            return new Message(role, contentParts, null, null);
        }

        public static Message tool(String toolCallId, String content) {
            return new Message("tool", content, null, toolCallId);
        }

        @Nonnull
        public static Message assistant(ToolCall ... toolCalls) {
            return new Message("assistant", (String)null, Arrays.asList(toolCalls), null);
        }
    }

    public static class ContentPart {
        private final Type type;
        @Nullable
        private final String text;
        @Nullable
        private final ImageURL imageUrl;

        private ContentPart(@Nonnull Type type, @Nullable String text, @Nullable ImageURL imageUrl) {
            this.type = type;
            this.text = text;
            this.imageUrl = imageUrl;
            if (type == Type.TEXT && text == null) {
                throw new IllegalArgumentException("text content part requires text field");
            }
            if (type == Type.IMAGE_URL && imageUrl == null) {
                throw new IllegalArgumentException("image_url content part requires imageUrl field");
            }
        }

        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nullable
        public ImageURL getImageUrl() {
            return this.imageUrl;
        }

        @Nonnull
        public static ContentPart text(@Nonnull String text) {
            Objects.requireNonNull(text, "text cannot be null");
            return new ContentPart(Type.TEXT, text, null);
        }

        @Nonnull
        public static ContentPart imageUrl(@Nonnull String url) {
            return new ContentPart(Type.IMAGE_URL, null, new ImageURL(url));
        }

        public static enum Type {
            TEXT,
            IMAGE_URL;


            public String toString() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }
    }

    public static class ImageURL {
        private final String url;

        public ImageURL(@Nonnull String url) {
            this.url = Objects.requireNonNull(url, "url cannot be null");
        }

        @Nonnull
        public String getUrl() {
            return this.url;
        }
    }

    public static enum Action {
        ALLOW,
        DENY,
        ABORT;

    }

    public static class AIGuardClientError
    extends RuntimeException {
        private final Object errors;

        public AIGuardClientError(String message, Throwable cause) {
            super(message, cause);
            this.errors = null;
        }

        public AIGuardClientError(String message, Object errors) {
            super(message, null);
            this.errors = errors;
        }

        public Object getErrors() {
            return this.errors;
        }
    }

    public static class AIGuardAbortError
    extends RuntimeException {
        private final Action action;
        private final String reason;
        private final List<String> tags;

        public AIGuardAbortError(Action action, String reason, List<String> tags) {
            super(reason);
            this.action = action;
            this.reason = reason;
            this.tags = tags;
        }

        public Action getAction() {
            return this.action;
        }

        public String getReason() {
            return this.reason;
        }

        public List<String> getTags() {
            return this.tags;
        }
    }
}

