/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing;

import androidx.annotation.FloatRange;
import com.datadog.android.Datadog;
import com.datadog.android.core.configuration.HostsSanitizer;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.sampling.RateBasedSampler;
import com.datadog.android.core.internal.sampling.Sampler;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.tracing.NoOpTracedRequestListener;
import com.datadog.android.tracing.TracedRequestListener;
import com.datadog.android.tracing.TracingHeaderType;
import com.datadog.android.tracing.internal.TracingFeature;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.DatadogCore;
import com.datadog.opentracing.DDTracer;
import com.datadog.trace.api.interceptor.MutableSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 K2\u00020\u0001:\u0001KB)\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0003\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB5\b\u0017\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0003\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eB\u001b\b\u0017\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0003\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fB]\b\u0000\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0018\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0002J\r\u0010.\u001a\u00020/H\u0010\u00a2\u0006\u0002\b0J\u001a\u00101\u001a\u0004\u0018\u0001022\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0002J\u0017\u00103\u001a\u0004\u0018\u00010/2\u0006\u0010,\u001a\u00020-H\u0002\u00a2\u0006\u0002\u00104J*\u00105\u001a\u0002062\u0006\u0010,\u001a\u00020-2\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010*2\u0006\u0010:\u001a\u00020/H\u0002J*\u0010;\u001a\u0002062\u0006\u0010,\u001a\u00020-2\u0006\u0010<\u001a\u00020=2\b\u00109\u001a\u0004\u0018\u00010*2\u0006\u0010:\u001a\u00020/H\u0002J\u0010\u0010>\u001a\u0002082\u0006\u0010?\u001a\u00020@H\u0016J\u0018\u0010>\u001a\u0002082\u0006\u0010?\u001a\u00020@2\u0006\u0010,\u001a\u00020-H\u0002J \u0010A\u001a\u0002082\u0006\u0010?\u001a\u00020@2\u0006\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u0017H\u0002J\u0010\u0010B\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0002J.\u0010C\u001a\u0002062\u0006\u0010,\u001a\u00020-2\b\u00109\u001a\u0004\u0018\u00010*2\b\u00107\u001a\u0004\u0018\u0001082\b\u0010<\u001a\u0004\u0018\u00010=H\u0014J\b\u0010D\u001a\u00020\u0017H\u0002J\n\u0010E\u001a\u0004\u0018\u00010\u0017H\u0002J&\u0010F\u001a\u0002062\u0006\u0010G\u001a\u00020H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u00109\u001a\u00020*H\u0002J(\u0010J\u001a\u00020H2\u0006\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u00172\u0006\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020/H\u0002R\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00170\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R&\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006L"}, d2={"Lcom/datadog/android/tracing/TracingInterceptor;", "Lokhttp3/Interceptor;", "tracedHosts", "", "", "tracedRequestListener", "Lcom/datadog/android/tracing/TracedRequestListener;", "traceSamplingRate", "", "(Ljava/util/List;Lcom/datadog/android/tracing/TracedRequestListener;F)V", "tracedHostsWithHeaderType", "", "", "Lcom/datadog/android/tracing/TracingHeaderType;", "(Ljava/util/Map;Lcom/datadog/android/tracing/TracedRequestListener;F)V", "(Lcom/datadog/android/tracing/TracedRequestListener;F)V", "firstPartyHostResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "traceOrigin", "traceSampler", "Lcom/datadog/android/core/internal/sampling/Sampler;", "localTracerFactory", "Lkotlin/Function1;", "Lio/opentracing/Tracer;", "(Ljava/util/Map;Lcom/datadog/android/tracing/TracedRequestListener;Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Ljava/lang/String;Lcom/datadog/android/core/internal/sampling/Sampler;Lkotlin/jvm/functions/Function1;)V", "getFirstPartyHostResolver$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "localFirstPartyHostHeaderTypeResolver", "getLocalTracerFactory$dd_sdk_android_release", "()Lkotlin/jvm/functions/Function1;", "localTracerReference", "Ljava/util/concurrent/atomic/AtomicReference;", "sanitizedHosts", "getTraceOrigin$dd_sdk_android_release", "()Ljava/lang/String;", "getTraceSampler$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/sampling/Sampler;", "getTracedHosts$dd_sdk_android_release", "()Ljava/util/Map;", "getTracedRequestListener$dd_sdk_android_release", "()Lcom/datadog/android/tracing/TracedRequestListener;", "buildSpan", "Lio/opentracing/Span;", "tracer", "request", "Lokhttp3/Request;", "canSendSpan", "", "canSendSpan$dd_sdk_android_release", "extractParentContext", "Lio/opentracing/SpanContext;", "extractSamplingDecision", "(Lokhttp3/Request;)Ljava/lang/Boolean;", "handleResponse", "", "response", "Lokhttp3/Response;", "span", "isSampled", "handleThrowable", "throwable", "", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "interceptAndTrace", "isRequestTraceable", "onRequestIntercepted", "resolveLocalTracer", "resolveTracer", "setSampledOutHeaders", "requestBuilder", "Lokhttp3/Request$Builder;", "tracingHeaderTypes", "updateRequest", "Companion", "dd-sdk-android_release"})
public class TracingInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Set<TracingHeaderType>> tracedHosts;
    @NotNull
    private final TracedRequestListener tracedRequestListener;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostResolver;
    @Nullable
    private final String traceOrigin;
    @NotNull
    private final Sampler traceSampler;
    @NotNull
    private final Function1<Set<? extends TracingHeaderType>, Tracer> localTracerFactory;
    @NotNull
    private final AtomicReference<Tracer> localTracerReference;
    @NotNull
    private final List<String> sanitizedHosts;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver localFirstPartyHostHeaderTypeResolver;
    @NotNull
    public static final String SPAN_NAME = "okhttp.request";
    @NotNull
    public static final String RESOURCE_NAME_404 = "404";
    @NotNull
    public static final String HEADER_CT = "Content-Type";
    public static final char URL_QUERY_PARAMS_BLOCK_SEPARATOR = '?';
    @NotNull
    public static final String WARNING_TRACING_NO_HOSTS = "You added a TracingInterceptor to your OkHttpClient, but you did not specify any first party hosts. Your requests won't be traced.\nTo set a list of known hosts, you can use the Configuration.Builder::setFirstPartyHosts() method.";
    @NotNull
    public static final String WARNING_TRACING_DISABLED = "You added a TracingInterceptor to your OkHttpClient, but you did not enable the TracingFeature. Your requests won't be traced.";
    @NotNull
    public static final String WARNING_DEFAULT_TRACER = "You added a TracingInterceptor to your OkHttpClient, but you didn't register any Tracer. We automatically created a local tracer for you.";
    @NotNull
    public static final String NETWORK_REQUESTS_TRACKING_FEATURE_NAME = "Network Requests";
    public static final float DEFAULT_TRACE_SAMPLING_RATE = 20.0f;
    @NotNull
    public static final String DATADOG_TRACE_ID_HEADER = "x-datadog-trace-id";
    @NotNull
    public static final String DATADOG_SPAN_ID_HEADER = "x-datadog-parent-id";
    @NotNull
    public static final String DATADOG_SAMPLING_PRIORITY_HEADER = "x-datadog-sampling-priority";
    @NotNull
    public static final String DATADOG_DROP_SAMPLING_DECISION = "0";
    @NotNull
    public static final String DATADOG_ORIGIN_HEADER = "x-datadog-origin";
    @NotNull
    public static final String B3_HEADER_KEY = "b3";
    @NotNull
    public static final String B3_DROP_SAMPLING_DECISION = "0";
    public static final int B3_SAMPLING_DECISION_INDEX = 2;
    @NotNull
    public static final String B3M_TRACE_ID_KEY = "X-B3-TraceId";
    @NotNull
    public static final String B3M_SPAN_ID_KEY = "X-B3-SpanId";
    @NotNull
    public static final String B3M_SAMPLING_PRIORITY_KEY = "X-B3-Sampled";
    @NotNull
    public static final String B3M_DROP_SAMPLING_DECISION = "0";
    @NotNull
    public static final String W3C_TRACEPARENT_KEY = "traceparent";
    @NotNull
    public static final String W3C_DROP_SAMPLING_DECISION = "00-%s-%s-00";
    public static final int W3C_SAMPLING_DECISION_INDEX = 3;

    /*
     * WARNING - void declaration
     */
    public TracingInterceptor(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> tracedHosts, @NotNull TracedRequestListener tracedRequestListener, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostResolver, @Nullable String traceOrigin, @NotNull Sampler traceSampler, @NotNull Function1<? super Set<? extends TracingHeaderType>, ? extends Tracer> localTracerFactory) {
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter(tracedHosts, (String)"tracedHosts");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostResolver, (String)"firstPartyHostResolver");
        Intrinsics.checkNotNullParameter((Object)traceSampler, (String)"traceSampler");
        Intrinsics.checkNotNullParameter(localTracerFactory, (String)"localTracerFactory");
        this.tracedHosts = tracedHosts;
        this.tracedRequestListener = tracedRequestListener;
        this.firstPartyHostResolver = firstPartyHostResolver;
        this.traceOrigin = traceOrigin;
        this.traceSampler = traceSampler;
        this.localTracerFactory = localTracerFactory;
        this.localTracerReference = new AtomicReference();
        this.sanitizedHosts = new HostsSanitizer().sanitizeHosts$dd_sdk_android_release(CollectionsKt.toList((Iterable)this.tracedHosts.keySet()), NETWORK_REQUESTS_TRACKING_FEATURE_NAME);
        Map<String, Set<TracingHeaderType>> map = this.tracedHosts;
        TracingInterceptor tracingInterceptor = this;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!this.sanitizedHosts.contains(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map map2 = result$iv;
        tracingInterceptor.localFirstPartyHostHeaderTypeResolver = new FirstPartyHostHeaderTypeResolver(map2);
        if (this.localFirstPartyHostHeaderTypeResolver.isEmpty() && this.firstPartyHostResolver.isEmpty()) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, WARNING_TRACING_NO_HOSTS, null, 8, null);
        }
    }

    @NotNull
    public final Map<String, Set<TracingHeaderType>> getTracedHosts$dd_sdk_android_release() {
        return this.tracedHosts;
    }

    @NotNull
    public final TracedRequestListener getTracedRequestListener$dd_sdk_android_release() {
        return this.tracedRequestListener;
    }

    @NotNull
    public final FirstPartyHostHeaderTypeResolver getFirstPartyHostResolver$dd_sdk_android_release() {
        return this.firstPartyHostResolver;
    }

    @Nullable
    public final String getTraceOrigin$dd_sdk_android_release() {
        return this.traceOrigin;
    }

    @NotNull
    public final Sampler getTraceSampler$dd_sdk_android_release() {
        return this.traceSampler;
    }

    @NotNull
    public final Function1<Set<? extends TracingHeaderType>, Tracer> getLocalTracerFactory$dd_sdk_android_release() {
        return this.localTracerFactory;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public TracingInterceptor(@NotNull List<String> tracedHosts, @NotNull TracedRequestListener tracedRequestListener, @FloatRange(from=0.0, to=100.0) float traceSamplingRate) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(tracedHosts, (String)"tracedHosts");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        Iterable iterable = tracedHosts;
        TracingInterceptor tracingInterceptor = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Set set = SetsKt.setOf((Object)((Object)TracingHeaderType.DATADOG));
            map.put(t, set);
        }
        tracingInterceptor(result$iv, tracedRequestListener, Companion.getGlobalFirstPartyHostResolver$dd_sdk_android_release(), null, new RateBasedSampler(NumberExtKt.percent(traceSamplingRate)), (Function1<? super Set<? extends TracingHeaderType>, ? extends Tracer>)((Function1)2.INSTANCE));
    }

    public /* synthetic */ TracingInterceptor(List list, TracedRequestListener tracedRequestListener, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tracedRequestListener = new NoOpTracedRequestListener();
        }
        if ((n & 4) != 0) {
            f = 20.0f;
        }
        this(list, tracedRequestListener, f);
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> tracedHostsWithHeaderType, @NotNull TracedRequestListener tracedRequestListener, @FloatRange(from=0.0, to=100.0) float traceSamplingRate) {
        Intrinsics.checkNotNullParameter(tracedHostsWithHeaderType, (String)"tracedHostsWithHeaderType");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(tracedHostsWithHeaderType, tracedRequestListener, Companion.getGlobalFirstPartyHostResolver$dd_sdk_android_release(), null, new RateBasedSampler(NumberExtKt.percent(traceSamplingRate)), (Function1<? super Set<? extends TracingHeaderType>, ? extends Tracer>)((Function1)3.INSTANCE));
    }

    public /* synthetic */ TracingInterceptor(Map map, TracedRequestListener tracedRequestListener, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tracedRequestListener = new NoOpTracedRequestListener();
        }
        if ((n & 4) != 0) {
            f = 20.0f;
        }
        this(map, tracedRequestListener, f);
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull TracedRequestListener tracedRequestListener, @FloatRange(from=0.0, to=100.0) float traceSamplingRate) {
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(MapsKt.emptyMap(), tracedRequestListener, Companion.getGlobalFirstPartyHostResolver$dd_sdk_android_release(), null, new RateBasedSampler(NumberExtKt.percent(traceSamplingRate)), (Function1<? super Set<? extends TracingHeaderType>, ? extends Tracer>)((Function1)4.INSTANCE));
    }

    public /* synthetic */ TracingInterceptor(TracedRequestListener tracedRequestListener, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tracedRequestListener = new NoOpTracedRequestListener();
        }
        if ((n & 2) != 0) {
            f = 20.0f;
        }
        this(tracedRequestListener, f);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Tracer tracer = this.resolveTracer();
        Request request = chain.request();
        if (tracer != null) {
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
            if (this.isRequestTraceable(request)) {
                response = this.interceptAndTrace(chain, request, tracer);
                return response;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
        response = this.intercept(chain, request);
        return response;
    }

    protected void onRequestIntercepted(@NotNull Request request, @Nullable Span span, @Nullable Response response, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (span != null) {
            this.tracedRequestListener.onRequestIntercepted(request, span, response, throwable);
        }
    }

    public boolean canSendSpan$dd_sdk_android_release() {
        return true;
    }

    private final boolean isRequestTraceable(Request request) {
        HttpUrl url = request.url();
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
        return this.firstPartyHostResolver.isFirstPartyUrl(url) || this.localFirstPartyHostHeaderTypeResolver.isFirstPartyUrl(url);
    }

    private final Response interceptAndTrace(Interceptor.Chain chain, Request request, Tracer tracer) {
        Request request2;
        Boolean bl = this.extractSamplingDecision(request);
        boolean isSampled = bl == null ? this.traceSampler.sample() : bl.booleanValue();
        Span span = this.buildSpan(tracer, request);
        try {
            request2 = this.updateRequest(request, tracer, span, isSampled).build();
        }
        catch (IllegalStateException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.WARN, CollectionsKt.listOf((Object[])targetArray), "Failed to update intercepted OkHttp request", (Throwable)e);
            request2 = request;
        }
        Request updatedRequest = request2;
        try {
            Response response = chain.proceed(updatedRequest);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            this.handleResponse(request, response, span, isSampled);
            return response;
        }
        catch (Throwable e) {
            this.handleThrowable(request, e, span, isSampled);
            throw e;
        }
    }

    private final Response intercept(Interceptor.Chain chain, Request request) {
        try {
            Response response = chain.proceed(request);
            this.onRequestIntercepted(request, null, response, null);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            return response;
        }
        catch (Throwable e) {
            this.onRequestIntercepted(request, null, null, e);
            throw e;
        }
    }

    private final synchronized Tracer resolveTracer() {
        Tracer tracer;
        TracingFeature tracingFeature;
        SdkCore sdkCore = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
        DatadogCore datadogCore = sdkCore instanceof DatadogCore ? (DatadogCore)sdkCore : null;
        TracingFeature tracingFeature2 = tracingFeature = datadogCore == null ? null : datadogCore.getTracingFeature$dd_sdk_android_release();
        if (tracingFeature == null) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, WARNING_TRACING_DISABLED, null, 8, null);
            tracer = null;
        } else if (GlobalTracer.isRegistered()) {
            this.localTracerReference.set(null);
            tracer = GlobalTracer.get();
        } else {
            tracer = this.resolveLocalTracer();
        }
        return tracer;
    }

    private final Tracer resolveLocalTracer() {
        if (this.localTracerReference.get() == null) {
            Set<TracingHeaderType> localHeaderTypes = this.localFirstPartyHostHeaderTypeResolver.getAllHeaderTypes();
            Set<TracingHeaderType> globalHeaderTypes = this.firstPartyHostResolver.getAllHeaderTypes();
            Set allHeaders = SetsKt.plus(localHeaderTypes, (Iterable)globalHeaderTypes);
            this.localTracerReference.compareAndSet(null, (Tracer)this.localTracerFactory.invoke((Object)allHeaders));
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, WARNING_DEFAULT_TRACER, null, 8, null);
        }
        Tracer tracer = this.localTracerReference.get();
        Intrinsics.checkNotNullExpressionValue((Object)tracer, (String)"localTracerReference.get()");
        return tracer;
    }

    private final Span buildSpan(Tracer tracer, Request request) {
        SpanContext parentContext = this.extractParentContext(tracer, request);
        String string = request.url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url().toString()");
        String url = string;
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(SPAN_NAME);
        DDTracer.DDSpanBuilder dDSpanBuilder = spanBuilder instanceof DDTracer.DDSpanBuilder ? (DDTracer.DDSpanBuilder)spanBuilder : null;
        if (dDSpanBuilder != null) {
            dDSpanBuilder.withOrigin(this.traceOrigin);
        }
        Span span = spanBuilder.asChildOf(parentContext).start();
        MutableSpan mutableSpan = span instanceof MutableSpan ? (MutableSpan)span : null;
        if (mutableSpan != null) {
            mutableSpan.setResourceName(StringsKt.substringBefore$default((String)url, (char)'?', null, (int)2, null));
        }
        span.setTag(Tags.HTTP_URL.getKey(), url);
        span.setTag(Tags.HTTP_METHOD.getKey(), request.method());
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"span");
        return span;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Boolean extractSamplingDecision(Request request) {
        Boolean bl;
        String w3cHeaderValue;
        Integer datadogSamplingPriority;
        String string = request.header(DATADOG_SAMPLING_PRIORITY_HEADER);
        Integer n = datadogSamplingPriority = string == null ? null : StringsKt.toIntOrNull((String)string);
        if (datadogSamplingPriority != null) {
            boolean bl2;
            int n2 = Integer.MIN_VALUE;
            if (datadogSamplingPriority == n2) {
                return null;
            }
            n2 = 2;
            if (datadogSamplingPriority != n2) {
                n2 = 1;
                if (datadogSamplingPriority != n2) {
                    bl2 = false;
                    return bl2;
                }
            }
            bl2 = true;
            return bl2;
        }
        String b3MSamplingPriority = request.header(B3M_SAMPLING_PRIORITY_KEY);
        if (b3MSamplingPriority != null) {
            Boolean bl3;
            String string2 = b3MSamplingPriority;
            if (Intrinsics.areEqual((Object)string2, (Object)"1")) {
                bl3 = true;
                return bl3;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"0")) return null;
            bl3 = false;
            return bl3;
        }
        String b3HeaderValue = request.header(B3_HEADER_KEY);
        if (b3HeaderValue != null) {
            if (Intrinsics.areEqual((Object)b3HeaderValue, (Object)"0")) {
                return false;
            }
            Object object = new String[]{"-"};
            List b3HeaderParts = StringsKt.split$default((CharSequence)b3HeaderValue, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (b3HeaderParts.size() >= 3) {
                switch ((String)b3HeaderParts.get(2)) {
                    case "1": 
                    case "d": {
                        Boolean bl4 = true;
                        return bl4;
                    }
                    case "0": {
                        Boolean bl4 = false;
                        return bl4;
                    }
                }
                return null;
            }
        }
        if ((w3cHeaderValue = request.header(W3C_TRACEPARENT_KEY)) == null) return null;
        Object object = new String[]{"-"};
        List w3CHeaderParts = StringsKt.split$default((CharSequence)w3cHeaderValue, (String[])object, (boolean)false, (int)0, (int)6, null);
        if (w3CHeaderParts.size() < 4) return null;
        Object object2 = object = StringsKt.toIntOrNull((String)((String)w3CHeaderParts.get(3)));
        int n3 = 1;
        if (object2 != null && (Integer)object2 == n3) {
            bl = true;
            return bl;
        }
        Object object3 = object;
        n3 = 0;
        if (object3 != null) {
            if ((Integer)object3 != 0) return null;
            bl = false;
            return bl;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final SpanContext extractParentContext(Tracer tracer, Request request) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Span span = (Span)request.tag(Span.class);
        SpanContext tagContext = span == null ? null : span.context();
        Map map = request.headers().toMultimap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"request.headers().toMultimap()");
        Format format = Format.Builtin.TEXT_MAP_EXTRACT;
        Tracer tracer2 = tracer;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            collection.add(TuplesKt.to(k, (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)v), (CharSequence)";", null, null, (int)0, null, null, (int)62, null)));
        }
        collection = (List)destination$iv$iv;
        Map map2 = MapsKt.toMap((Iterable)collection);
        SpanContext headerContext = tracer2.extract(format, (Object)new TextMapExtractAdapter(map2));
        SpanContext spanContext = headerContext;
        if (spanContext == null) {
            spanContext = tagContext;
        }
        return spanContext;
    }

    private final void setSampledOutHeaders(Request.Builder requestBuilder, Set<? extends TracingHeaderType> tracingHeaderTypes, Span span) {
        for (TracingHeaderType tracingHeaderType : tracingHeaderTypes) {
            switch (WhenMappings.$EnumSwitchMapping$0[tracingHeaderType.ordinal()]) {
                case 1: {
                    boolean bl;
                    String it;
                    Object element$iv;
                    Object $this$forEach$iv;
                    Object object = new String[]{DATADOG_SAMPLING_PRIORITY_HEADER, DATADOG_TRACE_ID_HEADER, DATADOG_SPAN_ID_HEADER, DATADOG_ORIGIN_HEADER};
                    object = CollectionsKt.listOf((Object[])object);
                    boolean $i$f$forEach = false;
                    Object object2 = $this$forEach$iv.iterator();
                    while (object2.hasNext()) {
                        element$iv = object2.next();
                        it = (String)element$iv;
                        bl = false;
                        requestBuilder.removeHeader(it);
                    }
                    requestBuilder.addHeader(DATADOG_SAMPLING_PRIORITY_HEADER, "0");
                    break;
                }
                case 2: {
                    requestBuilder.removeHeader(B3_HEADER_KEY);
                    requestBuilder.addHeader(B3_HEADER_KEY, "0");
                    break;
                }
                case 3: {
                    boolean bl;
                    String it;
                    Object element$iv;
                    Object $this$forEach$iv = new String[]{B3M_TRACE_ID_KEY, B3M_SPAN_ID_KEY, B3M_SAMPLING_PRIORITY_KEY};
                    $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
                    boolean $i$f$forEach = false;
                    Object object2 = $this$forEach$iv.iterator();
                    while (object2.hasNext()) {
                        element$iv = object2.next();
                        it = (String)element$iv;
                        bl = false;
                        requestBuilder.removeHeader(it);
                    }
                    requestBuilder.addHeader(B3M_SAMPLING_PRIORITY_KEY, "0");
                    break;
                }
                case 4: {
                    requestBuilder.removeHeader(W3C_TRACEPARENT_KEY);
                    Object[] objectArray = new Object[]{span.context().toTraceId(), span.context().toSpanId()};
                    Object object2 = String.format(W3C_DROP_SAMPLING_DECISION, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"format(this, *args)");
                    requestBuilder.addHeader(W3C_TRACEPARENT_KEY, (String)object2);
                }
            }
        }
    }

    private final Request.Builder updateRequest(Request request, Tracer tracer, Span span, boolean isSampled) {
        Object object;
        Request.Builder tracedRequestBuilder = request.newBuilder();
        Ref.ObjectRef tracingHeaderTypes = new Ref.ObjectRef();
        HttpUrl httpUrl = request.url();
        Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"request.url()");
        tracingHeaderTypes.element = this.localFirstPartyHostHeaderTypeResolver.headerTypesForUrl(httpUrl);
        if (!((Set)tracingHeaderTypes.element).isEmpty()) {
            object = (Set<TracingHeaderType>)tracingHeaderTypes.element;
        } else {
            httpUrl = request.url();
            Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"request.url()");
            object = tracingHeaderTypes.element = this.firstPartyHostResolver.headerTypesForUrl(httpUrl);
        }
        if (!isSampled) {
            Intrinsics.checkNotNullExpressionValue((Object)tracedRequestBuilder, (String)"tracedRequestBuilder");
            this.setSampledOutHeaders(tracedRequestBuilder, (Set)tracingHeaderTypes.element, span);
        } else {
            tracer.inject(span.context(), Format.Builtin.TEXT_MAP_INJECT, (arg_0, arg_1) -> TracingInterceptor.updateRequest$lambda-5(tracedRequestBuilder, tracingHeaderTypes, arg_0, arg_1));
        }
        Intrinsics.checkNotNullExpressionValue((Object)tracedRequestBuilder, (String)"tracedRequestBuilder");
        return tracedRequestBuilder;
    }

    private final void handleResponse(Request request, Response response, Span span, boolean isSampled) {
        if (!isSampled || span == null) {
            this.onRequestIntercepted(request, null, response, null);
        } else {
            int statusCode = response.code();
            span.setTag(Tags.HTTP_STATUS.getKey(), (Number)statusCode);
            boolean bl = 400 <= statusCode ? statusCode < 500 : false;
            if (bl) {
                MutableSpan mutableSpan = span instanceof MutableSpan ? (MutableSpan)span : null;
                if (mutableSpan != null) {
                    mutableSpan.setError(true);
                }
            }
            if (statusCode == 404) {
                MutableSpan mutableSpan = span instanceof MutableSpan ? (MutableSpan)span : null;
                if (mutableSpan != null) {
                    mutableSpan.setResourceName(RESOURCE_NAME_404);
                }
            }
            this.onRequestIntercepted(request, span, response, null);
            if (this.canSendSpan$dd_sdk_android_release()) {
                span.finish();
            } else {
                MutableSpan mutableSpan = span instanceof MutableSpan ? (MutableSpan)span : null;
                if (mutableSpan != null) {
                    mutableSpan.drop();
                }
            }
        }
    }

    private final void handleThrowable(Request request, Throwable throwable, Span span, boolean isSampled) {
        if (!isSampled || span == null) {
            this.onRequestIntercepted(request, null, null, throwable);
        } else {
            MutableSpan mutableSpan = span instanceof MutableSpan ? (MutableSpan)span : null;
            if (mutableSpan != null) {
                mutableSpan.setError(true);
            }
            span.setTag("error.msg", throwable.getMessage());
            span.setTag("error.type", throwable.getClass().getName());
            span.setTag("error.stack", ThrowableExtKt.loggableStackTrace(throwable));
            this.onRequestIntercepted(request, span, null, throwable);
            if (this.canSendSpan$dd_sdk_android_release()) {
                span.finish();
            } else {
                MutableSpan mutableSpan2 = span instanceof MutableSpan ? (MutableSpan)span : null;
                if (mutableSpan2 != null) {
                    mutableSpan2.drop();
                }
            }
        }
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull List<String> tracedHosts, @NotNull TracedRequestListener tracedRequestListener) {
        Intrinsics.checkNotNullParameter(tracedHosts, (String)"tracedHosts");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(tracedHosts, tracedRequestListener, 0.0f, 4, null);
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull List<String> tracedHosts) {
        Intrinsics.checkNotNullParameter(tracedHosts, (String)"tracedHosts");
        this(tracedHosts, null, 0.0f, 6, null);
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> tracedHostsWithHeaderType, @NotNull TracedRequestListener tracedRequestListener) {
        Intrinsics.checkNotNullParameter(tracedHostsWithHeaderType, (String)"tracedHostsWithHeaderType");
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(tracedHostsWithHeaderType, tracedRequestListener, 0.0f, 4, null);
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> tracedHostsWithHeaderType) {
        Intrinsics.checkNotNullParameter(tracedHostsWithHeaderType, (String)"tracedHostsWithHeaderType");
        this(tracedHostsWithHeaderType, null, 0.0f, 6, null);
    }

    @JvmOverloads
    public TracingInterceptor(@NotNull TracedRequestListener tracedRequestListener) {
        Intrinsics.checkNotNullParameter((Object)tracedRequestListener, (String)"tracedRequestListener");
        this(tracedRequestListener, 0.0f, 2, null);
    }

    @JvmOverloads
    public TracingInterceptor() {
        this(null, 0.0f, 3, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void updateRequest$lambda-5(Request.Builder $tracedRequestBuilder, Ref.ObjectRef $tracingHeaderTypes, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)$tracingHeaderTypes, (String)"$tracingHeaderTypes");
        $tracedRequestBuilder.removeHeader(key);
        String string = key;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 304080974: {
                    if (!string.equals(DATADOG_SPAN_ID_HEADER)) break;
                    n = 1;
                    break;
                }
                case 3089: {
                    if (!string.equals(B3_HEADER_KEY)) break;
                    n = 2;
                    break;
                }
                case 762897402: {
                    if (!string.equals(DATADOG_SAMPLING_PRIORITY_HEADER)) break;
                    n = 1;
                    break;
                }
                case -344354804: {
                    if (!string.equals(B3M_SPAN_ID_KEY)) break;
                    n = 3;
                    break;
                }
                case -1682961930: {
                    if (!string.equals(DATADOG_ORIGIN_HEADER)) break;
                    n = 1;
                    break;
                }
                case 1037578799: {
                    if (!string.equals(W3C_TRACEPARENT_KEY)) break;
                    n = 4;
                    break;
                }
                case 1791641299: {
                    if (!string.equals(B3M_SAMPLING_PRIORITY_KEY)) break;
                    n = 3;
                    break;
                }
                case 1767467379: {
                    if (!string.equals(DATADOG_TRACE_ID_HEADER)) break;
                    n = 1;
                    break;
                }
                case -1140603879: {
                    if (!string.equals(B3M_TRACE_ID_KEY)) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    if (!((Set)$tracingHeaderTypes.element).contains((Object)TracingHeaderType.DATADOG)) return;
                    $tracedRequestBuilder.addHeader(key, value);
                    return;
                }
                case 2: {
                    if (!((Set)$tracingHeaderTypes.element).contains((Object)TracingHeaderType.B3)) return;
                    $tracedRequestBuilder.addHeader(key, value);
                    return;
                }
                case 3: {
                    if (!((Set)$tracingHeaderTypes.element).contains((Object)TracingHeaderType.B3MULTI)) return;
                    $tracedRequestBuilder.addHeader(key, value);
                    return;
                }
                case 4: {
                    if (!((Set)$tracingHeaderTypes.element).contains((Object)TracingHeaderType.TRACECONTEXT)) return;
                    $tracedRequestBuilder.addHeader(key, value);
                    return;
                }
            }
        }
        $tracedRequestBuilder.addHeader(key, value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/datadog/android/tracing/TracingInterceptor$Companion;", "", "()V", "B3M_DROP_SAMPLING_DECISION", "", "B3M_SAMPLING_PRIORITY_KEY", "B3M_SPAN_ID_KEY", "B3M_TRACE_ID_KEY", "B3_DROP_SAMPLING_DECISION", "B3_HEADER_KEY", "B3_SAMPLING_DECISION_INDEX", "", "DATADOG_DROP_SAMPLING_DECISION", "DATADOG_ORIGIN_HEADER", "DATADOG_SAMPLING_PRIORITY_HEADER", "DATADOG_SPAN_ID_HEADER", "DATADOG_TRACE_ID_HEADER", "DEFAULT_TRACE_SAMPLING_RATE", "", "HEADER_CT", "NETWORK_REQUESTS_TRACKING_FEATURE_NAME", "RESOURCE_NAME_404", "SPAN_NAME", "URL_QUERY_PARAMS_BLOCK_SEPARATOR", "", "W3C_DROP_SAMPLING_DECISION", "W3C_SAMPLING_DECISION_INDEX", "W3C_TRACEPARENT_KEY", "WARNING_DEFAULT_TRACER", "WARNING_TRACING_DISABLED", "WARNING_TRACING_NO_HOSTS", "getGlobalFirstPartyHostResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "getGlobalFirstPartyHostResolver$dd_sdk_android_release", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirstPartyHostHeaderTypeResolver getGlobalFirstPartyHostResolver$dd_sdk_android_release() {
            DatadogCore datadogCore;
            Object object = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
            DatadogCore datadogCore2 = datadogCore = object instanceof DatadogCore ? (DatadogCore)object : null;
            FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver = datadogCore == null ? null : ((object = datadogCore.getCoreFeature$dd_sdk_android_release()) == null ? null : ((CoreFeature)object).getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release());
            return firstPartyHostHeaderTypeResolver == null ? new FirstPartyHostHeaderTypeResolver(MapsKt.emptyMap()) : firstPartyHostHeaderTypeResolver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TracingHeaderType.values().length];
            nArray[TracingHeaderType.DATADOG.ordinal()] = 1;
            nArray[TracingHeaderType.B3.ordinal()] = 2;
            nArray[TracingHeaderType.B3MULTI.ordinal()] = 3;
            nArray[TracingHeaderType.TRACECONTEXT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

