/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.telemetry.internal;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.configuration.BatchSize;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.configuration.VitalsUpdateFrequency;
import com.datadog.android.core.internal.sampling.RateBasedSampler;
import com.datadog.android.core.internal.sampling.Sampler;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.tracking.ActivityViewTrackingStrategy;
import com.datadog.android.rum.tracking.FragmentViewTrackingStrategy;
import com.datadog.android.rum.tracking.MixedViewTrackingStrategy;
import com.datadog.android.rum.tracking.NavigationViewTrackingStrategy;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import com.datadog.android.telemetry.internal.TelemetryEventExtKt;
import com.datadog.android.telemetry.internal.TelemetryEventHandler;
import com.datadog.android.telemetry.internal.TelemetryEventId;
import com.datadog.android.telemetry.internal.TelemetryEventIdKt;
import com.datadog.android.telemetry.internal.TelemetryType;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import com.datadog.android.telemetry.model.TelemetryDebugEvent;
import com.datadog.android.telemetry.model.TelemetryErrorEvent;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import io.opentracing.util.GlobalTracer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J \u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J4\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010$2\b\u0010(\u001a\u0004\u0018\u00010$H\u0002J\u001e\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007J\u0018\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u0015H\u0016J\f\u00101\u001a\u000202*\u00020\u001cH\u0002R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;", "Lcom/datadog/android/rum/RumSessionListener;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "eventSampler", "Lcom/datadog/android/core/internal/sampling/Sampler;", "configurationExtraSampler", "maxEventCountPerSession", "", "(Lcom/datadog/android/v2/api/SdkCore;Lcom/datadog/android/core/internal/sampling/Sampler;Lcom/datadog/android/core/internal/sampling/Sampler;I)V", "getConfigurationExtraSampler$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/sampling/Sampler;", "getEventSampler$dd_sdk_android_release", "getMaxEventCountPerSession$dd_sdk_android_release", "()I", "getSdkCore$dd_sdk_android_release", "()Lcom/datadog/android/v2/api/SdkCore;", "seenInCurrentSession", "", "Lcom/datadog/android/telemetry/internal/TelemetryEventId;", "trackNetworkRequests", "", "canWrite", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$SendTelemetry;", "createConfigurationEvent", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent;", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "timestamp", "", "configuration", "Lcom/datadog/android/core/configuration/Configuration;", "createDebugEvent", "Lcom/datadog/android/telemetry/model/TelemetryDebugEvent;", "message", "", "createErrorEvent", "Lcom/datadog/android/telemetry/model/TelemetryErrorEvent;", "stack", "kind", "handleEvent", "", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "", "onSessionStarted", "sessionId", "isDiscarded", "rumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "Companion", "dd-sdk-android_release"})
public final class TelemetryEventHandler
implements RumSessionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final Sampler eventSampler;
    @NotNull
    private final Sampler configurationExtraSampler;
    private final int maxEventCountPerSession;
    private boolean trackNetworkRequests;
    @NotNull
    private final Set<TelemetryEventId> seenInCurrentSession;
    public static final int MAX_EVENTS_PER_SESSION = 100;
    @NotNull
    public static final String ALREADY_SEEN_EVENT_MESSAGE = "Already seen telemetry event with identity=%s, rejecting.";
    @NotNull
    public static final String MAX_EVENT_NUMBER_REACHED_MESSAGE = "Max number of telemetry events per session reached, rejecting.";
    @NotNull
    public static final String TELEMETRY_SERVICE_NAME = "dd-sdk-android";

    public TelemetryEventHandler(@NotNull SdkCore sdkCore, @NotNull Sampler eventSampler, @NotNull Sampler configurationExtraSampler, int maxEventCountPerSession) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)eventSampler, (String)"eventSampler");
        Intrinsics.checkNotNullParameter((Object)configurationExtraSampler, (String)"configurationExtraSampler");
        this.sdkCore = sdkCore;
        this.eventSampler = eventSampler;
        this.configurationExtraSampler = configurationExtraSampler;
        this.maxEventCountPerSession = maxEventCountPerSession;
        this.seenInCurrentSession = new LinkedHashSet();
    }

    public /* synthetic */ TelemetryEventHandler(SdkCore sdkCore, Sampler sampler, Sampler sampler2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            sampler2 = new RateBasedSampler(NumberExtKt.percent(20.0f));
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        this(sdkCore, sampler, sampler2, n);
    }

    @NotNull
    public final SdkCore getSdkCore$dd_sdk_android_release() {
        return this.sdkCore;
    }

    @NotNull
    public final Sampler getEventSampler$dd_sdk_android_release() {
        return this.eventSampler;
    }

    @NotNull
    public final Sampler getConfigurationExtraSampler$dd_sdk_android_release() {
        return this.configurationExtraSampler;
    }

    public final int getMaxEventCountPerSession$dd_sdk_android_release() {
        return this.maxEventCountPerSession;
    }

    @WorkerThread
    public final void handleEvent(@NotNull RumRawEvent.SendTelemetry event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        if (!this.canWrite(event)) {
            return;
        }
        this.seenInCurrentSession.add(TelemetryEventIdKt.getIdentity(event));
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default(featureScope, false, (Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(event, this, writer){
                final /* synthetic */ RumRawEvent.SendTelemetry $event;
                final /* synthetic */ TelemetryEventHandler this$0;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    long timestamp = this.$event.getEventTime().getTimestamp() + datadogContext.getTime().getServerTimeOffsetMs();
                    switch (handleEvent.WhenMappings.$EnumSwitchMapping$0[this.$event.getType().ordinal()]) {
                        case 1: {
                            object = TelemetryEventHandler.access$createDebugEvent(this.this$0, datadogContext, timestamp, this.$event.getMessage());
                            break;
                        }
                        case 2: {
                            object = TelemetryEventHandler.access$createErrorEvent(this.this$0, datadogContext, timestamp, this.$event.getMessage(), this.$event.getStack(), this.$event.getKind());
                            break;
                        }
                        case 3: {
                            if (this.$event.getConfiguration() == null) {
                                object = TelemetryEventHandler.access$createErrorEvent(this.this$0, datadogContext, timestamp, "Trying to send configuration event with null config", null, null);
                                break;
                            }
                            object = TelemetryEventHandler.access$createConfigurationEvent(this.this$0, datadogContext, timestamp, this.$event.getConfiguration());
                            break;
                        }
                        case 4: {
                            TelemetryEventHandler.access$setTrackNetworkRequests$p(this.this$0, true);
                            object = null;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    TelemetryDebugEvent telemetryEvent = object;
                    if (telemetryEvent != null) {
                        this.$writer.write(eventBatchWriter, telemetryEvent);
                    }
                }
            }, 1, null);
        }
    }

    @Override
    public void onSessionStarted(@NotNull String sessionId, boolean isDiscarded) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.seenInCurrentSession.clear();
    }

    private final boolean canWrite(RumRawEvent.SendTelemetry event) {
        if (!this.eventSampler.sample()) {
            return false;
        }
        if (event.getType() == TelemetryType.CONFIGURATION && !this.configurationExtraSampler.sample()) {
            return false;
        }
        TelemetryEventId eventIdentity = TelemetryEventIdKt.getIdentity(event);
        if (this.seenInCurrentSession.contains(eventIdentity)) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = ALREADY_SEEN_EVENT_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{eventIdentity};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.MAINTAINER, string2, null, 8, null);
            return false;
        }
        if (this.seenInCurrentSession.size() >= this.maxEventCountPerSession) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.MAINTAINER, MAX_EVENT_NUMBER_REACHED_MESSAGE, null, 8, null);
            return false;
        }
        return true;
    }

    private final TelemetryDebugEvent createDebugEvent(DatadogContext datadogContext, long timestamp, String message) {
        TelemetryDebugEvent.Action action;
        TelemetryDebugEvent.View view;
        RumContext rumContext = this.rumContext(datadogContext);
        TelemetryDebugEvent.Dd dd = new TelemetryDebugEvent.Dd();
        Object object = TelemetryEventExtKt.tryFromSource(TelemetryDebugEvent.Source.Companion, datadogContext.getSource());
        TelemetryDebugEvent.Source source = object == null ? TelemetryDebugEvent.Source.ANDROID : object;
        object = datadogContext.getSdkVersion();
        TelemetryDebugEvent.Application application = new TelemetryDebugEvent.Application(rumContext.getApplicationId());
        TelemetryDebugEvent.Session session = new TelemetryDebugEvent.Session(rumContext.getSessionId());
        String string = rumContext.getViewId();
        if (string == null) {
            view = null;
        } else {
            String it = string;
            boolean bl = false;
            view = new TelemetryDebugEvent.View(it);
        }
        TelemetryDebugEvent.View view2 = view;
        String string2 = rumContext.getActionId();
        if (string2 == null) {
            action = null;
        } else {
            String it = string2;
            boolean bl = false;
            action = new TelemetryDebugEvent.Action(it);
        }
        TelemetryDebugEvent.Action action2 = action;
        TelemetryDebugEvent.Telemetry telemetry = new TelemetryDebugEvent.Telemetry(message);
        return new TelemetryDebugEvent(dd, timestamp, TELEMETRY_SERVICE_NAME, source, (String)object, application, session, view2, action2, null, telemetry, 512, null);
    }

    private final TelemetryErrorEvent createErrorEvent(DatadogContext datadogContext, long timestamp, String message, String stack, String kind) {
        TelemetryErrorEvent.Action action;
        TelemetryErrorEvent.View view;
        RumContext rumContext = this.rumContext(datadogContext);
        TelemetryErrorEvent.Dd dd = new TelemetryErrorEvent.Dd();
        Object object = TelemetryEventExtKt.tryFromSource(TelemetryErrorEvent.Source.Companion, datadogContext.getSource());
        TelemetryErrorEvent.Source source = object == null ? TelemetryErrorEvent.Source.ANDROID : object;
        object = datadogContext.getSdkVersion();
        TelemetryErrorEvent.Application application = new TelemetryErrorEvent.Application(rumContext.getApplicationId());
        TelemetryErrorEvent.Session session = new TelemetryErrorEvent.Session(rumContext.getSessionId());
        String string = rumContext.getViewId();
        if (string == null) {
            view = null;
        } else {
            String it = string;
            boolean bl = false;
            view = new TelemetryErrorEvent.View(it);
        }
        TelemetryErrorEvent.View view2 = view;
        String string2 = rumContext.getActionId();
        if (string2 == null) {
            action = null;
        } else {
            String it = string2;
            boolean bl = false;
            action = new TelemetryErrorEvent.Action(it);
        }
        TelemetryErrorEvent.Action action2 = action;
        TelemetryErrorEvent.Telemetry telemetry = new TelemetryErrorEvent.Telemetry(message, stack != null || kind != null ? new TelemetryErrorEvent.Error(stack, kind) : (TelemetryErrorEvent.Error)null);
        return new TelemetryErrorEvent(dd, timestamp, TELEMETRY_SERVICE_NAME, source, (String)object, application, session, view2, action2, null, telemetry, 512, null);
    }

    private final TelemetryConfigurationEvent createConfigurationEvent(DatadogContext datadogContext, long timestamp, Configuration configuration) {
        Long l;
        Long l2;
        Long l3;
        Long l4;
        Long l5;
        TelemetryConfigurationEvent.Action action;
        TelemetryConfigurationEvent.View view;
        String it;
        TelemetryConfigurationEvent.Dd dd;
        long l6;
        String string;
        TelemetryConfigurationEvent.Source source;
        String string2;
        TelemetryConfigurationEvent.Application application;
        TelemetryConfigurationEvent.Session session;
        TelemetryConfigurationEvent.View view2;
        ViewTrackingStrategy viewTrackingStrategy;
        Configuration configuration2 = configuration;
        Configuration.Core coreConfig = configuration2 == null ? null : configuration2.getCoreConfig$dd_sdk_android_release();
        Configuration configuration3 = configuration;
        Configuration.Feature.Tracing traceConfig = configuration3 == null ? null : configuration3.getTracesConfig$dd_sdk_android_release();
        Configuration configuration4 = configuration;
        Configuration.Feature.RUM rumConfig = configuration4 == null ? null : configuration4.getRumConfig$dd_sdk_android_release();
        Configuration configuration5 = configuration;
        Configuration.Feature.CrashReport crashConfig = configuration5 == null ? null : configuration5.getCrashReportConfig$dd_sdk_android_release();
        Configuration.Feature.RUM rUM = rumConfig;
        ViewTrackingStrategy viewTrackingStrategy2 = viewTrackingStrategy = rUM == null ? null : rUM.getViewTrackingStrategy();
        TelemetryConfigurationEvent.ViewTrackingStrategy viewTrackingStrategy3 = viewTrackingStrategy instanceof ActivityViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.ACTIVITYVIEWTRACKINGSTRATEGY : (viewTrackingStrategy instanceof FragmentViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.FRAGMENTVIEWTRACKINGSTRATEGY : (viewTrackingStrategy instanceof MixedViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.MIXEDVIEWTRACKINGSTRATEGY : (viewTrackingStrategy instanceof NavigationViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.NAVIGATIONVIEWTRACKINGSTRATEGY : null)));
        RumContext rumContext = this.rumContext(datadogContext);
        TelemetryConfigurationEvent.Dd dd2 = new TelemetryConfigurationEvent.Dd();
        long l7 = timestamp;
        String string3 = TELEMETRY_SERVICE_NAME;
        TelemetryConfigurationEvent.Source source2 = TelemetryEventExtKt.tryFromSource(TelemetryConfigurationEvent.Source.Companion, datadogContext.getSource());
        TelemetryConfigurationEvent.Source source3 = source2 == null ? TelemetryConfigurationEvent.Source.ANDROID : source2;
        String string4 = datadogContext.getSdkVersion();
        TelemetryConfigurationEvent.Application application2 = new TelemetryConfigurationEvent.Application(rumContext.getApplicationId());
        TelemetryConfigurationEvent.Session session2 = new TelemetryConfigurationEvent.Session(rumContext.getSessionId());
        String string5 = rumContext.getViewId();
        if (string5 == null) {
            view2 = null;
        } else {
            String string6 = string5;
            session = session2;
            application = application2;
            string2 = string4;
            source = source3;
            string = string3;
            l6 = l7;
            dd = dd2;
            boolean bl = false;
            view = new TelemetryConfigurationEvent.View(it);
            dd2 = dd;
            l7 = l6;
            string3 = string;
            source3 = source;
            string4 = string2;
            application2 = application;
            session2 = session;
            view2 = view;
        }
        String string7 = rumContext.getActionId();
        if (string7 == null) {
            action = null;
        } else {
            it = string7;
            view = view2;
            session = session2;
            application = application2;
            string2 = string4;
            source = source3;
            string = string3;
            l6 = l7;
            dd = dd2;
            boolean bl = false;
            TelemetryConfigurationEvent.Action action2 = new TelemetryConfigurationEvent.Action(it);
            dd2 = dd;
            l7 = l6;
            string3 = string;
            source3 = source;
            string4 = string2;
            application2 = application;
            session2 = session;
            view2 = view;
            action = action2;
        }
        Configuration.Feature.RUM rUM2 = rumConfig;
        if (rUM2 == null) {
            l5 = null;
        } else {
            float f = rUM2.getSamplingRate();
            l5 = (long)f;
        }
        source2 = l5;
        Configuration.Feature.RUM rUM3 = rumConfig;
        if (rUM3 == null) {
            l4 = null;
        } else {
            float f = rUM3.getTelemetrySamplingRate();
            l4 = (long)f;
        }
        Long l8 = l4;
        Configuration.Core core = coreConfig;
        boolean bl = (core == null ? null : core.getProxy()) != null;
        Configuration.Feature.RUM rUM4 = rumConfig;
        Boolean bl2 = rUM4 == null ? null : Boolean.valueOf(rUM4.getTrackFrustrations());
        Configuration.Core core2 = coreConfig;
        boolean bl3 = (core2 == null ? null : core2.getEncryption()) != null;
        Configuration.Feature.RUM rUM5 = rumConfig;
        Boolean bl4 = rUM5 == null ? null : Boolean.valueOf(rUM5.getBackgroundEventTracking());
        Configuration.Feature.RUM rUM6 = rumConfig;
        boolean bl5 = (rUM6 == null ? null : rUM6.getUserActionTrackingStrategy()) != null;
        boolean bl6 = crashConfig != null;
        Configuration.Feature.RUM rUM7 = rumConfig;
        boolean bl7 = (rUM7 == null ? null : rUM7.getLongTaskTrackingStrategy()) != null;
        Configuration.Core core3 = coreConfig;
        if (core3 == null) {
            l3 = null;
        } else {
            BatchSize batchSize = core3.getBatchSize();
            l3 = batchSize == null ? null : Long.valueOf(batchSize.getWindowDurationMs$dd_sdk_android_release());
        }
        Long l9 = l3;
        Configuration.Core core4 = coreConfig;
        if (core4 == null) {
            l2 = null;
        } else {
            UploadFrequency uploadFrequency = core4.getUploadFrequency();
            l2 = uploadFrequency == null ? null : Long.valueOf(uploadFrequency.getBaseStepMs$dd_sdk_android_release());
        }
        Long l10 = l2;
        Configuration.Feature.RUM rUM8 = rumConfig;
        if (rUM8 == null) {
            l = null;
        } else {
            VitalsUpdateFrequency vitalsUpdateFrequency = rUM8.getVitalsMonitorUpdateFrequency();
            l = vitalsUpdateFrequency == null ? null : Long.valueOf(vitalsUpdateFrequency.getPeriodInMs$dd_sdk_android_release());
        }
        Long l11 = l;
        boolean bl8 = traceConfig != null && GlobalTracer.isRegistered();
        boolean bl9 = this.trackNetworkRequests;
        TelemetryConfigurationEvent.Telemetry telemetry = new TelemetryConfigurationEvent.Telemetry(new TelemetryConfigurationEvent.Configuration((Long)((Object)source2), l8, null, null, null, null, null, bl, null, null, null, null, null, null, null, null, null, null, null, null, null, bl2, null, bl5, null, null, null, null, bl3, viewTrackingStrategy3, bl4, l11, bl6, bl9, bl8, null, null, bl7, null, null, null, null, l9, l10, null, null, null, 257949564, 29656, null));
        List<String> list = null;
        TelemetryConfigurationEvent.Action action3 = action;
        TelemetryConfigurationEvent.View view3 = view2;
        TelemetryConfigurationEvent.Session session3 = session2;
        TelemetryConfigurationEvent.Application application3 = application2;
        String string8 = string4;
        TelemetryConfigurationEvent.Source source4 = source3;
        String string9 = string3;
        long l12 = l7;
        TelemetryConfigurationEvent.Dd dd3 = dd2;
        return new TelemetryConfigurationEvent(dd3, l12, string9, source4, string8, application3, session3, view3, action3, list, telemetry);
    }

    private final RumContext rumContext(DatadogContext $this$rumContext) {
        Map map = $this$rumContext.getFeaturesContext().get("rum");
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map rumContext = map;
        return RumContext.Companion.fromFeatureContext(rumContext);
    }

    public static final /* synthetic */ TelemetryDebugEvent access$createDebugEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, String message) {
        return $this.createDebugEvent(datadogContext, timestamp, message);
    }

    public static final /* synthetic */ TelemetryErrorEvent access$createErrorEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, String message, String stack, String kind) {
        return $this.createErrorEvent(datadogContext, timestamp, message, stack, kind);
    }

    public static final /* synthetic */ TelemetryConfigurationEvent access$createConfigurationEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, Configuration configuration) {
        return $this.createConfigurationEvent(datadogContext, timestamp, configuration);
    }

    public static final /* synthetic */ void access$setTrackNetworkRequests$p(TelemetryEventHandler $this, boolean bl) {
        $this.trackNetworkRequests = bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/telemetry/internal/TelemetryEventHandler$Companion;", "", "()V", "ALREADY_SEEN_EVENT_MESSAGE", "", "MAX_EVENTS_PER_SESSION", "", "MAX_EVENT_NUMBER_REACHED_MESSAGE", "TELEMETRY_SERVICE_NAME", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

