/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.tracking;

import android.app.Activity;
import android.os.Bundle;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.tracking.ViewLoadingTimer;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.rum.tracking.AcceptAllActivities;
import com.datadog.android.rum.tracking.ActivityLifecycleTrackingStrategy;
import com.datadog.android.rum.tracking.ComponentPredicate;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import com.datadog.android.v2.api.InternalLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lcom/datadog/android/rum/tracking/ActivityViewTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "trackExtras", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "Landroid/app/Activity;", "(ZLcom/datadog/android/rum/tracking/ComponentPredicate;)V", "getComponentPredicate$dd_sdk_android_release", "()Lcom/datadog/android/rum/tracking/ComponentPredicate;", "getTrackExtras$dd_sdk_android_release", "()Z", "viewLoadingTimer", "Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;", "getViewLoadingTimer$dd_sdk_android_release", "()Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;", "setViewLoadingTimer$dd_sdk_android_release", "(Lcom/datadog/android/rum/internal/tracking/ViewLoadingTimer;)V", "equals", "other", "", "hashCode", "", "onActivityCreated", "", "activity", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityPostResumed", "onActivityResumed", "onActivityStarted", "resolveLoadingType", "Lcom/datadog/android/rum/model/ViewEvent$LoadingType;", "firstTimeLoading", "updateLoadingTime", "dd-sdk-android_release"})
public final class ActivityViewTrackingStrategy
extends ActivityLifecycleTrackingStrategy
implements ViewTrackingStrategy {
    private final boolean trackExtras;
    @NotNull
    private final ComponentPredicate<Activity> componentPredicate;
    @NotNull
    private ViewLoadingTimer viewLoadingTimer;

    @JvmOverloads
    public ActivityViewTrackingStrategy(boolean trackExtras, @NotNull ComponentPredicate<Activity> componentPredicate) {
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        this.trackExtras = trackExtras;
        this.componentPredicate = componentPredicate;
        this.viewLoadingTimer = new ViewLoadingTimer();
    }

    public /* synthetic */ ActivityViewTrackingStrategy(boolean bl, ComponentPredicate componentPredicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            componentPredicate = new AcceptAllActivities();
        }
        this(bl, componentPredicate);
    }

    public final boolean getTrackExtras$dd_sdk_android_release() {
        return this.trackExtras;
    }

    @NotNull
    public final ComponentPredicate<Activity> getComponentPredicate$dd_sdk_android_release() {
        return this.componentPredicate;
    }

    @NotNull
    public final ViewLoadingTimer getViewLoadingTimer$dd_sdk_android_release() {
        return this.viewLoadingTimer;
    }

    public final void setViewLoadingTimer$dd_sdk_android_release(@NotNull ViewLoadingTimer viewLoadingTimer) {
        Intrinsics.checkNotNullParameter((Object)viewLoadingTimer, (String)"<set-?>");
        this.viewLoadingTimer = viewLoadingTimer;
    }

    @Override
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityCreated(activity, savedInstanceState);
        ComponentPredicate<Activity> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(activity)) {
            try {
                Activity it = activity;
                boolean bl = false;
                this.getViewLoadingTimer$dd_sdk_android_release().onCreated(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    @Override
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStarted(activity);
        ComponentPredicate<Activity> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(activity)) {
            try {
                Activity it = activity;
                boolean bl = false;
                this.getViewLoadingTimer$dd_sdk_android_release().onStartLoading(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    @Override
    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityResumed(activity);
        ComponentPredicate<Activity> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(activity)) {
            try {
                Activity it = activity;
                boolean bl = false;
                ComponentPredicate<Activity> $this$resolveViewName$iv = this.getComponentPredicate$dd_sdk_android_release();
                boolean $i$f$resolveViewName = false;
                String customName$iv = $this$resolveViewName$iv.getViewName(activity);
                CharSequence charSequence = customName$iv;
                String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(activity) : customName$iv;
                Map<String, Object> attributes = this.getTrackExtras$dd_sdk_android_release() ? this.convertToRumAttributes(it.getIntent()) : MapsKt.emptyMap();
                GlobalRum.INSTANCE.getMonitor$dd_sdk_android_release().startView(it, viewName, attributes);
                this.getViewLoadingTimer$dd_sdk_android_release().onFinishedLoading(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public void onActivityPostResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        ComponentPredicate<Activity> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(activity)) {
            try {
                Activity it = activity;
                boolean bl = false;
                this.getViewLoadingTimer$dd_sdk_android_release().onFinishedLoading(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    @Override
    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityPaused(activity);
        ComponentPredicate<Activity> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(activity)) {
            try {
                Activity it = activity;
                boolean bl = false;
                this.updateLoadingTime(activity);
                RumMonitor.DefaultImpls.stopView$default(GlobalRum.INSTANCE.getMonitor$dd_sdk_android_release(), it, null, 2, null);
                this.getViewLoadingTimer$dd_sdk_android_release().onPaused(activity);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    @Override
    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityDestroyed(activity);
        ComponentPredicate<Activity> $this$runIfValid$iv = this.componentPredicate;
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(activity)) {
            try {
                Activity it = activity;
                boolean bl = false;
                this.getViewLoadingTimer$dd_sdk_android_release().onDestroyed(it);
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Internal operation failed", (Throwable)e$iv);
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object == null ? null : object.getClass())) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.datadog.android.rum.tracking.ActivityViewTrackingStrategy");
        }
        ActivityViewTrackingStrategy cfr_ignored_0 = (ActivityViewTrackingStrategy)object2;
        if (this.trackExtras != ((ActivityViewTrackingStrategy)other).trackExtras) {
            return false;
        }
        return Intrinsics.areEqual(this.componentPredicate, ((ActivityViewTrackingStrategy)other).componentPredicate);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.trackExtras);
        result = 31 * result + this.componentPredicate.hashCode();
        return result;
    }

    private final void updateLoadingTime(Activity activity) {
        Long l = this.viewLoadingTimer.getLoadingTime(activity);
        if (l != null) {
            AdvancedRumMonitor advancedRumMonitor2;
            long loadingTime = ((Number)l).longValue();
            boolean bl = false;
            RumMonitor rumMonitor = GlobalRum.get();
            AdvancedRumMonitor advancedRumMonitor3 = advancedRumMonitor2 = rumMonitor instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor : null;
            if (advancedRumMonitor3 != null) {
                AdvancedRumMonitor monitor = advancedRumMonitor3;
                boolean bl2 = false;
                ViewEvent.LoadingType loadingType = this.resolveLoadingType(this.getViewLoadingTimer$dd_sdk_android_release().isFirstTimeLoading(activity));
                monitor.updateViewLoadingTime(activity, loadingTime, loadingType);
            }
        }
    }

    private final ViewEvent.LoadingType resolveLoadingType(boolean firstTimeLoading) {
        return firstTimeLoading ? ViewEvent.LoadingType.ACTIVITY_DISPLAY : ViewEvent.LoadingType.ACTIVITY_REDISPLAY;
    }

    @JvmOverloads
    public ActivityViewTrackingStrategy(boolean trackExtras) {
        this(trackExtras, null, 2, null);
    }
}

