/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.rum.internal.vitals.VitalReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/vitals/MemoryVitalReader;", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "statusFile", "Ljava/io/File;", "(Ljava/io/File;)V", "getStatusFile$dd_sdk_android_release", "()Ljava/io/File;", "readVitalData", "", "()Ljava/lang/Double;", "Companion", "dd-sdk-android_release"})
public final class MemoryVitalReader
implements VitalReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File statusFile;
    private static final int BYTES_IN_KB = 1000;
    @NotNull
    private static final String STATUS_PATH = "/proc/self/status";
    @NotNull
    private static final File STATUS_FILE = new File("/proc/self/status");
    @NotNull
    private static final String VM_RSS_PATTERN = "VmRSS:\\s+(\\d+) kB";
    @NotNull
    private static final Regex VM_RSS_REGEX = new Regex("VmRSS:\\s+(\\d+) kB");

    public MemoryVitalReader(@NotNull File statusFile) {
        Intrinsics.checkNotNullParameter((Object)statusFile, (String)"statusFile");
        this.statusFile = statusFile;
    }

    public /* synthetic */ MemoryVitalReader(File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = STATUS_FILE;
        }
        this(file);
    }

    @NotNull
    public final File getStatusFile$dd_sdk_android_release() {
        return this.statusFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Double readVitalData() {
        Double d;
        if (!FileExtKt.existsSafe(this.statusFile) || !FileExtKt.canReadSafe(this.statusFile)) {
            return null;
        }
        List list = FileExtKt.readLinesSafe$default(this.statusFile, null, 1, null);
        if (list == null) {
            d = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object = list;
            boolean $i$f$mapNotNull = false;
            void var6_4 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                MatchResult matchResult = VM_RSS_REGEX.matchEntire((CharSequence)line);
                if (matchResult == null) {
                    string = null;
                } else {
                    List list2 = matchResult.getGroupValues();
                    string = list2 == null ? null : (String)CollectionsKt.getOrNull((List)list2, (int)1);
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            object = (String)CollectionsKt.firstOrNull((List)list3);
            d = object == null ? null : StringsKt.toDoubleOrNull((String)object);
        }
        Double memorySizeKb = d;
        return memorySizeKb == null ? (Double)null : Double.valueOf(memorySizeKb * (double)1000);
    }

    public MemoryVitalReader() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/rum/internal/vitals/MemoryVitalReader$Companion;", "", "()V", "BYTES_IN_KB", "", "STATUS_FILE", "Ljava/io/File;", "getSTATUS_FILE$dd_sdk_android_release", "()Ljava/io/File;", "STATUS_PATH", "", "VM_RSS_PATTERN", "VM_RSS_REGEX", "Lkotlin/text/Regex;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getSTATUS_FILE$dd_sdk_android_release() {
            return STATUS_FILE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

