/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import com.datadog.android.rum.internal.vitals.VitalInfo;
import com.datadog.android.rum.internal.vitals.VitalListener;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/rum/internal/vitals/AggregatingVitalMonitor;", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "()V", "lastKnownSample", "", "listeners", "", "Lcom/datadog/android/rum/internal/vitals/VitalListener;", "Lcom/datadog/android/rum/internal/vitals/VitalInfo;", "getLastSample", "notifyListener", "", "listener", "value", "notifyListeners", "onNewSample", "register", "unregister", "dd-sdk-android_release"})
public final class AggregatingVitalMonitor
implements VitalMonitor {
    private double lastKnownSample = Double.NaN;
    @NotNull
    private final Map<VitalListener, VitalInfo> listeners = new LinkedHashMap();

    @Override
    public void onNewSample(double value) {
        this.lastKnownSample = value;
        this.notifyListeners(value);
    }

    @Override
    public double getLastSample() {
        return this.lastKnownSample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(@NotNull VitalListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        double value = this.lastKnownSample;
        Map<VitalListener, VitalInfo> map = this.listeners;
        synchronized (map) {
            boolean bl = false;
            Map<VitalListener, VitalInfo> map2 = this.listeners;
            VitalInfo vitalInfo = VitalInfo.Companion.getEMPTY();
            map2.put(listener, vitalInfo);
            Unit unit = Unit.INSTANCE;
        }
        if (!Double.isNaN(value)) {
            this.notifyListener(listener, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(@NotNull VitalListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Map<VitalListener, VitalInfo> map = this.listeners;
        synchronized (map) {
            boolean bl = false;
            VitalInfo vitalInfo = this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListeners(double value) {
        Map<VitalListener, VitalInfo> map = this.listeners;
        synchronized (map) {
            boolean bl = false;
            for (VitalListener listener : this.listeners.keySet()) {
                this.notifyListener(listener, value);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListener(VitalListener listener, double value) {
        VitalInfo vitalInfo = this.listeners.get(listener);
        if (vitalInfo == null) {
            vitalInfo = VitalInfo.Companion.getEMPTY();
        }
        VitalInfo vitalInfo2 = vitalInfo;
        int newSampleCount = vitalInfo2.getSampleCount() + 1;
        double meanValue = (value + (double)vitalInfo2.getSampleCount() * vitalInfo2.getMeanValue()) / (double)newSampleCount;
        double d = vitalInfo2.getMinValue();
        double d2 = Math.min(value, d);
        d = vitalInfo2.getMaxValue();
        VitalInfo updatedInfo = new VitalInfo(newSampleCount, d2, Math.max(value, d), meanValue);
        listener.onVitalUpdate(updatedInfo);
        Map<VitalListener, VitalInfo> map = this.listeners;
        synchronized (map) {
            boolean bl = false;
            this.listeners.put(listener, updatedInfo);
            Unit unit = Unit.INSTANCE;
        }
    }
}

