/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.ndk;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileReader;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReader;
import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import com.datadog.android.rum.internal.ndk.NdkCrashHandler;
import com.datadog.android.rum.internal.ndk.NdkCrashLog;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.api.context.NetworkInfo;
import com.datadog.android.v2.api.context.UserInfo;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\b\u0003\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0007\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0003J\b\u0010,\u001a\u00020)H\u0002J\b\u0010-\u001a\u00020)H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J8\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u00010\t2\b\u00101\u001a\u0004\u0018\u00010\u000b2\b\u00102\u001a\u0004\u0018\u00010\u000f2\b\u00103\u001a\u0004\u0018\u00010\rH\u0003J\b\u00104\u001a\u00020)H\u0016J\b\u00105\u001a\u00020)H\u0003J\u001a\u00106\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0015H\u0003J\u001a\u00109\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0013H\u0003JH\u0010:\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010;\u001a\u00020\b2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0=2\u0006\u00100\u001a\u00020\t2\b\u00103\u001a\u0004\u0018\u00010\r2\b\u00102\u001a\u0004\u0018\u00010\u000fH\u0003J(\u0010>\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010;\u001a\u00020\b2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\u000bH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001c\u0010\"\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR\u0014\u0010%\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/datadog/android/rum/internal/ndk/DatadogNdkCrashHandler;", "Lcom/datadog/android/rum/internal/ndk/NdkCrashHandler;", "storageDir", "Ljava/io/File;", "dataPersistenceExecutorService", "Ljava/util/concurrent/ExecutorService;", "ndkCrashLogDeserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "", "Lcom/datadog/android/rum/internal/ndk/NdkCrashLog;", "rumEventDeserializer", "Lcom/google/gson/JsonObject;", "networkInfoDeserializer", "Lcom/datadog/android/v2/api/context/NetworkInfo;", "userInfoDeserializer", "Lcom/datadog/android/v2/api/context/UserInfo;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "rumFileReader", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReader;", "envFileReader", "Lcom/datadog/android/core/internal/persistence/file/FileReader;", "(Ljava/io/File;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/v2/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReader;Lcom/datadog/android/core/internal/persistence/file/FileReader;)V", "lastSerializedNdkCrashLog", "getLastSerializedNdkCrashLog$dd_sdk_android_release", "()Ljava/lang/String;", "setLastSerializedNdkCrashLog$dd_sdk_android_release", "(Ljava/lang/String;)V", "lastSerializedNetworkInformation", "getLastSerializedNetworkInformation$dd_sdk_android_release", "setLastSerializedNetworkInformation$dd_sdk_android_release", "lastSerializedRumViewEvent", "getLastSerializedRumViewEvent$dd_sdk_android_release", "setLastSerializedRumViewEvent$dd_sdk_android_release", "lastSerializedUserInformation", "getLastSerializedUserInformation$dd_sdk_android_release", "setLastSerializedUserInformation$dd_sdk_android_release", "ndkCrashDataDirectory", "getNdkCrashDataDirectory$dd_sdk_android_release", "()Ljava/io/File;", "checkAndHandleNdkCrashReport", "", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "clearAllReferences", "clearCrashLog", "handleNdkCrash", "handleNdkCrashLog", "ndkCrashLog", "lastViewEvent", "lastUserInfo", "lastNetworkInfo", "prepareData", "readCrashData", "readFileContent", "file", "fileReader", "readRumFileContent", "sendCrashLogEvent", "errorLogMessage", "logAttributes", "", "updateViewEventAndSendError", "Companion", "dd-sdk-android_release"})
public final class DatadogNdkCrashHandler
implements NdkCrashHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService dataPersistenceExecutorService;
    @NotNull
    private final Deserializer<String, NdkCrashLog> ndkCrashLogDeserializer;
    @NotNull
    private final Deserializer<String, JsonObject> rumEventDeserializer;
    @NotNull
    private final Deserializer<String, NetworkInfo> networkInfoDeserializer;
    @NotNull
    private final Deserializer<String, UserInfo> userInfoDeserializer;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final BatchFileReader rumFileReader;
    @NotNull
    private final FileReader envFileReader;
    @NotNull
    private final File ndkCrashDataDirectory;
    @Nullable
    private String lastSerializedRumViewEvent;
    @Nullable
    private String lastSerializedUserInformation;
    @Nullable
    private String lastSerializedNdkCrashLog;
    @Nullable
    private String lastSerializedNetworkInformation;
    @NotNull
    public static final String RUM_VIEW_EVENT_FILE_NAME = "last_view_event";
    @NotNull
    public static final String CRASH_DATA_FILE_NAME = "crash_log";
    @NotNull
    public static final String USER_INFO_FILE_NAME = "user_information";
    @NotNull
    public static final String NETWORK_INFO_FILE_NAME = "network_information";
    @NotNull
    public static final String LOGGER_NAME = "ndk_crash";
    @NotNull
    public static final String LOG_CRASH_MSG = "NDK crash detected with signal: %s";
    @NotNull
    public static final String ERROR_READ_NDK_DIR = "Error while trying to read the NDK crash directory";
    @NotNull
    public static final String ERROR_TASK_REJECTED = "Unable to schedule operation on the executor";
    @NotNull
    public static final String WARN_CANNOT_READ_VIEW_INFO_DATA = "Cannot read application, session, view IDs data from view event.";
    @NotNull
    public static final String INFO_LOGS_FEATURE_NOT_REGISTERED = "Logs feature is not registered, won't report NDK crash info as log.";
    @NotNull
    public static final String INFO_RUM_FEATURE_NOT_REGISTERED = "RUM feature is not registered, won't report NDK crash info as RUM error.";
    private static final int STORAGE_VERSION = 2;
    @NotNull
    public static final String NDK_CRASH_REPORTS_FOLDER_NAME = "ndk_crash_reports_v2";
    @NotNull
    private static final String NDK_CRASH_REPORTS_PENDING_FOLDER_NAME = "ndk_crash_reports_intermediary_v2";

    public DatadogNdkCrashHandler(@NotNull File storageDir, @NotNull ExecutorService dataPersistenceExecutorService, @NotNull Deserializer<String, NdkCrashLog> ndkCrashLogDeserializer, @NotNull Deserializer<String, JsonObject> rumEventDeserializer, @NotNull Deserializer<String, NetworkInfo> networkInfoDeserializer, @NotNull Deserializer<String, UserInfo> userInfoDeserializer, @NotNull InternalLogger internalLogger, @NotNull BatchFileReader rumFileReader, @NotNull FileReader envFileReader) {
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        Intrinsics.checkNotNullParameter((Object)dataPersistenceExecutorService, (String)"dataPersistenceExecutorService");
        Intrinsics.checkNotNullParameter(ndkCrashLogDeserializer, (String)"ndkCrashLogDeserializer");
        Intrinsics.checkNotNullParameter(rumEventDeserializer, (String)"rumEventDeserializer");
        Intrinsics.checkNotNullParameter(networkInfoDeserializer, (String)"networkInfoDeserializer");
        Intrinsics.checkNotNullParameter(userInfoDeserializer, (String)"userInfoDeserializer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)rumFileReader, (String)"rumFileReader");
        Intrinsics.checkNotNullParameter((Object)envFileReader, (String)"envFileReader");
        this.dataPersistenceExecutorService = dataPersistenceExecutorService;
        this.ndkCrashLogDeserializer = ndkCrashLogDeserializer;
        this.rumEventDeserializer = rumEventDeserializer;
        this.networkInfoDeserializer = networkInfoDeserializer;
        this.userInfoDeserializer = userInfoDeserializer;
        this.internalLogger = internalLogger;
        this.rumFileReader = rumFileReader;
        this.envFileReader = envFileReader;
        this.ndkCrashDataDirectory = DatadogNdkCrashHandler.Companion.getNdkGrantedDir(storageDir);
    }

    @NotNull
    public final File getNdkCrashDataDirectory$dd_sdk_android_release() {
        return this.ndkCrashDataDirectory;
    }

    @Nullable
    public final String getLastSerializedRumViewEvent$dd_sdk_android_release() {
        return this.lastSerializedRumViewEvent;
    }

    public final void setLastSerializedRumViewEvent$dd_sdk_android_release(@Nullable String string) {
        this.lastSerializedRumViewEvent = string;
    }

    @Nullable
    public final String getLastSerializedUserInformation$dd_sdk_android_release() {
        return this.lastSerializedUserInformation;
    }

    public final void setLastSerializedUserInformation$dd_sdk_android_release(@Nullable String string) {
        this.lastSerializedUserInformation = string;
    }

    @Nullable
    public final String getLastSerializedNdkCrashLog$dd_sdk_android_release() {
        return this.lastSerializedNdkCrashLog;
    }

    public final void setLastSerializedNdkCrashLog$dd_sdk_android_release(@Nullable String string) {
        this.lastSerializedNdkCrashLog = string;
    }

    @Nullable
    public final String getLastSerializedNetworkInformation$dd_sdk_android_release() {
        return this.lastSerializedNetworkInformation;
    }

    public final void setLastSerializedNetworkInformation$dd_sdk_android_release(@Nullable String string) {
        this.lastSerializedNetworkInformation = string;
    }

    @Override
    public void prepareData() {
        try {
            this.dataPersistenceExecutorService.submit(() -> DatadogNdkCrashHandler.prepareData$lambda-0(this));
        }
        catch (RejectedExecutionException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            this.internalLogger.log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), ERROR_TASK_REJECTED, (Throwable)e);
        }
    }

    @Override
    public void handleNdkCrash(@NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        try {
            this.dataPersistenceExecutorService.submit(() -> DatadogNdkCrashHandler.handleNdkCrash$lambda-1(this, sdkCore));
        }
        catch (RejectedExecutionException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            this.internalLogger.log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), ERROR_TASK_REJECTED, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void readCrashData() {
        block24: {
            if (!FileExtKt.existsSafe(this.ndkCrashDataDirectory)) {
                return;
            }
            try {
                File[] fileArray = FileExtKt.listFilesSafe(this.ndkCrashDataDirectory);
                if (fileArray == null) {
                    break block24;
                }
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = 0;
                int n2 = fileArray2.length;
                while (n < n2) {
                    File element$iv = fileArray2[n];
                    ++n;
                    File it = element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    if (string == null) continue;
                    int n3 = -1;
                    switch (string.hashCode()) {
                        case 1847397036: {
                            if (string.equals(CRASH_DATA_FILE_NAME)) {
                                n3 = 1;
                            }
                            break;
                        }
                        case -528983909: {
                            if (string.equals(NETWORK_INFO_FILE_NAME)) {
                                n3 = 2;
                            }
                            break;
                        }
                        case 75377097: {
                            if (string.equals(RUM_VIEW_EVENT_FILE_NAME)) {
                                n3 = 3;
                            }
                            break;
                        }
                        case 408381112: {
                            if (string.equals(USER_INFO_FILE_NAME)) {
                                n3 = 4;
                            }
                            break;
                        }
                    }
                    switch (n3) {
                        case 1: {
                            this.setLastSerializedNdkCrashLog$dd_sdk_android_release(FileExtKt.readTextSafe$default(it, null, 1, null));
                            break;
                        }
                        case 3: {
                            this.setLastSerializedRumViewEvent$dd_sdk_android_release(this.readRumFileContent(it, this.rumFileReader));
                            break;
                        }
                        case 4: {
                            this.setLastSerializedUserInformation$dd_sdk_android_release(this.readFileContent(it, this.envFileReader));
                            break;
                        }
                        case 2: {
                            this.setLastSerializedNetworkInformation$dd_sdk_android_release(this.readFileContent(it, this.envFileReader));
                        }
                    }
                }
            }
            catch (SecurityException e) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                this.internalLogger.log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), ERROR_READ_NDK_DIR, (Throwable)e);
            }
            finally {
                this.clearCrashLog();
            }
        }
    }

    @WorkerThread
    private final String readFileContent(File file, FileReader fileReader) {
        byte[] content = fileReader.readData(file);
        return content.length == 0 ? (String)null : new String(content, Charsets.UTF_8);
    }

    @WorkerThread
    private final String readRumFileContent(File file, BatchFileReader fileReader) {
        List<byte[]> content = fileReader.readData(file);
        return content.isEmpty() ? (String)null : new String(ByteArrayExtKt.join$default(content, new byte[0], null, null, 6, null), Charsets.UTF_8);
    }

    @WorkerThread
    private final void checkAndHandleNdkCrashReport(SdkCore sdkCore) {
        String lastSerializedRumViewEvent = this.lastSerializedRumViewEvent;
        String lastSerializedUserInformation = this.lastSerializedUserInformation;
        String lastSerializedNdkCrashLog = this.lastSerializedNdkCrashLog;
        String lastSerializedNetworkInformation = this.lastSerializedNetworkInformation;
        if (lastSerializedNdkCrashLog != null) {
            NetworkInfo networkInfo;
            UserInfo userInfo;
            JsonObject jsonObject;
            NdkCrashLog lastNdkCrashLog = this.ndkCrashLogDeserializer.deserialize(lastSerializedNdkCrashLog);
            String string = lastSerializedRumViewEvent;
            if (string == null) {
                jsonObject = null;
            } else {
                String it = string;
                boolean bl = false;
                jsonObject = this.rumEventDeserializer.deserialize(it);
            }
            JsonObject lastRumViewEvent = jsonObject;
            String string2 = lastSerializedUserInformation;
            if (string2 == null) {
                userInfo = null;
            } else {
                String it = string2;
                boolean bl = false;
                userInfo = this.userInfoDeserializer.deserialize(it);
            }
            UserInfo lastUserInfo = userInfo;
            String string3 = lastSerializedNetworkInformation;
            if (string3 == null) {
                networkInfo = null;
            } else {
                String it = string3;
                boolean bl = false;
                networkInfo = this.networkInfoDeserializer.deserialize(it);
            }
            NetworkInfo lastNetworkInfo = networkInfo;
            this.handleNdkCrashLog(sdkCore, lastNdkCrashLog, lastRumViewEvent, lastUserInfo, lastNetworkInfo);
        }
        this.clearAllReferences();
    }

    private final void clearAllReferences() {
        this.lastSerializedNdkCrashLog = null;
        this.lastSerializedNetworkInformation = null;
        this.lastSerializedRumViewEvent = null;
        this.lastSerializedUserInformation = null;
    }

    @WorkerThread
    private final void handleNdkCrashLog(SdkCore sdkCore, NdkCrashLog ndkCrashLog, JsonObject lastViewEvent, UserInfo lastUserInfo, NetworkInfo lastNetworkInfo) {
        if (ndkCrashLog == null) {
            return;
        }
        String string = LOG_CRASH_MSG;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{ndkCrashLog.getSignalName()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
        String errorLogMessage = string2;
        Map logAttributes = null;
        if (lastViewEvent != null) {
            Map map;
            Function1 extractId2;
            try {
                extractId2 = (Function1)new Function1<String, String>(lastViewEvent){
                    final /* synthetic */ JsonObject $lastViewEvent;
                    {
                        this.$lastViewEvent = $lastViewEvent;
                        super(1);
                    }

                    public final String invoke(@NotNull String property) {
                        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                        return this.$lastViewEvent.getAsJsonObject(property).getAsJsonPrimitive("id").getAsString();
                    }
                };
                String applicationId = (String)extractId2.invoke((Object)"application");
                String sessionId = (String)extractId2.invoke((Object)"session");
                String viewId = (String)extractId2.invoke((Object)"view");
                extractId2 = new Triple((Object)applicationId, (Object)sessionId, (Object)viewId);
            }
            catch (Exception e) {
                this.internalLogger.log(InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, WARN_CANNOT_READ_VIEW_INFO_DATA, (Throwable)e);
                extractId2 = new Triple(null, null, null);
            }
            locale = extractId2;
            String applicationId = (String)locale.component1();
            String sessionId = (String)locale.component2();
            String viewId = (String)locale.component3();
            if (applicationId != null && sessionId != null && viewId != null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"session_id", (Object)sessionId), TuplesKt.to((Object)"application_id", (Object)applicationId), TuplesKt.to((Object)"view.id", (Object)viewId), TuplesKt.to((Object)"error.stack", (Object)ndkCrashLog.getStacktrace())};
                map = MapsKt.mapOf((Pair[])pairArray);
            } else {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.stack", (Object)ndkCrashLog.getStacktrace()));
            }
            logAttributes = map;
            this.updateViewEventAndSendError(sdkCore, errorLogMessage, ndkCrashLog, lastViewEvent);
        } else {
            logAttributes = MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.stack", (Object)ndkCrashLog.getStacktrace()));
        }
        this.sendCrashLogEvent(sdkCore, errorLogMessage, logAttributes, ndkCrashLog, lastNetworkInfo, lastUserInfo);
    }

    @WorkerThread
    private final void updateViewEventAndSendError(SdkCore sdkCore, String errorLogMessage, NdkCrashLog ndkCrashLog, JsonObject lastViewEvent) {
        FeatureScope rumFeature = sdkCore.getFeature("rum");
        if (rumFeature != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)LOGGER_NAME), TuplesKt.to((Object)"timestamp", (Object)ndkCrashLog.getTimestamp()), TuplesKt.to((Object)"signalName", (Object)ndkCrashLog.getSignalName()), TuplesKt.to((Object)"stacktrace", (Object)ndkCrashLog.getStacktrace()), TuplesKt.to((Object)"message", (Object)errorLogMessage), TuplesKt.to((Object)"lastViewEvent", (Object)lastViewEvent)};
            rumFeature.sendEvent(MapsKt.mapOf((Pair[])pairArray));
        } else {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.USER, INFO_RUM_FEATURE_NOT_REGISTERED, null, 8, null);
        }
    }

    @WorkerThread
    private final void sendCrashLogEvent(SdkCore sdkCore, String errorLogMessage, Map<String, String> logAttributes, NdkCrashLog ndkCrashLog, NetworkInfo lastNetworkInfo, UserInfo lastUserInfo) {
        FeatureScope logsFeature = sdkCore.getFeature("logs");
        if (logsFeature != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"loggerName", (Object)LOGGER_NAME), TuplesKt.to((Object)"type", (Object)LOGGER_NAME), TuplesKt.to((Object)"message", (Object)errorLogMessage), TuplesKt.to((Object)"attributes", logAttributes), TuplesKt.to((Object)"timestamp", (Object)ndkCrashLog.getTimestamp()), TuplesKt.to((Object)"networkInfo", (Object)lastNetworkInfo), TuplesKt.to((Object)"userInfo", (Object)lastUserInfo)};
            logsFeature.sendEvent(MapsKt.mapOf((Pair[])pairArray));
        } else {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.USER, INFO_LOGS_FEATURE_NOT_REGISTERED, null, 8, null);
        }
    }

    private final void clearCrashLog() {
        if (FileExtKt.existsSafe(this.ndkCrashDataDirectory)) {
            try {
                File[] fileArray = FileExtKt.listFilesSafe(this.ndkCrashDataDirectory);
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    for (File element$iv : $this$forEach$iv) {
                        File it = element$iv;
                        boolean bl = false;
                        FilesKt.deleteRecursively((File)it);
                    }
                }
            }
            catch (Throwable e) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                this.internalLogger.log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Unable to clear the NDK crash report file: " + this.ndkCrashDataDirectory.getAbsolutePath(), e);
            }
        }
    }

    private static final void prepareData$lambda-0(DatadogNdkCrashHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.readCrashData();
    }

    private static final void handleNdkCrash$lambda-1(DatadogNdkCrashHandler this$0, SdkCore $sdkCore) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sdkCore, (String)"$sdkCore");
        this$0.checkAndHandleNdkCrashReport($sdkCore);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0015\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/datadog/android/rum/internal/ndk/DatadogNdkCrashHandler$Companion;", "", "()V", "CRASH_DATA_FILE_NAME", "", "ERROR_READ_NDK_DIR", "ERROR_TASK_REJECTED", "INFO_LOGS_FEATURE_NOT_REGISTERED", "INFO_RUM_FEATURE_NOT_REGISTERED", "LOGGER_NAME", "LOG_CRASH_MSG", "NDK_CRASH_REPORTS_FOLDER_NAME", "NDK_CRASH_REPORTS_PENDING_FOLDER_NAME", "NETWORK_INFO_FILE_NAME", "RUM_VIEW_EVENT_FILE_NAME", "STORAGE_VERSION", "", "USER_INFO_FILE_NAME", "WARN_CANNOT_READ_VIEW_INFO_DATA", "getGrantedNetworkInfoFile", "Ljava/io/File;", "storageDir", "getGrantedNetworkInfoFile$dd_sdk_android_release", "getGrantedUserInfoFile", "getGrantedUserInfoFile$dd_sdk_android_release", "getLastViewEventFile", "getLastViewEventFile$dd_sdk_android_release", "getNdkGrantedDir", "getNdkPendingDir", "getPendingNetworkInfoFile", "getPendingNetworkInfoFile$dd_sdk_android_release", "getPendingUserInfoFile", "getPendingUserInfoFile$dd_sdk_android_release", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        private final File getNdkGrantedDir(File storageDir) {
            return new File(storageDir, DatadogNdkCrashHandler.NDK_CRASH_REPORTS_FOLDER_NAME);
        }

        private final File getNdkPendingDir(File storageDir) {
            return new File(storageDir, DatadogNdkCrashHandler.NDK_CRASH_REPORTS_PENDING_FOLDER_NAME);
        }

        @NotNull
        public final File getLastViewEventFile$dd_sdk_android_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkGrantedDir(storageDir), DatadogNdkCrashHandler.RUM_VIEW_EVENT_FILE_NAME);
        }

        @NotNull
        public final File getPendingNetworkInfoFile$dd_sdk_android_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkPendingDir(storageDir), DatadogNdkCrashHandler.NETWORK_INFO_FILE_NAME);
        }

        @NotNull
        public final File getGrantedNetworkInfoFile$dd_sdk_android_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkGrantedDir(storageDir), DatadogNdkCrashHandler.NETWORK_INFO_FILE_NAME);
        }

        @NotNull
        public final File getPendingUserInfoFile$dd_sdk_android_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkPendingDir(storageDir), DatadogNdkCrashHandler.USER_INFO_FILE_NAME);
        }

        @NotNull
        public final File getGrantedUserInfoFile$dd_sdk_android_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkGrantedDir(storageDir), DatadogNdkCrashHandler.USER_INFO_FILE_NAME);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

