/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesDetectorWrapper;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesUtilsKt;
import com.datadog.android.rum.tracking.InteractionPredicate;
import com.datadog.android.rum.tracking.NoOpInteractionPredicate;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import com.datadog.android.v2.api.InternalLogger;
import java.lang.ref.WeakReference;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 I2\u00020\u0001:\u0001IBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J\u0012\u0010#\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0019\u0010&\u001a\u00020!2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010%0%H\u0096\u0001J\u0019\u0010'\u001a\u00020!2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010(0(H\u0096\u0001J\u0012\u0010)\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0016J\u0019\u0010*\u001a\u00020!2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J\u0010\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010-\u001a\u00020,H\u0002J\u0019\u0010.\u001a\u00020,2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010/0/H\u0096\u0001J\u0019\u00100\u001a\u00020,2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010/0/H\u0096\u0001J\t\u00101\u001a\u00020,H\u0096\u0001J\t\u00102\u001a\u00020,H\u0096\u0001J\u001b\u00103\u001a\u00020!2\u0006\u0010\"\u001a\u0002042\b\b\u0001\u00105\u001a\u000206H\u0096\u0001J\u0013\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\"\u001a\u000204H\u0097\u0001J\t\u00109\u001a\u00020,H\u0096\u0001J\u0018\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020=H\u0016J\u001b\u0010>\u001a\u00020!2\u0006\u0010\"\u001a\u0002042\b\b\u0001\u00105\u001a\u000206H\u0096\u0001J\u001b\u0010?\u001a\u00020,2\u0006\u0010\"\u001a\u0002042\b\b\u0001\u00105\u001a\u000206H\u0096\u0001J'\u0010@\u001a\u00020!2\u0006\u0010\"\u001a\u0002042\n\b\u0001\u00105\u001a\u0004\u0018\u0001082\b\b\u0001\u0010A\u001a\u000206H\u0096\u0001J\t\u0010B\u001a\u00020!H\u0096\u0001J\u0019\u0010B\u001a\u00020!2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010C0CH\u0096\u0001J\u0019\u0010D\u001a\u00020,2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010E0EH\u0096\u0001J\u0011\u0010F\u001a\u00020,2\u0006\u0010\"\u001a\u00020!H\u0096\u0001J\u001b\u0010G\u001a\u0004\u0018\u00010/2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010H0HH\u0097\u0001J#\u0010G\u001a\u0004\u0018\u00010/2\u000e\u0010\"\u001a\n \u001b*\u0004\u0018\u00010H0H2\u0006\u00105\u001a\u000204H\u0097\u0001R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00030\u00030\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006J"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/WindowCallbackWrapper;", "Landroid/view/Window$Callback;", "window", "Landroid/view/Window;", "wrappedCallback", "gesturesDetector", "Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "copyEvent", "Lkotlin/Function1;", "Landroid/view/MotionEvent;", "targetAttributesProviders", "", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "(Landroid/view/Window;Landroid/view/Window$Callback;Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;Lcom/datadog/android/rum/tracking/InteractionPredicate;Lkotlin/jvm/functions/Function1;[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;)V", "getCopyEvent", "()Lkotlin/jvm/functions/Function1;", "getGesturesDetector", "()Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;", "getInteractionPredicate", "()Lcom/datadog/android/rum/tracking/InteractionPredicate;", "getTargetAttributesProviders", "()[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "windowReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getWindowReference$dd_sdk_android_release", "()Ljava/lang/ref/WeakReference;", "getWrappedCallback", "()Landroid/view/Window$Callback;", "dispatchGenericMotionEvent", "", "p0", "dispatchKeyEvent", "event", "Landroid/view/KeyEvent;", "dispatchKeyShortcutEvent", "dispatchPopulateAccessibilityEvent", "Landroid/view/accessibility/AccessibilityEvent;", "dispatchTouchEvent", "dispatchTrackballEvent", "handleBackEvent", "", "handleRemoteControlActionEvent", "onActionModeFinished", "Landroid/view/ActionMode;", "onActionModeStarted", "onAttachedToWindow", "onContentChanged", "onCreatePanelMenu", "", "p1", "Landroid/view/Menu;", "onCreatePanelView", "Landroid/view/View;", "onDetachedFromWindow", "onMenuItemSelected", "featureId", "item", "Landroid/view/MenuItem;", "onMenuOpened", "onPanelClosed", "onPreparePanel", "p2", "onSearchRequested", "Landroid/view/SearchEvent;", "onWindowAttributesChanged", "Landroid/view/WindowManager$LayoutParams;", "onWindowFocusChanged", "onWindowStartingActionMode", "Landroid/view/ActionMode$Callback;", "Companion", "dd-sdk-android_release"})
public final class WindowCallbackWrapper
implements Window.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Window.Callback wrappedCallback;
    @NotNull
    private final GesturesDetectorWrapper gesturesDetector;
    @NotNull
    private final InteractionPredicate interactionPredicate;
    @NotNull
    private final Function1<MotionEvent, MotionEvent> copyEvent;
    @NotNull
    private final ViewAttributesProvider[] targetAttributesProviders;
    @NotNull
    private final WeakReference<Window> windowReference;
    @NotNull
    public static final String BACK_DEFAULT_TARGET_NAME = "back";
    public static final boolean EVENT_CONSUMED = true;

    public WindowCallbackWrapper(@NotNull Window window, @NotNull Window.Callback wrappedCallback, @NotNull GesturesDetectorWrapper gesturesDetector, @NotNull InteractionPredicate interactionPredicate, @NotNull Function1<? super MotionEvent, MotionEvent> copyEvent, @NotNull ViewAttributesProvider[] targetAttributesProviders) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)wrappedCallback, (String)"wrappedCallback");
        Intrinsics.checkNotNullParameter((Object)gesturesDetector, (String)"gesturesDetector");
        Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
        Intrinsics.checkNotNullParameter(copyEvent, (String)"copyEvent");
        Intrinsics.checkNotNullParameter((Object)targetAttributesProviders, (String)"targetAttributesProviders");
        this.wrappedCallback = wrappedCallback;
        this.gesturesDetector = gesturesDetector;
        this.interactionPredicate = interactionPredicate;
        this.copyEvent = copyEvent;
        this.targetAttributesProviders = targetAttributesProviders;
        this.windowReference = new WeakReference<Window>(window);
    }

    public /* synthetic */ WindowCallbackWrapper(Window window, Window.Callback callback, GesturesDetectorWrapper gesturesDetectorWrapper, InteractionPredicate interactionPredicate, Function1 function1, ViewAttributesProvider[] viewAttributesProviderArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            interactionPredicate = new NoOpInteractionPredicate();
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            boolean $i$f$emptyArray = false;
            viewAttributesProviderArray = new ViewAttributesProvider[]{};
        }
        this(window, callback, gesturesDetectorWrapper, interactionPredicate, (Function1<? super MotionEvent, MotionEvent>)function1, viewAttributesProviderArray);
    }

    @NotNull
    public final Window.Callback getWrappedCallback() {
        return this.wrappedCallback;
    }

    @NotNull
    public final GesturesDetectorWrapper getGesturesDetector() {
        return this.gesturesDetector;
    }

    @NotNull
    public final InteractionPredicate getInteractionPredicate() {
        return this.interactionPredicate;
    }

    @NotNull
    public final Function1<MotionEvent, MotionEvent> getCopyEvent() {
        return this.copyEvent;
    }

    @NotNull
    public final ViewAttributesProvider[] getTargetAttributesProviders() {
        return this.targetAttributesProviders;
    }

    public boolean dispatchGenericMotionEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchGenericMotionEvent(p0);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent p0) {
        return this.wrappedCallback.dispatchKeyShortcutEvent(p0);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent p0) {
        return this.wrappedCallback.dispatchPopulateAccessibilityEvent(p0);
    }

    public boolean dispatchTrackballEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchTrackballEvent(p0);
    }

    public void onActionModeFinished(ActionMode p0) {
        this.wrappedCallback.onActionModeFinished(p0);
    }

    public void onActionModeStarted(ActionMode p0) {
        this.wrappedCallback.onActionModeStarted(p0);
    }

    public void onAttachedToWindow() {
        this.wrappedCallback.onAttachedToWindow();
    }

    public void onContentChanged() {
        this.wrappedCallback.onContentChanged();
    }

    public boolean onCreatePanelMenu(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onCreatePanelMenu(p0, p1);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public View onCreatePanelView(int p0) {
        return this.wrappedCallback.onCreatePanelView(p0);
    }

    public void onDetachedFromWindow() {
        this.wrappedCallback.onDetachedFromWindow();
    }

    public boolean onMenuOpened(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onMenuOpened(p0, p1);
    }

    public void onPanelClosed(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.wrappedCallback.onPanelClosed(p0, p1);
    }

    public boolean onPreparePanel(int p0, @Nullable @org.jetbrains.annotations.Nullable View p1, @NonNull @NotNull Menu p2) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return this.wrappedCallback.onPreparePanel(p0, p1, p2);
    }

    public boolean onSearchRequested() {
        return this.wrappedCallback.onSearchRequested();
    }

    public boolean onSearchRequested(SearchEvent p0) {
        return this.wrappedCallback.onSearchRequested(p0);
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams p0) {
        this.wrappedCallback.onWindowAttributesChanged(p0);
    }

    public void onWindowFocusChanged(boolean p0) {
        this.wrappedCallback.onWindowFocusChanged(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0) {
        return this.wrappedCallback.onWindowStartingActionMode(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0, int p1) {
        return this.wrappedCallback.onWindowStartingActionMode(p0, p1);
    }

    @NotNull
    public final WeakReference<Window> getWindowReference$dd_sdk_android_release() {
        return this.windowReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(@org.jetbrains.annotations.Nullable MotionEvent event) {
        boolean bl;
        InternalLogger.Target[] targetArray;
        if (event != null) {
            MotionEvent copy = (MotionEvent)this.copyEvent.invoke((Object)event);
            try {
                this.gesturesDetector.onTouchEvent(copy);
            }
            catch (Exception e) {
                targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Error processing MotionEvent", (Throwable)e);
            }
            finally {
                copy.recycle();
            }
        } else {
            InternalLogger.Target[] targetArray2 = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray2), "Received MotionEvent=null", null, 8, null);
        }
        try {
            bl = this.wrappedCallback.dispatchTouchEvent(event);
        }
        catch (Exception e) {
            targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Wrapped callback failed processing MotionEvent", (Throwable)e);
            bl = true;
        }
        return bl;
    }

    public boolean onMenuItemSelected(int featureId, @NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Window window = (Window)this.windowReference.get();
        String resourceId = GesturesUtilsKt.resourceIdName((Context)(window == null ? null : window.getContext()), item.getItemId());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)item.getClass().getCanonicalName()), TuplesKt.to((Object)"action.target.resource_id", (Object)resourceId), TuplesKt.to((Object)"action.target.title", (Object)item.getTitle())};
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        GlobalRum.get().addUserAction(RumActionType.TAP, GesturesUtilsKt.resolveTargetName(this.interactionPredicate, item), attributes);
        try {
            bl = this.wrappedCallback.onMenuItemSelected(featureId, item);
        }
        catch (Exception e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Wrapped callback failed processing MenuItem selection", (Throwable)e);
            bl = true;
        }
        return bl;
    }

    public boolean dispatchKeyEvent(@org.jetbrains.annotations.Nullable KeyEvent event) {
        boolean bl;
        if (event == null) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Received KeyEvent=null", null, 8, null);
        } else if (event.getKeyCode() == 4 && event.getAction() == 1) {
            this.handleBackEvent(event);
        } else if (event.getKeyCode() == 23 && event.getAction() == 1) {
            this.handleRemoteControlActionEvent();
        }
        try {
            bl = this.wrappedCallback.dispatchKeyEvent(event);
        }
        catch (Exception e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            RuntimeUtilsKt.getInternalLogger().log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), "Wrapped callback failed processing KeyEvent", (Throwable)e);
            bl = true;
        }
        return bl;
    }

    private final void handleRemoteControlActionEvent() {
        Window window;
        Window window2 = window = (Window)this.windowReference.get();
        if (window2 != null) {
            View view = window2.getCurrentFocus();
            if (view != null) {
                View it = view;
                boolean bl = false;
                String resourceIdName = GesturesUtilsKt.resourceIdName(window.getContext(), it.getId());
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action.target.classname", (Object)GesturesUtilsKt.targetClassName(it)), TuplesKt.to((Object)"action.target.resource_id", (Object)resourceIdName)};
                Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
                ViewAttributesProvider[] $this$forEach$iv = this.getTargetAttributesProviders();
                boolean $i$f$forEach = false;
                for (ViewAttributesProvider element$iv : $this$forEach$iv) {
                    ViewAttributesProvider provider = element$iv;
                    boolean bl2 = false;
                    provider.extractAttributes(it, attributes);
                }
                String targetName = GesturesUtilsKt.resolveTargetName(this.getInteractionPredicate(), it);
                GlobalRum.get().addUserAction(RumActionType.CLICK, targetName, attributes);
            }
        }
    }

    private final void handleBackEvent(KeyEvent event) {
        String customTargetName = this.interactionPredicate.getTargetName(event);
        CharSequence charSequence = customTargetName;
        String targetName = charSequence == null || charSequence.length() == 0 ? BACK_DEFAULT_TARGET_NAME : customTargetName;
        GlobalRum.get().addUserAction(RumActionType.BACK, targetName, MapsKt.emptyMap());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/WindowCallbackWrapper$Companion;", "", "()V", "BACK_DEFAULT_TARGET_NAME", "", "EVENT_CONSUMED", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

