/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.internal.AppStartTimeProvider;
import com.datadog.android.rum.internal.DefaultAppStartTimeProvider;
import com.datadog.android.rum.internal.anr.ANRException;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumViewChangedListener;
import com.datadog.android.rum.internal.domain.scope.RumViewInfo;
import com.datadog.android.rum.internal.domain.scope.RumViewScope;
import com.datadog.android.rum.internal.vitals.NoOpVitalMonitor;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 92\u00020\u0001:\u00019Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0002J\u001e\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0003J\b\u0010/\u001a\u000200H\u0016J\u001e\u00101\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0003J \u00102\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0017J\u001e\u00103\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0003J\b\u00104\u001a\u00020\u0006H\u0016J\b\u00105\u001a\u00020\u0006H\u0002J\u001e\u00106\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0003J\u0010\u00107\u001a\u00020+2\u0006\u0010(\u001a\u000208H\u0003R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewManagerScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "backgroundTrackingEnabled", "", "trackFrustrations", "viewChangedListener", "Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "appStartTimeProvider", "Lcom/datadog/android/rum/internal/AppStartTimeProvider;", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "applicationDisplayed", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Lcom/datadog/android/v2/api/SdkCore;ZZLcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/AppStartTimeProvider;Lcom/datadog/android/v2/core/internal/ContextProvider;Z)V", "getApplicationDisplayed$dd_sdk_android_release", "()Z", "setApplicationDisplayed$dd_sdk_android_release", "(Z)V", "childrenScopes", "", "getChildrenScopes$dd_sdk_android_release", "()Ljava/util/List;", "getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "stopped", "getStopped$dd_sdk_android_release", "setStopped$dd_sdk_android_release", "createAppLaunchViewScope", "Lcom/datadog/android/rum/internal/domain/scope/RumViewScope;", "time", "Lcom/datadog/android/rum/internal/domain/Time;", "createBackgroundViewScope", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "delegateToChildren", "", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "handleBackgroundEvent", "handleEvent", "handleOrphanEvent", "isActive", "isViewManagerComplete", "startApplicationLaunchView", "startForegroundView", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartView;", "Companion", "dd-sdk-android_release"})
public final class RumViewManagerScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final SdkCore sdkCore;
    private final boolean backgroundTrackingEnabled;
    private final boolean trackFrustrations;
    @Nullable
    private final RumViewChangedListener viewChangedListener;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver;
    @NotNull
    private final VitalMonitor cpuVitalMonitor;
    @NotNull
    private final VitalMonitor memoryVitalMonitor;
    @NotNull
    private final VitalMonitor frameRateVitalMonitor;
    @NotNull
    private final AppStartTimeProvider appStartTimeProvider;
    @NotNull
    private final ContextProvider contextProvider;
    private boolean applicationDisplayed;
    @NotNull
    private final List<RumScope> childrenScopes;
    private boolean stopped;
    @NotNull
    private static final Class<?>[] validBackgroundEventTypes;
    @NotNull
    private static final Class<?>[] silentOrphanEventTypes;
    @NotNull
    public static final String RUM_BACKGROUND_VIEW_URL = "com/datadog/background/view";
    @NotNull
    public static final String RUM_BACKGROUND_VIEW_NAME = "Background";
    @NotNull
    public static final String RUM_APP_LAUNCH_VIEW_URL = "com/datadog/application-launch/view";
    @NotNull
    public static final String RUM_APP_LAUNCH_VIEW_NAME = "ApplicationLaunch";
    @NotNull
    public static final String MESSAGE_MISSING_VIEW = "A RUM event was detected, but no view is active. To track views automatically, try calling the Configuration.Builder.useViewTrackingStrategy() method.\nYou can also track views manually using the RumMonitor.startView() and RumMonitor.stopView() methods.";

    public RumViewManagerScope(@NotNull RumScope parentScope, @NotNull SdkCore sdkCore, boolean backgroundTrackingEnabled, boolean trackFrustrations2, @Nullable RumViewChangedListener viewChangedListener, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull AppStartTimeProvider appStartTimeProvider, @NotNull ContextProvider contextProvider, boolean applicationDisplayed) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)appStartTimeProvider, (String)"appStartTimeProvider");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        this.parentScope = parentScope;
        this.sdkCore = sdkCore;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.trackFrustrations = trackFrustrations2;
        this.viewChangedListener = viewChangedListener;
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
        this.cpuVitalMonitor = cpuVitalMonitor;
        this.memoryVitalMonitor = memoryVitalMonitor;
        this.frameRateVitalMonitor = frameRateVitalMonitor;
        this.appStartTimeProvider = appStartTimeProvider;
        this.contextProvider = contextProvider;
        this.applicationDisplayed = applicationDisplayed;
        this.childrenScopes = new ArrayList();
    }

    public /* synthetic */ RumViewManagerScope(RumScope rumScope, SdkCore sdkCore, boolean bl, boolean bl2, RumViewChangedListener rumViewChangedListener, FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, VitalMonitor vitalMonitor, VitalMonitor vitalMonitor2, VitalMonitor vitalMonitor3, AppStartTimeProvider appStartTimeProvider, ContextProvider contextProvider, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            appStartTimeProvider = new DefaultAppStartTimeProvider(null, 1, null);
        }
        this(rumScope, sdkCore, bl, bl2, rumViewChangedListener, firstPartyHostHeaderTypeResolver, vitalMonitor, vitalMonitor2, vitalMonitor3, appStartTimeProvider, contextProvider, bl3);
    }

    @NotNull
    public final FirstPartyHostHeaderTypeResolver getFirstPartyHostHeaderTypeResolver$dd_sdk_android_release() {
        return this.firstPartyHostHeaderTypeResolver;
    }

    public final boolean getApplicationDisplayed$dd_sdk_android_release() {
        return this.applicationDisplayed;
    }

    public final void setApplicationDisplayed$dd_sdk_android_release(boolean bl) {
        this.applicationDisplayed = bl;
    }

    @NotNull
    public final List<RumScope> getChildrenScopes$dd_sdk_android_release() {
        return this.childrenScopes;
    }

    public final boolean getStopped$dd_sdk_android_release() {
        return this.stopped;
    }

    public final void setStopped$dd_sdk_android_release(boolean bl) {
        this.stopped = bl;
    }

    @Override
    @WorkerThread
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        boolean canDisplayApplication;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        boolean bl = canDisplayApplication = !this.stopped && !(event instanceof RumRawEvent.StopSession);
        if (!this.applicationDisplayed && canDisplayApplication) {
            boolean isForegroundProcess;
            boolean bl2 = isForegroundProcess = CoreFeature.Companion.getProcessImportance$dd_sdk_android_release() == 100;
            if (isForegroundProcess) {
                this.startApplicationLaunchView(event, writer);
            }
        }
        this.delegateToChildren(event, writer);
        if (event instanceof RumRawEvent.StartView && !this.stopped) {
            this.startForegroundView((RumRawEvent.StartView)event);
        } else if (event instanceof RumRawEvent.StopSession) {
            this.stopped = true;
        } else {
            int n;
            Iterable $this$count$iv = this.childrenScopes;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    RumScope it = (RumScope)element$iv;
                    boolean bl3 = false;
                    if (!it.isActive() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n == 0) {
                this.handleOrphanEvent(event, writer);
            }
        }
        return this.isViewManagerComplete() ? (RumScope)null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.parentScope.getRumContext();
    }

    @Override
    public boolean isActive() {
        return !this.stopped;
    }

    private final boolean isViewManagerComplete() {
        return this.stopped && this.childrenScopes.isEmpty();
    }

    @WorkerThread
    private final void startApplicationLaunchView(RumRawEvent event, DataWriter<Object> writer) {
        long processStartTime = this.appStartTimeProvider.getAppStartTimeNs();
        long timestampNs = TimeUnit.MILLISECONDS.toNanos(event.getEventTime().getTimestamp()) - event.getEventTime().getNanoTime() + processStartTime;
        Time applicationLaunchViewTime = new Time(TimeUnit.NANOSECONDS.toMillis(timestampNs), processStartTime);
        RumViewScope viewScope = this.createAppLaunchViewScope(applicationLaunchViewTime);
        long startupTime = event.getEventTime().getNanoTime() - processStartTime;
        this.applicationDisplayed = true;
        viewScope.handleEvent(new RumRawEvent.ApplicationStarted(applicationLaunchViewTime, startupTime), writer);
        this.childrenScopes.add(viewScope);
    }

    @WorkerThread
    private final void delegateToChildren(RumRawEvent event, DataWriter<Object> writer) {
        Iterator<RumScope> iterator = this.childrenScopes.iterator();
        while (iterator.hasNext()) {
            RumScope result = iterator.next().handleEvent(event, writer);
            if (result != null) continue;
            iterator.remove();
        }
    }

    @WorkerThread
    private final void handleOrphanEvent(RumRawEvent event, DataWriter<Object> writer) {
        int importanceForeground;
        boolean isForegroundProcess;
        int processFlag = CoreFeature.Companion.getProcessImportance$dd_sdk_android_release();
        boolean bl = isForegroundProcess = processFlag == (importanceForeground = 100);
        if (this.applicationDisplayed || !isForegroundProcess) {
            this.handleBackgroundEvent(event, writer);
        } else {
            boolean isSilentOrphanEvent = ArraysKt.contains((Object[])silentOrphanEventTypes, event.getClass());
            if (!isSilentOrphanEvent) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, MESSAGE_MISSING_VIEW, null, 8, null);
            }
        }
    }

    @WorkerThread
    private final void startForegroundView(RumRawEvent.StartView event) {
        RumViewScope viewScope = RumViewScope.Companion.fromEvent$dd_sdk_android_release(this, this.sdkCore, event, this.viewChangedListener, this.firstPartyHostHeaderTypeResolver, this.cpuVitalMonitor, this.memoryVitalMonitor, this.frameRateVitalMonitor, this.contextProvider, this.trackFrustrations);
        this.applicationDisplayed = true;
        this.childrenScopes.add(viewScope);
        RumViewChangedListener rumViewChangedListener = this.viewChangedListener;
        if (rumViewChangedListener != null) {
            rumViewChangedListener.onViewChanged(new RumViewInfo((Reference<Object>)new WeakReference<Object>(event.getKey()), event.getName(), event.getAttributes(), true));
        }
    }

    @WorkerThread
    private final void handleBackgroundEvent(RumRawEvent event, DataWriter<Object> writer) {
        if (event instanceof RumRawEvent.AddError && ((RumRawEvent.AddError)event).getThrowable() instanceof ANRException) {
            return;
        }
        boolean isValidBackgroundEvent = ArraysKt.contains((Object[])validBackgroundEventTypes, event.getClass());
        boolean isSilentOrphanEvent = ArraysKt.contains((Object[])silentOrphanEventTypes, event.getClass());
        if (isValidBackgroundEvent && this.backgroundTrackingEnabled) {
            RumViewScope viewScope = this.createBackgroundViewScope(event);
            viewScope.handleEvent(event, writer);
            this.childrenScopes.add(viewScope);
        } else if (!isSilentOrphanEvent) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, MESSAGE_MISSING_VIEW, null, 8, null);
        }
    }

    private final RumViewScope createBackgroundViewScope(RumRawEvent event) {
        SdkCore sdkCore = this.sdkCore;
        Time time = event.getEventTime();
        Map map = MapsKt.emptyMap();
        RumViewChangedListener rumViewChangedListener = this.viewChangedListener;
        FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver = this.firstPartyHostHeaderTypeResolver;
        NoOpVitalMonitor noOpVitalMonitor = new NoOpVitalMonitor();
        NoOpVitalMonitor noOpVitalMonitor2 = new NoOpVitalMonitor();
        NoOpVitalMonitor noOpVitalMonitor3 = new NoOpVitalMonitor();
        RumViewScope.RumViewType rumViewType = RumViewScope.RumViewType.BACKGROUND;
        ContextProvider contextProvider = this.contextProvider;
        boolean bl = this.trackFrustrations;
        return new RumViewScope(this, sdkCore, RUM_BACKGROUND_VIEW_URL, RUM_BACKGROUND_VIEW_NAME, time, map, rumViewChangedListener, firstPartyHostHeaderTypeResolver, noOpVitalMonitor, noOpVitalMonitor2, noOpVitalMonitor3, contextProvider, null, null, null, rumViewType, bl, 28672, null);
    }

    private final RumViewScope createAppLaunchViewScope(Time time) {
        SdkCore sdkCore = this.sdkCore;
        Map map = MapsKt.emptyMap();
        RumViewChangedListener rumViewChangedListener = this.viewChangedListener;
        FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver = this.firstPartyHostHeaderTypeResolver;
        NoOpVitalMonitor noOpVitalMonitor = new NoOpVitalMonitor();
        NoOpVitalMonitor noOpVitalMonitor2 = new NoOpVitalMonitor();
        NoOpVitalMonitor noOpVitalMonitor3 = new NoOpVitalMonitor();
        RumViewScope.RumViewType rumViewType = RumViewScope.RumViewType.APPLICATION_LAUNCH;
        ContextProvider contextProvider = this.contextProvider;
        boolean bl = this.trackFrustrations;
        return new RumViewScope(this, sdkCore, RUM_APP_LAUNCH_VIEW_URL, RUM_APP_LAUNCH_VIEW_NAME, time, map, rumViewChangedListener, firstPartyHostHeaderTypeResolver, noOpVitalMonitor, noOpVitalMonitor2, noOpVitalMonitor3, contextProvider, null, null, null, rumViewType, bl, 28672, null);
    }

    static {
        Class[] classArray = new Class[]{RumRawEvent.AddError.class, RumRawEvent.StartAction.class, RumRawEvent.StartResource.class};
        validBackgroundEventTypes = classArray;
        classArray = new Class[]{RumRawEvent.ApplicationStarted.class, RumRawEvent.KeepAlive.class, RumRawEvent.ResetSession.class, RumRawEvent.StopView.class, RumRawEvent.ActionDropped.class, RumRawEvent.ActionSent.class, RumRawEvent.ErrorDropped.class, RumRawEvent.ErrorSent.class, RumRawEvent.LongTaskDropped.class, RumRawEvent.LongTaskSent.class, RumRawEvent.ResourceDropped.class, RumRawEvent.ResourceSent.class};
        silentOrphanEventTypes = classArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR \u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewManagerScope$Companion;", "", "()V", "MESSAGE_MISSING_VIEW", "", "RUM_APP_LAUNCH_VIEW_NAME", "RUM_APP_LAUNCH_VIEW_URL", "RUM_BACKGROUND_VIEW_NAME", "RUM_BACKGROUND_VIEW_URL", "silentOrphanEventTypes", "", "Ljava/lang/Class;", "getSilentOrphanEventTypes$dd_sdk_android_release", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "validBackgroundEventTypes", "getValidBackgroundEventTypes$dd_sdk_android_release", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Class<?>[] getValidBackgroundEventTypes$dd_sdk_android_release() {
            return validBackgroundEventTypes;
        }

        @NotNull
        public final Class<?>[] getSilentOrphanEventTypes$dd_sdk_android_release() {
            return silentOrphanEventTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

