/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumSessionScope;
import com.datadog.android.rum.internal.domain.scope.RumViewChangedListener;
import com.datadog.android.rum.internal.domain.scope.RumViewInfo;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u0000\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B_\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0003J\b\u0010.\u001a\u00020#H\u0016J\u001e\u0010/\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0017J\b\u00100\u001a\u00020\nH\u0016J\u0010\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020!H\u0016J\u001e\u00103\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0003R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001b\u00a8\u00065"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumApplicationScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;", "applicationId", "", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "samplingRate", "", "backgroundTrackingEnabled", "", "trackFrustrations", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "sessionListener", "Lcom/datadog/android/rum/RumSessionListener;", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "(Ljava/lang/String;Lcom/datadog/android/v2/api/SdkCore;FZZLcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/RumSessionListener;Lcom/datadog/android/v2/core/internal/ContextProvider;)V", "activeSession", "getActiveSession", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "getBackgroundTrackingEnabled$dd_sdk_android_release", "()Z", "childScopes", "", "getChildScopes$dd_sdk_android_release", "()Ljava/util/List;", "lastActiveViewInfo", "Lcom/datadog/android/rum/internal/domain/scope/RumViewInfo;", "rumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "getSamplingRate$dd_sdk_android_release", "()F", "getTrackFrustrations$dd_sdk_android_release", "delegateToChildren", "", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "", "getRumContext", "handleEvent", "isActive", "onViewChanged", "viewInfo", "startNewSession", "Companion", "dd-sdk-android_release"})
public final class RumApplicationScope
implements RumScope,
RumViewChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    private final float samplingRate;
    private final boolean backgroundTrackingEnabled;
    private final boolean trackFrustrations;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver;
    @NotNull
    private final VitalMonitor cpuVitalMonitor;
    @NotNull
    private final VitalMonitor memoryVitalMonitor;
    @NotNull
    private final VitalMonitor frameRateVitalMonitor;
    @Nullable
    private final RumSessionListener sessionListener;
    @NotNull
    private final ContextProvider contextProvider;
    @NotNull
    private final RumContext rumContext;
    @NotNull
    private final List<RumScope> childScopes;
    @Nullable
    private RumViewInfo lastActiveViewInfo;
    @NotNull
    public static final String LAST_ACTIVE_VIEW_GONE_WARNING_MESSAGE = "Attempting to start a new session on the last known view (%s) failed because that view has been disposed. ";
    @NotNull
    public static final String MULTIPLE_ACTIVE_SESSIONS_ERROR = "Application has multiple active sessions when starting a new session";

    public RumApplicationScope(@NotNull String applicationId, @NotNull SdkCore sdkCore, float samplingRate, boolean backgroundTrackingEnabled, boolean trackFrustrations2, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @Nullable RumSessionListener sessionListener, @NotNull ContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        this.sdkCore = sdkCore;
        this.samplingRate = samplingRate;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.trackFrustrations = trackFrustrations2;
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
        this.cpuVitalMonitor = cpuVitalMonitor;
        this.memoryVitalMonitor = memoryVitalMonitor;
        this.frameRateVitalMonitor = frameRateVitalMonitor;
        this.sessionListener = sessionListener;
        this.contextProvider = contextProvider;
        this.rumContext = new RumContext(applicationId, null, false, null, null, null, null, null, null, 510, null);
        Object[] objectArray = new RumScope[]{new RumSessionScope(this, this.sdkCore, this.samplingRate, this.backgroundTrackingEnabled, this.trackFrustrations, this, this.firstPartyHostHeaderTypeResolver, this.cpuVitalMonitor, this.memoryVitalMonitor, this.frameRateVitalMonitor, this.sessionListener, this.contextProvider, false, null, 0L, 0L, 57344, null)};
        this.childScopes = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final float getSamplingRate$dd_sdk_android_release() {
        return this.samplingRate;
    }

    public final boolean getBackgroundTrackingEnabled$dd_sdk_android_release() {
        return this.backgroundTrackingEnabled;
    }

    public final boolean getTrackFrustrations$dd_sdk_android_release() {
        return this.trackFrustrations;
    }

    @NotNull
    public final List<RumScope> getChildScopes$dd_sdk_android_release() {
        return this.childScopes;
    }

    @Nullable
    public final RumScope getActiveSession() {
        Object v0;
        block1: {
            for (Object t : (Iterable)this.childScopes) {
                RumScope it = (RumScope)t;
                boolean bl = false;
                if (!it.isActive()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @WorkerThread
    @NotNull
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        boolean isInteraction;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        boolean bl = isInteraction = event instanceof RumRawEvent.StartView || event instanceof RumRawEvent.StartAction;
        if (this.getActiveSession() == null && isInteraction) {
            this.startNewSession(event, writer);
        } else if (event instanceof RumRawEvent.StopSession) {
            this.sdkCore.updateFeatureContext("rum", (Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(this){
                final /* synthetic */ RumApplicationScope this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.putAll(this.this$0.getRumContext().toMap());
                }
            }));
        }
        this.delegateToChildren(event, writer);
        return this;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.rumContext;
    }

    @Override
    public void onViewChanged(@NotNull RumViewInfo viewInfo) {
        Intrinsics.checkNotNullParameter((Object)viewInfo, (String)"viewInfo");
        if (viewInfo.isActive()) {
            this.lastActiveViewInfo = viewInfo;
        }
    }

    @WorkerThread
    private final void delegateToChildren(RumRawEvent event, DataWriter<Object> writer) {
        Iterator<RumScope> iterator = this.childScopes.iterator();
        while (iterator.hasNext()) {
            RumScope result = iterator.next().handleEvent(event, writer);
            if (result != null) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final void startNewSession(RumRawEvent event, DataWriter<Object> writer) {
        void $this$filterTo$iv$iv;
        Object it;
        RumSessionScope newSession = new RumSessionScope(this, this.sdkCore, this.samplingRate, this.backgroundTrackingEnabled, this.trackFrustrations, this, this.firstPartyHostHeaderTypeResolver, this.cpuVitalMonitor, this.memoryVitalMonitor, this.frameRateVitalMonitor, this.sessionListener, this.contextProvider, true, null, 0L, 0L, 57344, null);
        this.childScopes.add(newSession);
        if (!(event instanceof RumRawEvent.StartView)) {
            RumViewInfo rumViewInfo = this.lastActiveViewInfo;
            if (rumViewInfo != null) {
                it = rumViewInfo;
                boolean bl = false;
                Object key = ((RumViewInfo)it).getKeyRef().get();
                if (key != null) {
                    RumRawEvent.StartView startViewEvent = new RumRawEvent.StartView(key, ((RumViewInfo)it).getName(), ((RumViewInfo)it).getAttributes(), null, 8, null);
                    newSession.handleEvent(startViewEvent, writer);
                } else {
                    InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                    String string = LAST_ACTIVE_VIEW_GONE_WARNING_MESSAGE;
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{((RumViewInfo)it).getName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
                }
            }
        }
        Iterable $this$filter$iv = this.childScopes;
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RumScope it2 = (RumScope)element$iv$iv;
            boolean bl = false;
            if (!it2.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (((List)destination$iv$iv).size() > 1) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.TELEMETRY, MULTIPLE_ACTIVE_SESSIONS_ERROR, null, 8, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumApplicationScope$Companion;", "", "()V", "LAST_ACTIVE_VIEW_GONE_WARNING_MESSAGE", "", "MULTIPLE_ACTIVE_SESSIONS_ERROR", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

