/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.ViewUpdatePredicate;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/DefaultViewUpdatePredicate;", "Lcom/datadog/android/rum/internal/domain/scope/ViewUpdatePredicate;", "viewUpdateThreshold", "", "(J)V", "lastViewUpdateTimestamp", "canUpdateView", "", "isViewComplete", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "Companion", "dd-sdk-android_release"})
public final class DefaultViewUpdatePredicate
implements ViewUpdatePredicate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long viewUpdateThreshold;
    private long lastViewUpdateTimestamp;
    private static final long VIEW_UPDATE_THRESHOLD_IN_NS = TimeUnit.SECONDS.toNanos(30L);

    public DefaultViewUpdatePredicate(long viewUpdateThreshold) {
        this.viewUpdateThreshold = viewUpdateThreshold;
        this.lastViewUpdateTimestamp = System.nanoTime() - VIEW_UPDATE_THRESHOLD_IN_NS;
    }

    public /* synthetic */ DefaultViewUpdatePredicate(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = VIEW_UPDATE_THRESHOLD_IN_NS;
        }
        this(l);
    }

    @Override
    public boolean canUpdateView(boolean isViewComplete, @NotNull RumRawEvent event) {
        boolean isThresholdReached;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean isFatalError = event instanceof RumRawEvent.AddError && ((RumRawEvent.AddError)event).isFatal();
        boolean bl = isThresholdReached = System.nanoTime() - this.lastViewUpdateTimestamp > this.viewUpdateThreshold;
        if (isViewComplete || isFatalError || isThresholdReached) {
            this.lastViewUpdateTimestamp = System.nanoTime();
            return true;
        }
        return false;
    }

    public DefaultViewUpdatePredicate() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/DefaultViewUpdatePredicate$Companion;", "", "()V", "VIEW_UPDATE_THRESHOLD_IN_NS", "", "getVIEW_UPDATE_THRESHOLD_IN_NS$dd_sdk_android_release", "()J", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getVIEW_UPDATE_THRESHOLD_IN_NS$dd_sdk_android_release() {
            return VIEW_UPDATE_THRESHOLD_IN_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

