/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.Serializer;
import com.datadog.android.core.internal.persistence.SerializerKt;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileWriter;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.StorageEvent;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.core.internal.storage.DataWriter;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001d\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0015H\u0003J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/rum/internal/domain/RumDataWriter;", "Lcom/datadog/android/v2/core/internal/storage/DataWriter;", "", "serializer", "Lcom/datadog/android/core/internal/persistence/Serializer;", "fileWriter", "Lcom/datadog/android/core/internal/persistence/file/FileWriter;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "lastViewEventFile", "Ljava/io/File;", "(Lcom/datadog/android/core/internal/persistence/Serializer;Lcom/datadog/android/core/internal/persistence/file/FileWriter;Lcom/datadog/android/v2/api/InternalLogger;Ljava/io/File;)V", "notifyEventSent", "", "viewId", "", "storageEvent", "Lcom/datadog/android/rum/internal/monitor/StorageEvent;", "onDataWritten", "data", "rawData", "", "onDataWritten$dd_sdk_android_release", "persistViewEvent", "write", "", "writer", "Lcom/datadog/android/v2/api/EventBatchWriter;", "element", "Companion", "dd-sdk-android_release"})
public final class RumDataWriter
implements DataWriter<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Serializer<Object> serializer;
    @NotNull
    private final FileWriter fileWriter;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final File lastViewEventFile;
    @NotNull
    public static final String LAST_VIEW_EVENT_DIR_MISSING_MESSAGE = "Directory structure %s for writing last view event doesn't exist.";

    public RumDataWriter(@NotNull Serializer<Object> serializer, @NotNull FileWriter fileWriter, @NotNull InternalLogger internalLogger, @NotNull File lastViewEventFile) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)fileWriter, (String)"fileWriter");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)lastViewEventFile, (String)"lastViewEventFile");
        this.serializer = serializer;
        this.fileWriter = fileWriter;
        this.internalLogger = internalLogger;
        this.lastViewEventFile = lastViewEventFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public boolean write(@NotNull EventBatchWriter writer, @NotNull Object element) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        byte[] byArray = SerializerKt.serializeToByteArray(this.serializer, element, this.internalLogger);
        if (byArray == null) {
            return false;
        }
        byte[] byteArray = byArray;
        synchronized (this) {
            boolean bl = false;
            boolean result = writer.write(byteArray, null);
            if (result) {
                this.onDataWritten$dd_sdk_android_release(element, byteArray);
            }
            boolean bl2 = result;
            return bl2;
        }
    }

    @WorkerThread
    public final void onDataWritten$dd_sdk_android_release(@NotNull Object data, @NotNull byte[] rawData) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Object object = data;
        if (object instanceof ViewEvent) {
            this.persistViewEvent(rawData);
        } else if (object instanceof ActionEvent) {
            int n;
            String string = ((ActionEvent)data).getView().getId();
            ActionEvent.Frustration frustration = ((ActionEvent)data).getAction().getFrustration();
            if (frustration == null) {
                n = 0;
            } else {
                int n2;
                List<ActionEvent.Type> list = frustration.getType();
                n = list == null ? 0 : (n2 = list.size());
            }
            this.notifyEventSent(string, new StorageEvent.Action(n));
        } else if (object instanceof ResourceEvent) {
            this.notifyEventSent(((ResourceEvent)data).getView().getId(), StorageEvent.Resource.INSTANCE);
        } else if (object instanceof ErrorEvent) {
            if (!Intrinsics.areEqual((Object)((ErrorEvent)data).getError().isCrash(), (Object)true)) {
                this.notifyEventSent(((ErrorEvent)data).getView().getId(), StorageEvent.Error.INSTANCE);
            }
        } else if (object instanceof LongTaskEvent) {
            if (Intrinsics.areEqual((Object)((LongTaskEvent)data).getLongTask().isFrozenFrame(), (Object)true)) {
                this.notifyEventSent(((LongTaskEvent)data).getView().getId(), StorageEvent.FrozenFrame.INSTANCE);
            } else {
                this.notifyEventSent(((LongTaskEvent)data).getView().getId(), StorageEvent.LongTask.INSTANCE);
            }
        }
    }

    @WorkerThread
    private final void persistViewEvent(byte[] data) {
        File file = this.lastViewEventFile.getParentFile();
        if (file == null ? false : FileExtKt.existsSafe(file)) {
            this.fileWriter.writeData(this.lastViewEventFile, data, false);
        } else {
            String string = LAST_VIEW_EVENT_DIR_MISSING_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{this.lastViewEventFile.getParent()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.MAINTAINER, string2, null, 8, null);
        }
    }

    private final void notifyEventSent(String viewId, StorageEvent storageEvent) {
        RumMonitor rumMonitor = GlobalRum.get();
        if (rumMonitor instanceof AdvancedRumMonitor) {
            ((AdvancedRumMonitor)rumMonitor).eventSent(viewId, storageEvent);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/internal/domain/RumDataWriter$Companion;", "", "()V", "LAST_VIEW_EVENT_DIR_MISSING_MESSAGE", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

