/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a2\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ERROR_TASK_REJECTED", "", "executeSafe", "", "Ljava/util/concurrent/Executor;", "operationName", "runnable", "Ljava/lang/Runnable;", "scheduleSafe", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/ScheduledExecutorService;", "delay", "", "unit", "Ljava/util/concurrent/TimeUnit;", "dd-sdk-android_release"})
public final class ConcurrencyExtKt {
    @NotNull
    public static final String ERROR_TASK_REJECTED = "Unable to schedule %s task on the executor";

    public static final void executeSafe(@NotNull Executor $this$executeSafe, @NotNull String operationName, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)$this$executeSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        try {
            $this$executeSafe.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_TASK_REJECTED;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{operationName};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
        }
    }

    @Nullable
    public static final ScheduledFuture<?> scheduleSafe(@NotNull ScheduledExecutorService $this$scheduleSafe, @NotNull String operationName, long delay, @NotNull TimeUnit unit, @NotNull Runnable runnable) {
        ScheduledFuture scheduledFuture;
        Intrinsics.checkNotNullParameter((Object)$this$scheduleSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        try {
            scheduledFuture = $this$scheduleSafe.schedule(runnable, delay, unit);
        }
        catch (RejectedExecutionException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_TASK_REJECTED;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{operationName};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }
}

