/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\b\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0004H\u0000\u001a.\u0010\f\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u0002H\u0000\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\nH\u0000\u00a8\u0006\u0014"}, d2={"copyTo", "", "", "srcPos", "", "dest", "destPos", "length", "indexOf", "b", "", "startIndex", "join", "", "separator", "prefix", "suffix", "split", "", "delimiter", "dd-sdk-android_release"})
public final class ByteArrayExtKt {
    @NotNull
    public static final List<byte[]> split(@NotNull byte[] $this$split, byte delimiter) {
        Intrinsics.checkNotNullParameter((Object)$this$split, (String)"<this>");
        List result = new ArrayList();
        int offset = 0;
        int nextIndex = 0;
        do {
            int length;
            int n = length = (nextIndex = ByteArrayExtKt.indexOf($this$split, delimiter, offset)) >= 0 ? nextIndex - offset : $this$split.length - offset;
            if (length > 0) {
                byte[] subArray = new byte[length];
                ByteArrayExtKt.copyTo($this$split, offset, subArray, 0, length);
                result.add(subArray);
            }
            offset = nextIndex + 1;
        } while (nextIndex != -1);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] join(@NotNull Collection<byte[]> $this$join, @NotNull byte[] separator, @NotNull byte[] prefix, @NotNull byte[] suffix) {
        Object object;
        Intrinsics.checkNotNullParameter($this$join, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Iterable iterable = $this$join;
        int n = 0;
        for (Object t : iterable) {
            void it;
            object = (byte[])t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((void)it).length;
            n = n2 + n3;
        }
        int dataSize = n;
        int separatorsSize = !$this$join.isEmpty() ? separator.length * ($this$join.size() - 1) : 0;
        int resultSize = prefix.length + dataSize + separatorsSize + suffix.length;
        byte[] result = new byte[resultSize];
        int offset = 0;
        ByteArrayExtKt.copyTo(prefix, 0, result, 0, prefix.length);
        offset += prefix.length;
        object = CollectionsKt.withIndex((Iterable)$this$join).iterator();
        while (object.hasNext()) {
            IndexedValue item = (IndexedValue)object.next();
            ByteArrayExtKt.copyTo((byte[])item.getValue(), 0, result, offset, ((byte[])item.getValue()).length);
            offset += ((byte[])item.getValue()).length;
            if (item.getIndex() == $this$join.size() - 1) continue;
            ByteArrayExtKt.copyTo(separator, 0, result, offset, separator.length);
            offset += separator.length;
        }
        ByteArrayExtKt.copyTo(suffix, 0, result, offset, suffix.length);
        return result;
    }

    public static /* synthetic */ byte[] join$default(Collection collection, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, Object object) {
        if ((n & 2) != 0) {
            byArray2 = new byte[]{};
        }
        if ((n & 4) != 0) {
            byArray3 = new byte[]{};
        }
        return ByteArrayExtKt.join(collection, byArray, byArray2, byArray3);
    }

    public static final int indexOf(@NotNull byte[] $this$indexOf, byte b, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        if (startIndex < 0) {
            return -1;
        }
        int n = startIndex;
        int n2 = $this$indexOf.length;
        while (n < n2) {
            int i;
            if ($this$indexOf[i = n++] != b) continue;
            return i;
        }
        return -1;
    }

    public static /* synthetic */ int indexOf$default(byte[] byArray, byte by, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return ByteArrayExtKt.indexOf(byArray, by, n);
    }

    public static final boolean copyTo(@NotNull byte[] $this$copyTo, int srcPos, @NotNull byte[] dest, int destPos, int length) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (destPos + length > dest.length) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, "Cannot copy ByteArray, dest doesn't have enough space", null, 8, null);
            bl = false;
        } else if (srcPos + length > $this$copyTo.length) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, "Cannot copy ByteArray, src doesn't have enough data", null, 8, null);
            bl = false;
        } else {
            System.arraycopy($this$copyTo, srcPos, dest, destPos, length);
            bl = true;
        }
        return bl;
    }
}

