/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.EventMeta;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.v2.api.InternalLogger;
import com.google.gson.JsonParseException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 )2\u00020\u0001:\u0003'()BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012#\b\u0002\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005\u0012#\b\u0002\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010#\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000fH\u0017J\u001c\u0010$\u001a\u00020%*\u00020%2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter;", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "metaGenerator", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "data", "metaParser", "metaBytes", "Lcom/datadog/android/core/internal/persistence/file/EventMeta;", "(Lcom/datadog/android/v2/api/InternalLogger;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "checkReadExpected", "", "expected", "", "actual", "operation", "", "lockFileAndWriteData", "", "file", "Ljava/io/File;", "append", "readBlock", "Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$BlockReadResult;", "stream", "Ljava/io/InputStream;", "expectedBlockType", "Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$BlockType;", "readData", "", "readFileData", "writeData", "putAsTlv", "Ljava/nio/ByteBuffer;", "blockType", "BlockReadResult", "BlockType", "Companion", "dd-sdk-android_release"})
public final class PlainBatchFileReaderWriter
implements BatchFileReaderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final Function1<byte[], byte[]> metaGenerator;
    @NotNull
    private final Function1<byte[], EventMeta> metaParser;
    public static final int TYPE_SIZE_BYTES = 2;
    public static final int LENGTH_SIZE_BYTES = 4;
    public static final int HEADER_SIZE_BYTES = 6;
    @NotNull
    public static final String ERROR_WRITE = "Unable to write data to file: %s";
    @NotNull
    public static final String ERROR_READ = "Unable to read data from file: %s";
    @NotNull
    public static final String ERROR_FAILED_META_PARSE = "Failed to parse meta bytes, stopping file read.";
    @NotNull
    public static final String WARNING_NOT_ALL_DATA_READ = "File %s is probably corrupted, not all content was read.";

    public PlainBatchFileReaderWriter(@NotNull InternalLogger internalLogger, @NotNull Function1<? super byte[], byte[]> metaGenerator, @NotNull Function1<? super byte[], EventMeta> metaParser) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter(metaGenerator, (String)"metaGenerator");
        Intrinsics.checkNotNullParameter(metaParser, (String)"metaParser");
        this.internalLogger = internalLogger;
        this.metaGenerator = metaGenerator;
        this.metaParser = metaParser;
    }

    public /* synthetic */ PlainBatchFileReaderWriter(InternalLogger internalLogger, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function12 = 2.INSTANCE;
        }
        this(internalLogger, (Function1<? super byte[], byte[]>)function1, (Function1<? super byte[], EventMeta>)function12);
    }

    @Override
    @WorkerThread
    public boolean writeData(@NotNull File file, @NotNull byte[] data, boolean append) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this.lockFileAndWriteData(file, append, data);
            bl = true;
        }
        catch (IOException e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_WRITE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            bl = false;
        }
        catch (SecurityException e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_WRITE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    @NotNull
    public List<byte[]> readData(@NotNull File file) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            list = this.readFileData(file);
        }
        catch (IOException e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list2 = CollectionsKt.listOf((Object[])object);
            object = ERROR_READ;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list2, string, (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        catch (SecurityException e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list3 = CollectionsKt.listOf((Object[])object);
            object = ERROR_READ;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            this.internalLogger.log(InternalLogger.Level.ERROR, list3, string, (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lockFileAndWriteData(File file, boolean append, byte[] data) throws IOException {
        Closeable closeable = new FileOutputStream(file, append);
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            FileLock fileLock = outputStream.getChannel().lock();
            Intrinsics.checkNotNullExpressionValue((Object)fileLock, (String)"outputStream.channel.lock()");
            FileLock $this$use$iv = fileLock;
            boolean $i$f$use = false;
            try {
                FileLock it = $this$use$iv;
                boolean bl2 = false;
                byte[] meta = (byte[])this.metaGenerator.invoke((Object)data);
                int metaBlockSize = 6 + meta.length;
                int dataBlockSize = 6 + data.length;
                ByteBuffer byteBuffer = ByteBuffer.allocate(metaBlockSize + dataBlockSize);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(metaBlockSize + dataBlockSize)");
                ByteBuffer buffer = this.putAsTlv(this.putAsTlv(byteBuffer, BlockType.META, meta), BlockType.EVENT, data);
                outputStream.write(buffer.array());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.release();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<byte[]> readFileData(File file) throws IOException {
        Object object;
        int inputLength = (int)FileExtKt.lengthSafe(file);
        List result = new ArrayList();
        int remaining = 0;
        Closeable closeable = new FileInputStream(file);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        InternalLogger.Target[] targetArray = null;
        try {
            BlockReadResult eventReadResult;
            BlockReadResult metaReadResult;
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl = false;
            for (remaining = inputLength; remaining > 0; remaining -= metaReadResult.getBytesRead() + eventReadResult.getBytesRead()) {
                EventMeta eventMeta;
                metaReadResult = this.readBlock(it, BlockType.META);
                if (metaReadResult.getData() == null) {
                    remaining -= metaReadResult.getBytesRead();
                    break;
                }
                eventReadResult = this.readBlock(it, BlockType.EVENT);
                if (eventReadResult.getData() == null) break;
                try {
                    eventMeta = (EventMeta)this.metaParser.invoke((Object)metaReadResult.getData());
                }
                catch (JsonParseException e) {
                    this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, ERROR_FAILED_META_PARSE, (Throwable)e);
                    continue;
                }
                EventMeta meta = eventMeta;
                result.add(eventReadResult.getData());
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            targetArray = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)targetArray);
        }
        if (remaining != 0 || inputLength > 0 && result.isEmpty()) {
            targetArray = WARNING_NOT_ALL_DATA_READ;
            object = Locale.US;
            Object[] objectArray = new Object[]{file.getPath()};
            String string = String.format((Locale)object, (String)targetArray, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            String message = string;
            targetArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), message, null, 8, null);
        }
        return result;
    }

    private final BlockReadResult readBlock(InputStream stream, BlockType expectedBlockType) throws IOException {
        byte[] dataBuffer;
        int dataReadBytes;
        ByteBuffer headerBuffer = ByteBuffer.allocate(6);
        int headerReadBytes = stream.read(headerBuffer.array());
        if (!this.checkReadExpected(6, headerReadBytes, "Block(" + expectedBlockType.name() + "): Header read")) {
            return new BlockReadResult(null, Math.max(0, headerReadBytes));
        }
        short blockType = headerBuffer.getShort();
        if (blockType != expectedBlockType.getIdentifier()) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Unexpected block type identifier=" + blockType + " met, was expecting " + expectedBlockType + "(" + expectedBlockType.getIdentifier() + ")", null, 8, null);
            return new BlockReadResult(null, headerReadBytes);
        }
        int dataSize = headerBuffer.getInt();
        return this.checkReadExpected(dataSize, dataReadBytes = stream.read(dataBuffer = new byte[dataSize]), "Block(" + expectedBlockType.name() + "):Data read") ? new BlockReadResult(dataBuffer, headerReadBytes + dataReadBytes) : new BlockReadResult(null, headerReadBytes + Math.max(0, dataReadBytes));
    }

    private final boolean checkReadExpected(int expected, int actual, String operation) {
        boolean bl;
        if (expected != actual) {
            if (actual != -1) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Number of bytes read for operation='" + operation + "' doesn't match with expected: expected=" + expected + ", actual=" + actual, null, 8, null);
            } else {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Unexpected EOF at the operation=" + operation, null, 8, null);
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final ByteBuffer putAsTlv(ByteBuffer $this$putAsTlv, BlockType blockType, byte[] data) {
        ByteBuffer byteBuffer = $this$putAsTlv.putShort(blockType.getIdentifier()).putInt(data.length).put(data);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"this\n            .putSho\u2026e)\n            .put(data)");
        return byteBuffer;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$BlockReadResult;", "", "data", "", "bytesRead", "", "([BI)V", "getBytesRead", "()I", "getData", "()[B", "dd-sdk-android_release"})
    private static final class BlockReadResult {
        @Nullable
        private final byte[] data;
        private final int bytesRead;

        public BlockReadResult(@Nullable byte[] data, int bytesRead) {
            this.data = data;
            this.bytesRead = bytesRead;
        }

        @Nullable
        public final byte[] getData() {
            return this.data;
        }

        public final int getBytesRead() {
            return this.bytesRead;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$BlockType;", "", "identifier", "", "(Ljava/lang/String;IS)V", "getIdentifier", "()S", "EVENT", "META", "dd-sdk-android_release"})
    private static final class BlockType
    extends Enum<BlockType> {
        private final short identifier;
        public static final /* enum */ BlockType EVENT = new BlockType(0);
        public static final /* enum */ BlockType META = new BlockType(1);
        private static final /* synthetic */ BlockType[] $VALUES;

        private BlockType(short identifier) {
            this.identifier = identifier;
        }

        public final short getIdentifier() {
            return this.identifier;
        }

        public static BlockType[] values() {
            return (BlockType[])$VALUES.clone();
        }

        public static BlockType valueOf(String value) {
            return Enum.valueOf(BlockType.class, value);
        }

        static {
            $VALUES = blockTypeArray = new BlockType[]{BlockType.EVENT, BlockType.META};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$Companion;", "", "()V", "ERROR_FAILED_META_PARSE", "", "ERROR_READ", "ERROR_WRITE", "HEADER_SIZE_BYTES", "", "LENGTH_SIZE_BYTES", "TYPE_SIZE_BYTES", "WARNING_NOT_ALL_DATA_READ", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

