/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import androidx.annotation.WorkerThread;
import androidx.collection.LruCache;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.v2.api.InternalLogger;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u000b\b\u0000\u0018\u0000 12\u00020\u0001:\u000201B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020\rH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0017J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0017J\u0012\u0010$\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0017J\u0018\u0010%\u001a\u0004\u0018\u00010\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0017J\n\u0010(\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u0003H\u0017J\u0012\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010+\u001a\u00020\u001bH\u0017J\u0018\u0010,\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0011H\u0002J\b\u0010.\u001a\u00020\u001bH\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00062"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator;", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "rootDir", "Ljava/io/File;", "config", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "(Ljava/io/File;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;Lcom/datadog/android/v2/api/InternalLogger;)V", "fileFilter", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$BatchFileFilter;", "knownBatchFiles", "Landroidx/collection/LruCache;", "", "getKnownBatchFiles$annotations", "()V", "lastCleanupTimestamp", "", "previousFile", "previousFileItemCount", "", "recentReadDelayMs", "recentWriteDelayMs", "metadata", "getMetadata", "(Ljava/io/File;)Ljava/io/File;", "canDoCleanup", "", "createNewFile", "deleteFile", "file", "deleteObsoleteFiles", "freeSpaceIfNeeded", "getAllFiles", "", "getFlushableFiles", "getMetadataFile", "getReadableFile", "excludeFiles", "", "getReusableWritableFile", "getRootDir", "getWritableFile", "forceNewFile", "isFileRecent", "delayMs", "isRootDirValid", "listSortedBatchFiles", "BatchFileFilter", "Companion", "dd-sdk-android_release"})
public final class BatchFileOrchestrator
implements FileOrchestrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDir;
    @NotNull
    private final FilePersistenceConfig config;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final BatchFileFilter fileFilter;
    private final long recentReadDelayMs;
    private final long recentWriteDelayMs;
    @Nullable
    private File previousFile;
    private int previousFileItemCount;
    @NotNull
    private final LruCache<File, Unit> knownBatchFiles;
    private long lastCleanupTimestamp;
    public static final double DECREASE_PERCENT = 0.95;
    public static final double INCREASE_PERCENT = 1.05;
    private static final int KNOWN_FILES_MAX_CACHE_SIZE = 400;
    @NotNull
    private static final Regex batchFileNameRegex = new Regex("\\d+");
    @NotNull
    public static final String ERROR_ROOT_NOT_WRITABLE = "The provided root dir is not writable: %s";
    @NotNull
    public static final String ERROR_ROOT_NOT_DIR = "The provided root file is not a directory: %s";
    @NotNull
    public static final String ERROR_CANT_CREATE_ROOT = "The provided root file can't be created: %s";
    @NotNull
    public static final String ERROR_DISK_FULL = "Too much disk space used (%d/%d): cleaning up to free %d bytes\u2026";
    @NotNull
    public static final String ERROR_NOT_BATCH_FILE = "The file provided is not a batch file: %s";
    @NotNull
    public static final String DEBUG_DIFFERENT_ROOT = "The file provided (%s) doesn't belong to the current folder (%s)";

    public BatchFileOrchestrator(@NotNull File rootDir, @NotNull FilePersistenceConfig config, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.rootDir = rootDir;
        this.config = config;
        this.internalLogger = internalLogger;
        this.fileFilter = new BatchFileFilter();
        this.recentReadDelayMs = MathKt.roundToLong((double)((double)this.config.getRecentDelayMs() * 1.05));
        this.recentWriteDelayMs = MathKt.roundToLong((double)((double)this.config.getRecentDelayMs() * 0.95));
        this.knownBatchFiles = new LruCache(400);
    }

    private static /* synthetic */ void getKnownBatchFiles$annotations() {
    }

    @Override
    @WorkerThread
    @Nullable
    public File getWritableFile(boolean forceNewFile) {
        File file;
        if (!this.isRootDirValid()) {
            return null;
        }
        if (this.canDoCleanup()) {
            this.deleteObsoleteFiles();
            this.freeSpaceIfNeeded();
            this.lastCleanupTimestamp = System.currentTimeMillis();
        }
        if (!forceNewFile) {
            file = this.getReusableWritableFile();
            if (file == null) {
                file = this.createNewFile();
            }
        } else {
            file = this.createNewFile();
        }
        return file;
    }

    @Override
    @WorkerThread
    @Nullable
    public File getReadableFile(@NotNull Set<? extends File> excludeFiles) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(excludeFiles, (String)"excludeFiles");
            if (!this.isRootDirValid()) {
                return null;
            }
            this.deleteObsoleteFiles();
            this.lastCleanupTimestamp = System.currentTimeMillis();
            List<File> files = this.listSortedBatchFiles();
            Iterable $this$firstOrNull$iv = files;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!(!excludeFiles.contains(it) && !this.isFileRecent(it, this.recentReadDelayMs))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @WorkerThread
    @NotNull
    public List<File> getAllFiles() {
        if (!this.isRootDirValid()) {
            return CollectionsKt.emptyList();
        }
        return this.listSortedBatchFiles();
    }

    @Override
    @WorkerThread
    @NotNull
    public List<File> getFlushableFiles() {
        return this.getAllFiles();
    }

    @Override
    @WorkerThread
    @Nullable
    public File getRootDir() {
        if (!this.isRootDirValid()) {
            return null;
        }
        return this.rootDir;
    }

    @Override
    @WorkerThread
    @Nullable
    public File getMetadataFile(@NotNull File file) {
        File file2;
        String string;
        Object[] objectArray;
        Locale locale;
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getParent(), (Object)this.rootDir.getPath())) {
            object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = DEBUG_DIFFERENT_ROOT;
            locale = Locale.US;
            objectArray = new Object[]{file.getPath(), this.rootDir.getPath()};
            string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.DEBUG, list, string, null, 8, null);
        }
        object = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.name");
        object = (CharSequence)object;
        if (batchFileNameRegex.matches((CharSequence)object)) {
            file2 = this.getMetadata(file);
        } else {
            object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_NOT_BATCH_FILE;
            locale = Locale.US;
            objectArray = new Object[]{file.getPath()};
            string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
            file2 = null;
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isRootDirValid() {
        if (FileExtKt.existsSafe(this.rootDir)) {
            if (this.rootDir.isDirectory()) {
                if (FileExtKt.canWriteSafe(this.rootDir)) {
                    return true;
                }
                Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                List list = CollectionsKt.listOf((Object[])object);
                object = ERROR_ROOT_NOT_WRITABLE;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{this.rootDir.getPath()};
                String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
                return false;
            }
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_ROOT_NOT_DIR;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{this.rootDir.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
            return false;
        }
        File file = this.rootDir;
        synchronized (file) {
            block9: {
                block8: {
                    boolean bl = false;
                    if (!FileExtKt.existsSafe(this.rootDir)) break block8;
                    boolean bl2 = true;
                    return bl2;
                }
                if (!FileExtKt.mkdirsSafe(this.rootDir)) break block9;
                boolean bl = true;
                return bl;
            }
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = ERROR_CANT_CREATE_ROOT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{this.rootDir.getPath()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
            boolean bl = false;
            return bl;
        }
    }

    private final File createNewFile() {
        File newFile;
        String newFileName = String.valueOf(System.currentTimeMillis());
        this.previousFile = newFile = new File(this.rootDir, newFileName);
        this.previousFileItemCount = 1;
        this.knownBatchFiles.put((Object)newFile, (Object)Unit.INSTANCE);
        return newFile;
    }

    private final File getReusableWritableFile() {
        File file;
        boolean hasSlotForMore;
        List<File> files = this.listSortedBatchFiles();
        File file2 = (File)CollectionsKt.lastOrNull(files);
        if (file2 == null) {
            return null;
        }
        File lastFile = file2;
        File lastKnownFile = this.previousFile;
        int lastKnownFileItemCount = this.previousFileItemCount;
        if (!Intrinsics.areEqual((Object)lastKnownFile, (Object)lastFile)) {
            return null;
        }
        boolean isRecentEnough = this.isFileRecent(lastFile, this.recentWriteDelayMs);
        boolean hasRoomForMore = FileExtKt.lengthSafe(lastFile) < this.config.getMaxBatchSize();
        boolean bl = hasSlotForMore = lastKnownFileItemCount < this.config.getMaxItemsPerBatch();
        if (isRecentEnough && hasRoomForMore && hasSlotForMore) {
            this.previousFileItemCount = lastKnownFileItemCount + 1;
            file = lastFile;
        } else {
            file = null;
        }
        return file;
    }

    private final boolean isFileRecent(File file, long delayMs) {
        long now = System.currentTimeMillis();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        Long l = StringsKt.toLongOrNull((String)string);
        long fileTimestamp = l == null ? 0L : l;
        return fileTimestamp >= now - delayMs;
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteObsoleteFiles() {
        void $this$forEach$iv;
        List<File> files = this.listSortedBatchFiles();
        long threshold = System.currentTimeMillis() - this.config.getOldFileThreshold();
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)((Function1)new Function1<File, Boolean>(threshold){
            final /* synthetic */ long $threshold;
            {
                this.$threshold = $threshold;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                Long l = StringsKt.toLongOrNull((String)string);
                return (l == null ? 0L : l) < this.$threshold;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            FileExtKt.deleteSafe(it);
            this.knownBatchFiles.remove((Object)it);
            if (!FileExtKt.existsSafe(this.getMetadata(it))) continue;
            FileExtKt.deleteSafe(this.getMetadata(it));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void freeSpaceIfNeeded() {
        Locale it;
        List<File> files = this.listSortedBatchFiles();
        Iterable iterable = files;
        long l = 0L;
        for (Object object : iterable) {
            File file = (File)object;
            long l2 = l;
            boolean bl = false;
            long l3 = FileExtKt.lengthSafe((File)((Object)it));
            l = l2 + l3;
        }
        long sizeOnDisk = l;
        long maxDiskSpace = this.config.getMaxDiskSpace();
        long sizeToFree = sizeOnDisk - maxDiskSpace;
        if (sizeToFree > 0L) {
            void $this$fold$iv;
            Object object;
            object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf(object);
            object = ERROR_DISK_FULL;
            it = Locale.US;
            Object[] bl = new Object[]{sizeOnDisk, maxDiskSpace, sizeToFree};
            String string = String.format(it, object, Arrays.copyOf(bl, bl.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
            object = files;
            long initial$iv = sizeToFree;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                long l4;
                File file = (File)element$iv;
                long remainingSizeToFree = accumulator$iv;
                boolean bl2 = false;
                if (remainingSizeToFree > 0L) {
                    void file2;
                    long deletedFileSize = this.deleteFile((File)file2);
                    long deletedMetaFileSize = this.deleteFile(this.getMetadata((File)file2));
                    l4 = remainingSizeToFree - deletedFileSize - deletedMetaFileSize;
                } else {
                    l4 = remainingSizeToFree;
                }
                accumulator$iv = l4;
            }
        }
    }

    private final long deleteFile(File file) {
        if (!FileExtKt.existsSafe(file)) {
            return 0L;
        }
        long size = FileExtKt.lengthSafe(file);
        this.knownBatchFiles.remove((Object)file);
        return FileExtKt.deleteSafe(file) ? size : 0L;
    }

    private final List<File> listSortedBatchFiles() {
        File[] fileArray;
        File[] $this$orEmpty$iv = FileExtKt.listFilesSafe(this.rootDir, this.fileFilter);
        boolean $i$f$orEmpty = false;
        File[] fileArray2 = $this$orEmpty$iv;
        if (fileArray2 == null) {
            boolean $i$f$emptyArray = false;
            fileArray = new File[]{};
        } else {
            fileArray = fileArray2;
        }
        return ArraysKt.sorted((Comparable[])fileArray);
    }

    private final File getMetadata(File $this$metadata) {
        return new File($this$metadata.getPath() + "_metadata");
    }

    private final boolean canDoCleanup() {
        return System.currentTimeMillis() - this.lastCleanupTimestamp > this.config.getCleanupFrequencyThreshold();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$BatchFileFilter;", "Ljava/io/FileFilter;", "(Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator;)V", "accept", "", "file", "Ljava/io/File;", "dd-sdk-android_release"})
    public final class BatchFileFilter
    implements FileFilter {
        public BatchFileFilter() {
            Intrinsics.checkNotNullParameter((Object)BatchFileOrchestrator.this, (String)"this$0");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean accept(@Nullable File file) {
            if (file == null) {
                return false;
            }
            if (BatchFileOrchestrator.this.knownBatchFiles.get((Object)file) != null) {
                return true;
            }
            if (!FileExtKt.isFileSafe(file)) return false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            CharSequence charSequence = string;
            if (!batchFileNameRegex.matches(charSequence)) return false;
            BatchFileOrchestrator.this.knownBatchFiles.put((Object)file, (Object)Unit.INSTANCE);
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$Companion;", "", "()V", "DEBUG_DIFFERENT_ROOT", "", "DECREASE_PERCENT", "", "ERROR_CANT_CREATE_ROOT", "ERROR_DISK_FULL", "ERROR_NOT_BATCH_FILE", "ERROR_ROOT_NOT_DIR", "ERROR_ROOT_NOT_WRITABLE", "INCREASE_PERCENT", "KNOWN_FILES_MAX_CACHE_SIZE", "", "batchFileNameRegex", "Lkotlin/text/Regex;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

