/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.advanced;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrator;
import com.datadog.android.core.internal.persistence.file.advanced.MoveDataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.NoOpDataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.WipeDataMigrationOperation;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.v2.api.InternalLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000eH\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/ConsentAwareFileMigrator;", "Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrator;", "Lcom/datadog/android/privacy/TrackingConsent;", "fileMover", "Lcom/datadog/android/core/internal/persistence/file/FileMover;", "executorService", "Ljava/util/concurrent/ExecutorService;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "(Lcom/datadog/android/core/internal/persistence/file/FileMover;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/v2/api/InternalLogger;)V", "migrateData", "", "previousState", "previousFileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "newState", "newFileOrchestrator", "dd-sdk-android_release"})
public final class ConsentAwareFileMigrator
implements DataMigrator<TrackingConsent> {
    @NotNull
    private final FileMover fileMover;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final InternalLogger internalLogger;

    public ConsentAwareFileMigrator(@NotNull FileMover fileMover, @NotNull ExecutorService executorService, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)fileMover, (String)"fileMover");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.fileMover = fileMover;
        this.executorService = executorService;
        this.internalLogger = internalLogger;
    }

    @Override
    @WorkerThread
    public void migrateData(@Nullable TrackingConsent previousState, @NotNull FileOrchestrator previousFileOrchestrator, @NotNull TrackingConsent newState, @NotNull FileOrchestrator newFileOrchestrator) {
        DataMigrationOperation dataMigrationOperation;
        Intrinsics.checkNotNullParameter((Object)previousFileOrchestrator, (String)"previousFileOrchestrator");
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        Intrinsics.checkNotNullParameter((Object)newFileOrchestrator, (String)"newFileOrchestrator");
        Pair pair = TuplesKt.to((Object)((Object)previousState), (Object)((Object)newState));
        if (((Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.NOT_GRANTED)))) {
            dataMigrationOperation = new WipeDataMigrationOperation(previousFileOrchestrator.getRootDir(), this.fileMover, this.internalLogger);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.PENDING)))) {
            dataMigrationOperation = new WipeDataMigrationOperation(newFileOrchestrator.getRootDir(), this.fileMover, this.internalLogger);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.GRANTED)))) {
            dataMigrationOperation = new MoveDataMigrationOperation(previousFileOrchestrator.getRootDir(), newFileOrchestrator.getRootDir(), this.fileMover, this.internalLogger);
        } else if ((((Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.GRANTED)))) {
            dataMigrationOperation = new NoOpDataMigrationOperation();
        } else {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, CollectionsKt.listOf((Object[])targetArray), "Unexpected consent migration from " + previousState + " to " + newState, null, 8, null);
            dataMigrationOperation = new NoOpDataMigrationOperation();
        }
        DataMigrationOperation operation = dataMigrationOperation;
        try {
            this.executorService.submit(operation);
        }
        catch (RejectedExecutionException e) {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, "Unable to schedule migration on the executor", (Throwable)e);
        }
    }
}

