/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence;

import com.datadog.android.core.internal.persistence.Serializer;
import com.datadog.android.v2.api.InternalLogger;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a3\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"serializeToByteArray", "", "T", "", "Lcom/datadog/android/core/internal/persistence/Serializer;", "model", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "(Lcom/datadog/android/core/internal/persistence/Serializer;Ljava/lang/Object;Lcom/datadog/android/v2/api/InternalLogger;)[B", "dd-sdk-android_release"})
public final class SerializerKt {
    @Nullable
    public static final <T> byte[] serializeToByteArray(@NotNull Serializer<T> $this$serializeToByteArray, @NotNull T model, @NotNull InternalLogger internalLogger) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$serializeToByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            byte[] byArray2;
            String serialized;
            String string = serialized = $this$serializeToByteArray.serialize(model);
            if (string == null) {
                byArray2 = null;
            } else {
                byte[] byArray3 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
                byArray2 = byArray3;
            }
            byArray = byArray2;
        }
        catch (Throwable e) {
            Object object = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = "Error serializing %s model";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{model.getClass().getSimpleName()};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, list, string, e);
            byArray = null;
        }
        return byArray;
    }
}

