/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.constraints;

import com.datadog.android.core.internal.constraints.DataConstraints;
import com.datadog.android.core.internal.constraints.DatadogDataConstraints;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u001a\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\fH\u0002JP\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00170\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cH\u0016J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004H\u0016J(\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020 0\u00162\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020 0\u0019H\u0016R,\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005j\u0002`\u00070\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006#"}, d2={"Lcom/datadog/android/core/internal/constraints/DatadogDataConstraints;", "Lcom/datadog/android/core/internal/constraints/DataConstraints;", "()V", "tagTransforms", "", "Lkotlin/Function1;", "", "Lcom/datadog/android/core/internal/constraints/StringTransform;", "getTagTransforms$annotations", "convertAttributeKey", "rawKey", "prefixDotCount", "", "convertTag", "rawTag", "isKeyReserved", "", "tag", "resolveDiscardedAttrsWarning", "attributesGroupName", "discardedCount", "validateAttributes", "", "T", "attributes", "", "keyPrefix", "reservedKeys", "", "validateTags", "tags", "validateTimings", "", "timings", "Companion", "dd-sdk-android_release"})
public final class DatadogDataConstraints
implements DataConstraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Function1<String, String>> tagTransforms;
    private static final int MAX_TAG_LENGTH = 200;
    private static final int MAX_TAG_COUNT = 100;
    private static final int MAX_ATTR_COUNT = 128;
    private static final int MAX_DEPTH_LEVEL = 9;
    @NotNull
    public static final String CUSTOM_TIMING_KEY_REPLACED_WARNING = "Invalid timing name: %s, sanitized to: %s";
    @NotNull
    private static final Set<String> reservedTagKeys;

    public DatadogDataConstraints() {
        Object[] objectArray = new Function1[]{tagTransforms.1.INSTANCE, tagTransforms.2.INSTANCE, tagTransforms.3.INSTANCE, tagTransforms.4.INSTANCE, tagTransforms.5.INSTANCE, (Function1)new Function1<String, String>(this){
            final /* synthetic */ DatadogDataConstraints this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DatadogDataConstraints.access$isKeyReserved(this.this$0, it) ? null : it;
            }
        }};
        this.tagTransforms = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> validateTags(@NotNull List<String> tags) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Iterable $this$mapNotNull$iv = tags;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String tag = this.convertTag(it);
            if (tag == null) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, "\"" + it + "\" is an invalid tag, and was ignored.", null, 8, null);
            } else if (!Intrinsics.areEqual((Object)tag, (Object)it)) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, "tag \"" + it + "\" was modified to \"" + tag + "\" to match our constraints.", null, 8, null);
            }
            if (tag == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedTags = (List)destination$iv$iv;
        int discardedCount = convertedTags.size() - 100;
        if (discardedCount > 0) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, "too many tags were added, " + discardedCount + " had to be discarded.", null, 8, null);
        }
        return CollectionsKt.take((Iterable)convertedTags, (int)100);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> Map<String, T> validateAttributes(@NotNull Map<String, ? extends T> attributes, @Nullable String keyPrefix, @Nullable String attributesGroupName, @NotNull Set<String> reservedKeys) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Object it;
        int n;
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(reservedKeys, (String)"reservedKeys");
        String string = keyPrefix;
        if (string == null) {
            n = 0;
        } else {
            int n2;
            it = string;
            boolean bl = false;
            CharSequence $this$count$iv = (CharSequence)it;
            boolean $i$f$count = false;
            int count$iv = 0;
            object = $this$count$iv;
            for (int i = 0; i < object.length(); ++i) {
                char element$iv = object.charAt(i);
                char character = element$iv;
                boolean bl2 = false;
                if (!(character == '.')) continue;
                ++count$iv;
            }
            n = n2 = count$iv + 1;
        }
        int prefixDotCount = n;
        Map<String, ? extends T> $this$mapNotNull$iv = attributes;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)object.next();
            boolean bl = false;
            Map.Entry it2 = element$iv$iv;
            boolean bl3 = false;
            if (it2.getKey() == null) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, "\"" + it2 + "\" is an invalid attribute, and was ignored.", null, 8, null);
                pair = null;
            } else if (reservedKeys.contains(it2.getKey())) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, "\"" + it2 + "\" key was in the reservedKeys set, and was dropped.", null, 8, null);
                pair = null;
            } else {
                String key = this.convertAttributeKey((String)it2.getKey(), prefixDotCount);
                if (!Intrinsics.areEqual((Object)key, it2.getKey())) {
                    InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, "Key \"" + it2.getKey() + "\" was modified to \"" + key + "\" to match our constraints.", null, 8, null);
                }
                pair = TuplesKt.to((Object)key, it2.getValue());
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedAttributes = (List)destination$iv$iv;
        int discardedCount = convertedAttributes.size() - 128;
        if (discardedCount > 0) {
            String warningMessage = this.resolveDiscardedAttrsWarning(attributesGroupName, discardedCount);
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, warningMessage, null, 8, null);
        }
        return MapUtilsKt.toMutableMap(CollectionsKt.take((Iterable)convertedAttributes, (int)128));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Long> validateTimings(@NotNull Map<String, Long> timings) {
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkNotNullParameter(timings, (String)"timings");
        Map<String, Long> $this$mapKeys$iv = timings;
        boolean $i$f$mapKeys = false;
        Map<String, Long> map = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object[] objectArray;
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object object = new Regex("[^a-zA-Z0-9\\-_.@$]");
            CharSequence charSequence = (CharSequence)entry.getKey();
            String sanitizedKey = object.replace(charSequence, (String)(objectArray = "_"));
            if (!Intrinsics.areEqual((Object)sanitizedKey, entry.getKey())) {
                InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                charSequence = CUSTOM_TIMING_KEY_REPLACED_WARNING;
                object = Locale.US;
                objectArray = new Object[]{entry.getKey(), sanitizedKey};
                String string = String.format((Locale)object, (String)charSequence, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string, null, 8, null);
            }
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            String string = sanitizedKey;
            Map map3 = map2;
            boolean bl2 = false;
            entry2 = it$iv$iv.getValue();
            map3.put(string, entry2);
        }
        return MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    private final String resolveDiscardedAttrsWarning(String attributesGroupName, int discardedCount) {
        return attributesGroupName != null ? "Too many attributes were added for [" + attributesGroupName + "], " + discardedCount + " had to be discarded." : "Too many attributes were added, " + discardedCount + " had to be discarded.";
    }

    private static /* synthetic */ void getTagTransforms$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final String convertTag(String rawTag) {
        Iterable $this$fold$iv = this.tagTransforms;
        boolean $i$f$fold = false;
        String accumulator$iv = rawTag;
        for (Object element$iv : $this$fold$iv) {
            void transform;
            Function1 function1 = (Function1)element$iv;
            String tag = accumulator$iv;
            boolean bl = false;
            String string = tag;
            accumulator$iv = string == null ? null : (String)transform.invoke((Object)string);
        }
        return accumulator$iv;
    }

    private final boolean isKeyReserved(String tag) {
        boolean bl;
        int firstColon = StringsKt.indexOf$default((CharSequence)tag, (char)':', (int)0, (boolean)false, (int)6, null);
        if (firstColon > 0) {
            String string = tag;
            int n = 0;
            String string2 = string.substring(n, firstColon);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String key = string2;
            bl = reservedTagKeys.contains(key);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String convertAttributeKey(String rawKey, int prefixDotCount) {
        void $this$mapTo$iv$iv;
        int dotCount = 0;
        dotCount = prefixDotCount;
        CharSequence $this$map$iv = rawKey;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var10_9 = $this$mapTo$iv$iv;
        int n = 0;
        while (n < var10_9.length()) {
            int n2;
            void it;
            char item$iv$iv = var10_9.charAt(n);
            ++n;
            char c = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf((char)(it == 46 ? ((dotCount = (n2 = dotCount) + 1) > 9 ? 95 : it) : it)));
        }
        List mapped = (List)destination$iv$iv;
        return new String(CollectionsKt.toCharArray((Collection)mapped));
    }

    public static final /* synthetic */ boolean access$isKeyReserved(DatadogDataConstraints $this, String tag) {
        return $this.isKeyReserved(tag);
    }

    static {
        Object[] objectArray = new String[]{"host", "device", "source", "service"};
        reservedTagKeys = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/internal/constraints/DatadogDataConstraints$Companion;", "", "()V", "CUSTOM_TIMING_KEY_REPLACED_WARNING", "", "MAX_ATTR_COUNT", "", "MAX_DEPTH_LEVEL", "MAX_TAG_COUNT", "MAX_TAG_LENGTH", "reservedTagKeys", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

