/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing.internal.handlers;

import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.log.Logger;
import com.datadog.opentracing.DDSpan;
import com.datadog.opentracing.LogHandler;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\b2\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J7\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/tracing/internal/handlers/AndroidSpanLogsHandler;", "Lcom/datadog/opentracing/LogHandler;", "logger", "Lcom/datadog/android/log/Logger;", "(Lcom/datadog/android/log/Logger;)V", "getLogger", "()Lcom/datadog/android/log/Logger;", "extractError", "", "map", "", "", "span", "Lcom/datadog/opentracing/DDSpan;", "log", "timestampMicroseconds", "", "event", "fields", "", "logFields", "", "(Lcom/datadog/opentracing/DDSpan;Ljava/util/Map;Ljava/lang/Long;)V", "toMilliseconds", "(Ljava/lang/Long;)Ljava/lang/Long;", "Companion", "dd-sdk-android_release"})
public final class AndroidSpanLogsHandler
implements LogHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String DEFAULT_EVENT_MESSAGE = "Span event";

    public AndroidSpanLogsHandler(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    public void log(@NotNull String event, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"event", (Object)event)};
        this.logFields(span, MapsKt.mutableMapOf((Pair[])pairArray), null);
    }

    @Override
    public void log(long timestampMicroseconds, @NotNull String event, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"event", (Object)event)};
        this.logFields(span, MapsKt.mutableMapOf((Pair[])pairArray), timestampMicroseconds);
    }

    @Override
    public void log(@NotNull Map<String, ?> fields, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Map mutableMap = MapsKt.toMutableMap(fields);
        this.extractError(mutableMap, span);
        AndroidSpanLogsHandler.logFields$default(this, span, mutableMap, null, 4, null);
    }

    @Override
    public void log(long timestampMicroseconds, @NotNull Map<String, ?> fields, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Map mutableMap = MapsKt.toMutableMap(fields);
        this.extractError(mutableMap, span);
        this.logFields(span, mutableMap, timestampMicroseconds);
    }

    private final Long toMilliseconds(Long timestampMicroseconds) {
        Long l;
        Long l2 = timestampMicroseconds;
        if (l2 == null) {
            l = null;
        } else {
            Long l3 = l2;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l3).longValue();
            boolean bl3 = false;
            l = TimeUnit.MICROSECONDS.toMillis(it);
        }
        return l;
    }

    private final void logFields(DDSpan span, Map<String, Object> fields, Long timestampMicroseconds) {
        String string;
        Map<String, Object> map = fields.remove("message");
        String message = map == null ? DEFAULT_EVENT_MESSAGE : ((string = map.toString()) == null ? DEFAULT_EVENT_MESSAGE : string);
        map = fields;
        string = "dd.trace_id";
        String string2 = span.getTraceId().toString();
        boolean bl = false;
        map.put(string, string2);
        map = fields;
        string = "dd.span_id";
        string2 = span.getSpanId().toString();
        bl = false;
        map.put(string, string2);
        this.logger.internalLog$dd_sdk_android_release(2, message, null, fields, this.toMilliseconds(timestampMicroseconds));
    }

    static /* synthetic */ void logFields$default(AndroidSpanLogsHandler androidSpanLogsHandler, DDSpan dDSpan, Map map, Long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = null;
        }
        androidSpanLogsHandler.logFields(dDSpan, map, l);
    }

    private final void extractError(Map<String, ?> map, DDSpan span) {
        String errorType;
        Class<?> clazz;
        String string;
        Object obj = map.remove("error.object");
        Throwable throwable = obj instanceof Throwable ? (Throwable)obj : null;
        Object kind = map.remove("error.kind");
        Object object = kind;
        String string2 = string = object == null ? null : object.toString();
        Object object2 = string == null ? ((object = throwable) == null ? null : ((clazz = object.getClass()) == null ? null : clazz.getName())) : (errorType = string);
        if (errorType != null) {
            String string3;
            Object stackField = map.remove("stack");
            Object msgField = map.get("message");
            Object object3 = stackField;
            String string4 = string3 = object3 == null ? null : object3.toString();
            String stack = string3 == null ? ((object3 = throwable) == null ? null : ThrowableExtKt.loggableStackTrace(object3)) : string3;
            Object object4 = msgField;
            Object obj2 = object3 = object4 == null ? null : object4.toString();
            Object message = object3 == null ? ((object4 = throwable) == null ? null : ((Throwable)object4).getMessage()) : object3;
            span.setError(true);
            span.setTag("error.type", errorType);
            span.setTag("error.msg", (String)message);
            span.setTag("error.stack", stack);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/tracing/internal/handlers/AndroidSpanLogsHandler$Companion;", "", "()V", "DEFAULT_EVENT_MESSAGE", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

