/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing.internal.domain.event;

import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.Mapper;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.time.TimeProvider;
import com.datadog.android.core.internal.utils.BigIntegerExtKt;
import com.datadog.android.core.model.NetworkInfo;
import com.datadog.android.core.model.UserInfo;
import com.datadog.android.log.internal.user.UserInfoProvider;
import com.datadog.android.tracing.model.SpanEvent;
import com.datadog.opentracing.DDSpan;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/tracing/internal/domain/event/DdSpanToSpanEventMapper;", "Lcom/datadog/android/core/internal/Mapper;", "Lcom/datadog/opentracing/DDSpan;", "Lcom/datadog/android/tracing/model/SpanEvent;", "timeProvider", "Lcom/datadog/android/core/internal/time/TimeProvider;", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "userInfoProvider", "Lcom/datadog/android/log/internal/user/UserInfoProvider;", "(Lcom/datadog/android/core/internal/time/TimeProvider;Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Lcom/datadog/android/log/internal/user/UserInfoProvider;)V", "map", "model", "resolveMeta", "Lcom/datadog/android/tracing/model/SpanEvent$Meta;", "event", "resolveMetrics", "Lcom/datadog/android/tracing/model/SpanEvent$Metrics;", "resolveSimCarrier", "Lcom/datadog/android/tracing/model/SpanEvent$SimCarrier;", "networkInfo", "Lcom/datadog/android/core/model/NetworkInfo;", "dd-sdk-android_release"})
public final class DdSpanToSpanEventMapper
implements Mapper<DDSpan, SpanEvent> {
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final UserInfoProvider userInfoProvider;

    public DdSpanToSpanEventMapper(@NotNull TimeProvider timeProvider, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull UserInfoProvider userInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)userInfoProvider, (String)"userInfoProvider");
        this.timeProvider = timeProvider;
        this.networkInfoProvider = networkInfoProvider;
        this.userInfoProvider = userInfoProvider;
    }

    @Override
    @NotNull
    public SpanEvent map(@NotNull DDSpan model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        long serverOffset = this.timeProvider.getServerOffsetNanos();
        SpanEvent.Metrics metrics = this.resolveMetrics(model);
        SpanEvent.Meta metadata = this.resolveMeta(model);
        Object object = model.getTraceId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"model.traceId");
        String string = BigIntegerExtKt.toHexString((BigInteger)object);
        Object object2 = model.getSpanId();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"model.spanId");
        object = BigIntegerExtKt.toHexString((BigInteger)object2);
        Object object3 = model.getParentId();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"model.parentId");
        object2 = BigIntegerExtKt.toHexString((BigInteger)object3);
        object3 = model.getResourceName();
        String string2 = model.getOperationName();
        String string3 = model.getServiceName();
        long l = model.getDurationNano();
        long l2 = model.getStartTime() + serverOffset;
        Boolean bl = model.isError();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"model.isError");
        long l3 = bl != false ? 1L : 0L;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"resourceName");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"operationName");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"serviceName");
        return new SpanEvent(string, (String)object, (String)object2, (String)object3, string2, string3, l, l2, l3, metrics, metadata);
    }

    private final SpanEvent.Metrics resolveMetrics(DDSpan event) {
        Long l = event.getParentId().longValue() == 0L ? Long.valueOf(1L) : null;
        Map<String, Number> map = event.getMetrics();
        Intrinsics.checkNotNullExpressionValue(map, (String)"event.metrics");
        return new SpanEvent.Metrics(l, map);
    }

    private final SpanEvent.Meta resolveMeta(DDSpan event) {
        NetworkInfo networkInfo = this.networkInfoProvider.getLatestNetworkInfo();
        SpanEvent.SimCarrier simCarrier = this.resolveSimCarrier(networkInfo);
        Long l = networkInfo.getStrength();
        String string = l == null ? null : l.toString();
        l = networkInfo.getDownKbps();
        String string2 = l == null ? null : l.toString();
        l = networkInfo.getUpKbps();
        SpanEvent.Client networkInfoClient = new SpanEvent.Client(simCarrier, string, string2, l == null ? null : l.toString(), networkInfo.getConnectivity().toString());
        SpanEvent.Network networkInfoMeta = new SpanEvent.Network(networkInfoClient);
        UserInfo userInfo = this.userInfoProvider.getUserInfo();
        SpanEvent.Usr usrMeta = new SpanEvent.Usr(userInfo.getId(), userInfo.getName(), userInfo.getEmail(), userInfo.getAdditionalProperties());
        String string3 = CoreFeature.INSTANCE.getPackageVersion$dd_sdk_android_release();
        SpanEvent.Dd dd = new SpanEvent.Dd(null, 1, null);
        SpanEvent.Span span = new SpanEvent.Span();
        SpanEvent.Tracer tracer = new SpanEvent.Tracer(CoreFeature.INSTANCE.getSdkVersion$dd_sdk_android_release());
        Map<String, String> map = event.getMeta();
        Intrinsics.checkNotNullExpressionValue(map, (String)"event.meta");
        return new SpanEvent.Meta(string3, dd, span, tracer, usrMeta, networkInfoMeta, map);
    }

    private final SpanEvent.SimCarrier resolveSimCarrier(NetworkInfo networkInfo) {
        SpanEvent.SimCarrier simCarrier;
        if (networkInfo.getCarrierId() != null || networkInfo.getCarrierName() != null) {
            Long l = networkInfo.getCarrierId();
            String string = l == null ? null : l.toString();
            simCarrier = new SpanEvent.SimCarrier(string, networkInfo.getCarrierName());
        } else {
            simCarrier = null;
        }
        return simCarrier;
    }
}

