/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sqlite;

import android.database.DatabaseErrorHandler;
import android.database.DefaultDatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/sqlite/DatadogDatabaseErrorHandler;", "Landroid/database/DatabaseErrorHandler;", "defaultErrorHandler", "(Landroid/database/DatabaseErrorHandler;)V", "getDefaultErrorHandler$dd_sdk_android_release", "()Landroid/database/DatabaseErrorHandler;", "onCorruption", "", "dbObj", "Landroid/database/sqlite/SQLiteDatabase;", "Companion", "dd-sdk-android_release"})
public final class DatadogDatabaseErrorHandler
implements DatabaseErrorHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseErrorHandler defaultErrorHandler;
    @NotNull
    public static final String DATABASE_CORRUPTION_ERROR_MESSAGE = "Corruption reported by sqlite database: %s";

    public DatadogDatabaseErrorHandler(@NotNull DatabaseErrorHandler defaultErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)defaultErrorHandler, (String)"defaultErrorHandler");
        this.defaultErrorHandler = defaultErrorHandler;
    }

    public /* synthetic */ DatadogDatabaseErrorHandler(DatabaseErrorHandler databaseErrorHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            databaseErrorHandler = (DatabaseErrorHandler)new DefaultDatabaseErrorHandler();
        }
        this(databaseErrorHandler);
    }

    @NotNull
    public final DatabaseErrorHandler getDefaultErrorHandler$dd_sdk_android_release() {
        return this.defaultErrorHandler;
    }

    public void onCorruption(@NotNull SQLiteDatabase dbObj) {
        Intrinsics.checkNotNullParameter((Object)dbObj, (String)"dbObj");
        this.defaultErrorHandler.onCorruption(dbObj);
        RumMonitor rumMonitor = GlobalRum.get();
        Pair[] pairArray = StringCompanionObject.INSTANCE;
        Locale locale = Locale.US;
        String string = DATABASE_CORRUPTION_ERROR_MESSAGE;
        Object[] objectArray = new Object[]{dbObj.getPath()};
        boolean bl = false;
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        pairArray = new Pair[]{TuplesKt.to((Object)"error.database.path", (Object)dbObj.getPath()), TuplesKt.to((Object)"error.database.version", (Object)dbObj.getVersion())};
        rumMonitor.addError(string2, RumErrorSource.SOURCE, null, MapsKt.mapOf((Pair[])pairArray));
    }

    public DatadogDatabaseErrorHandler() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sqlite/DatadogDatabaseErrorHandler$Companion;", "", "()V", "DATABASE_CORRUPTION_ERROR_MESSAGE", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

