/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.webview;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.RequiresApi;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumResourceKind;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J&\u0010\t\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J*\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J&\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0017J.\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0016J&\u0010\u0018\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017J&\u0010\u001b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001eH\u0016\u00a8\u0006 "}, d2={"Lcom/datadog/android/rum/webview/RumWebViewClient;", "Landroid/webkit/WebViewClient;", "()V", "onPageFinished", "", "view", "Landroid/webkit/WebView;", "url", "", "onPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onProvideRumResourceAttributes", "", "", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "errorCode", "", "description", "failingUrl", "onReceivedHttpError", "errorResponse", "Landroid/webkit/WebResourceResponse;", "onReceivedSslError", "handler", "Landroid/webkit/SslErrorHandler;", "Landroid/net/http/SslError;", "Companion", "dd-sdk-android_release"})
public class RumWebViewClient
extends WebViewClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String METHOD_GET = "GET";

    public void onPageStarted(@Nullable WebView view, @Nullable String url, @Nullable Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        if (url != null) {
            String key = url;
            RumMonitor.DefaultImpls.startResource$default(GlobalRum.get(), key, METHOD_GET, url, null, 8, null);
        }
    }

    public void onPageFinished(@Nullable WebView view, @Nullable String url) {
        super.onPageFinished(view, url);
        if (url != null) {
            GlobalRum.get().stopResource(url, 200, null, RumResourceKind.DOCUMENT, this.onProvideRumResourceAttributes(view, url));
        }
    }

    public void onReceivedError(@Nullable WebView view, int errorCode, @Nullable String description, @Nullable String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        GlobalRum.get().addError("Error " + errorCode + ": " + description, RumErrorSource.WEBVIEW, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.resource.url", (Object)failingUrl)));
    }

    @RequiresApi(value=23)
    public void onReceivedError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
        super.onReceivedError(view, request, error);
        WebResourceError webResourceError = error;
        StringBuilder stringBuilder = new StringBuilder().append("Error ").append(webResourceError == null ? null : Integer.valueOf(webResourceError.getErrorCode())).append(": ");
        webResourceError = error;
        String string = stringBuilder.append((Object)(webResourceError == null ? null : webResourceError.getDescription())).toString();
        webResourceError = request;
        GlobalRum.get().addError(string, RumErrorSource.WEBVIEW, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.resource.url", (Object)(webResourceError == null ? null : webResourceError.getUrl()))));
    }

    @RequiresApi(value=21)
    public void onReceivedHttpError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceResponse errorResponse) {
        super.onReceivedHttpError(view, request, errorResponse);
        WebResourceResponse webResourceResponse = errorResponse;
        StringBuilder stringBuilder = new StringBuilder().append("Error ").append(webResourceResponse == null ? null : Integer.valueOf(webResourceResponse.getStatusCode())).append(": ");
        webResourceResponse = errorResponse;
        String string = stringBuilder.append((Object)(webResourceResponse == null ? null : webResourceResponse.getReasonPhrase())).toString();
        webResourceResponse = request;
        GlobalRum.get().addError(string, RumErrorSource.WEBVIEW, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.resource.url", (Object)(webResourceResponse == null ? null : webResourceResponse.getUrl()))));
    }

    public void onReceivedSslError(@Nullable WebView view, @Nullable SslErrorHandler handler, @Nullable SslError error) {
        super.onReceivedSslError(view, handler, error);
        SslError sslError = error;
        String string = Intrinsics.stringPlus((String)"SSL Error ", sslError == null ? null : Integer.valueOf(sslError.getPrimaryError()));
        sslError = error;
        GlobalRum.get().addError(string, RumErrorSource.WEBVIEW, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.resource.url", (Object)(sslError == null ? null : sslError.getUrl()))));
    }

    @NotNull
    public Map<String, Object> onProvideRumResourceAttributes(@Nullable WebView view, @Nullable String url) {
        return MapsKt.emptyMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/webview/RumWebViewClient$Companion;", "", "()V", "METHOD_GET", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

