/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.webview;

import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import com.datadog.android.log.Logger;
import com.datadog.android.rum.GlobalRum;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/rum/webview/RumWebChromeClient;", "Landroid/webkit/WebChromeClient;", "()V", "logger", "Lcom/datadog/android/log/Logger;", "(Lcom/datadog/android/log/Logger;)V", "onConsoleMessage", "", "consoleMessage", "Landroid/webkit/ConsoleMessage;", "toLogLevel", "", "Landroid/webkit/ConsoleMessage$MessageLevel;", "Companion", "dd-sdk-android_release"})
public class RumWebChromeClient
extends WebChromeClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String LOGGER_NAME = "WebChromeClient";
    @NotNull
    public static final String SOURCE_ID = "source.id";
    @NotNull
    public static final String SOURCE_LINE = "source.line";

    public RumWebChromeClient(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public RumWebChromeClient() {
        this(new Logger.Builder().setLoggerName(LOGGER_NAME).setNetworkInfoEnabled(true).build());
    }

    public boolean onConsoleMessage(@Nullable ConsoleMessage consoleMessage) {
        if (consoleMessage != null) {
            String message = consoleMessage.message();
            ConsoleMessage.MessageLevel level = consoleMessage.messageLevel();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SOURCE_ID, (Object)consoleMessage.sourceId()), TuplesKt.to((Object)SOURCE_LINE, (Object)consoleMessage.lineNumber())};
            Map attributes = MapsKt.mapOf((Pair[])pairArray);
            if (level == ConsoleMessage.MessageLevel.ERROR) {
                RumMonitor rumMonitor = GlobalRum.get();
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                rumMonitor.addError(message, RumErrorSource.WEBVIEW, null, attributes);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
                int n = this.toLogLevel(level);
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                this.logger.log(n, message, null, attributes);
            }
        }
        return false;
    }

    private final int toLogLevel(ConsoleMessage.MessageLevel $this$toLogLevel) {
        int n;
        ConsoleMessage.MessageLevel messageLevel = $this$toLogLevel;
        int n2 = WhenMappings.$EnumSwitchMapping$0[messageLevel.ordinal()];
        switch (n2) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/webview/RumWebChromeClient$Companion;", "", "()V", "LOGGER_NAME", "", "SOURCE_ID", "SOURCE_LINE", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConsoleMessage.MessageLevel.values().length];
            nArray[ConsoleMessage.MessageLevel.LOG.ordinal()] = 1;
            nArray[ConsoleMessage.MessageLevel.DEBUG.ordinal()] = 2;
            nArray[ConsoleMessage.MessageLevel.TIP.ordinal()] = 3;
            nArray[ConsoleMessage.MessageLevel.WARNING.ordinal()] = 4;
            nArray[ConsoleMessage.MessageLevel.ERROR.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

