/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.rum.internal.vitals.VitalReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/rum/internal/vitals/MemoryVitalReader;", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "statusFile", "Ljava/io/File;", "(Ljava/io/File;)V", "readVitalData", "", "()Ljava/lang/Double;", "Companion", "dd-sdk-android_release"})
public final class MemoryVitalReader
implements VitalReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File statusFile;
    @NotNull
    private static final String STATUS_PATH = "/proc/self/status";
    @NotNull
    private static final File STATUS_FILE = new File("/proc/self/status");
    @NotNull
    private static final String VM_RSS_PATTERN = "VmRSS:\\s+(\\d+) kB";
    @NotNull
    private static final Regex VM_RSS_REGEX = new Regex("VmRSS:\\s+(\\d+) kB");

    public MemoryVitalReader(@NotNull File statusFile) {
        Intrinsics.checkNotNullParameter((Object)statusFile, (String)"statusFile");
        this.statusFile = statusFile;
    }

    public /* synthetic */ MemoryVitalReader(File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = STATUS_FILE;
        }
        this(file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Double readVitalData() {
        Double memorySizeKb;
        void $this$mapNotNullTo$iv$iv;
        if (!FileExtKt.existsSafe(this.statusFile) || !FileExtKt.canReadSafe(this.statusFile)) {
            return null;
        }
        Iterable $this$mapNotNull$iv = FilesKt.readLines$default((File)this.statusFile, null, (int)1, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            List list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line = (String)element$iv$iv;
            boolean bl2 = false;
            MatchResult matchResult = VM_RSS_REGEX.matchEntire((CharSequence)line);
            if ((matchResult == null ? null : ((list = matchResult.getGroupValues()) == null ? null : (String)list.get(1))) == null) continue;
            string = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        Double d = memorySizeKb = string == null ? null : StringsKt.toDoubleOrNull((String)string);
        if (memorySizeKb == null) {
            return null;
        }
        return memorySizeKb * (double)1000;
    }

    public MemoryVitalReader() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/rum/internal/vitals/MemoryVitalReader$Companion;", "", "()V", "STATUS_FILE", "Ljava/io/File;", "STATUS_PATH", "", "VM_RSS_PATTERN", "VM_RSS_REGEX", "Lkotlin/text/Regex;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

