/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.tracking;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewParent;
import androidx.recyclerview.widget.RecyclerView;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00060\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/rum/internal/tracking/JetpackViewAttributesProvider;", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "()V", "equals", "", "other", "", "extractAttributes", "", "view", "Landroid/view/View;", "attributes", "", "", "hashCode", "", "isDirectChildOfRecyclerView", "child", "resolveIdOrResourceName", "viewIdAsHexa", "dd-sdk-android_release"})
public final class JetpackViewAttributesProvider
implements ViewAttributesProvider {
    @Override
    public void extractAttributes(@NotNull View view, @NotNull Map<String, Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        View child = view;
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof RecyclerView && child != null && this.isDirectChildOfRecyclerView(child)) {
                int positionInAdapter = ((RecyclerView)parent).getChildAdapterPosition(child);
                Map<String, Object> map = attributes;
                String string = "action.target.parent.index";
                Object object = positionInAdapter;
                boolean bl = false;
                map.put(string, object);
                map = attributes;
                string = "action.target.parent.classname";
                object = parent;
                object = object.getClass().getCanonicalName();
                bl = false;
                map.put(string, object);
                map = attributes;
                string = "action.target.parent.resource_id";
                object = parent;
                object = this.resolveIdOrResourceName((View)object);
                bl = false;
                map.put(string, object);
                break;
            }
            ViewParent viewParent = parent;
            child = viewParent instanceof View ? (View)viewParent : null;
        }
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        return Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private final boolean isDirectChildOfRecyclerView(View child) {
        return child.getLayoutParams() instanceof RecyclerView.LayoutParams;
    }

    private final String resolveIdOrResourceName(View view) {
        String string;
        try {
            string = view.getResources().getResourceEntryName(view.getId());
            string = string == null ? this.viewIdAsHexa(view) : string;
        }
        catch (Resources.NotFoundException e) {
            string = this.viewIdAsHexa(view);
        }
        return string;
    }

    private final String viewIdAsHexa(View view) {
        int n = view.getId();
        int n2 = 16;
        boolean bl = false;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        return Intrinsics.stringPlus((String)"0x", (Object)string);
    }
}

